Necronomicon agent is a daemon that will watch for configuration deployments in Necronomicon and
reload services when the namespaces in their environment are updated.

Quickstart
===

Installation
---

Necronomicon agent can be installed as a debian package, through Puppet or other means of
configuration management. 

### Puppet

To install the agent with Puppet, include the `twitch_necro_agent` class in your puppet manifest.

To register a service with the agent, use the `twitch_necro_agent::service` define. The
`environment` and `namespaces` variables specify the environment and namespace(s) in
Necrononomicon to watch for changes. If a configuration deployment occurs which changes values in
the namespaces of the environment configured, then the agent will write an updated list of values to
`file` and call `reload`.

Example:
```
twitch_necro_agent::service { 'example':
  environment => 'prod',
  namespaces  => ['org/example', 'org/service'],
  file        => '/opt/twitch/example/shared/config.json',
  reload      => 'svc -du /etc/service/example'
```

### Other methods of installation

The Necronomicon agent is available as the `necronomicon-agent` package in the twitch apt repos.
The package installs a default configuration that should work out of the box. If you are not using
IAM instance profiles to provide your AWS credentials, you will need to set the profile to use in
your configuration file. See the Advanced Configuration section for details on how to do this.

To register a service with the agent, create a file in `/etc/necronomicon/services.d` with the `.service` extension. Begin the file with `[services.<service name>]` and set the configuration
values for the service. The `environment` and `namespaces` values specify the environment and namespace(s) in Necrononomicon to watch for changes. If a configuration deployment occurs which
changes values in the namespaces of the environment configured, then the agent will write an
updated list of values to `file` and call `reload`.

Example:
```
[services.example]
environment = "prod"
namespaces = ["org/example", "org/service"]
file = "/opt/twitch/example/shared/config.json"
reload = "svc -du /etc/service/example"
```

AWS policies for bucket access
---

Your AWS account will require access to Necronomicon's publishing bucket for the agent to function.
This bucket is `tw-prod-dta-necronomicon-api`. Contact
[@dta-team](slack://user?team=T0266V6GF&id=S0EBBFX1D) or
[devtools@twitch.tv](mailto:devtools@twitch.tv) to grant your AWS account access to the bucket.

After your account is granted access, you will need to add a policy statement for you IAM account
to access the bucket. Here is the statement you will need to add to your policy:
```
        {
            "Action": [
                "s3:GetObject",
                "s3:ListBucket"
            ],
            "Effect": "Allow",
            "Resource": [
                "arn:aws:s3:::tw-prod-dta-necronomicon-api/*",
                "arn:aws:s3:::tw-prod-dta-necronomicon-api"
            ]
        }
```

Advanced configuration
===

The /etc/necronomicon/necronomicon.conf file can be edited to provide advanced functionality. The
following options are available:

- `services_directory`

  The directory to read service entries from. Defaults to `/etc/necronomicon/services.d`.

### s3

The following options are in the [s3] section of the configuration file:

- `bucket`

  The bucket to read configuration deployments from. Defaults to `tw-prod-dta-necronomicon-api`.

- `profile`

  The AWS profile to use when connecting to S3. Unset by default.

- `region`

  The AWS region the s3 bucket is located. Defaults to `us-west-2`.

- `interval`

  The interval, in seconds, to check for configuration deployments. Defaults to 30.
