package main

import (
	"github.com/spf13/cobra"
	"fmt"
)

func init() {
	checkCmd := &cobra.Command{
		Use:     "check",
		Short:   "Check agent configuration",
		Long:    `Reads configuration files and checks for errors`,
		RunE:    runCheck,
	}
	cmd.AddCommand(checkCmd)
}

func runCheck(cmd *cobra.Command, args []string) error {
	err := loadConfig(cmd, args)
	if err == nil {
		fmt.Println("OK")
	} else {
		fmt.Println("ERROR -", err)
	}
	return nil
}
