Testing a Package Before Releasing
---

- Build the necrod command using `manta -f build.json`
- Specify the package version and iteration in `package/scripts/VERSION` and `package/scripts/ITERATION`
- Build the necronomicon-agent using `manta -f package.json`
- Copy the package created from `package/out` to your test machine
- Install the package manually with `dpkg -i <package file>`

Releasing
---

- Get your release changelog with `git log <previous release tag>..HEAD`
- Tag your release in git (`git tag x.y.z`). You can pass `-s` to GPG sign your tag. Let's try to follow [Linux kernel style versioning](https://en.wikipedia.org/wiki/Linux_kernel#Version_numbering), with third number increments representing bug and security fixes, no new features, second number increments representing new features, and periodically increasing the first number with milestones so the second number doesn't get too large.
- Upload your package using the [Jenkins job](https://jenkins.internal.justin.tv/job/dta-necronomicon-agent-deploy/). For the build parameters, pass your tag as the GIT\_BRANCH, and a number (starting at 1) as the PACKAGE\_ITERATION. The job will build the deb package and upload it to artifactory.
