job('dta-necronomicon-agent') {
  using 'TEMPLATE-autobuild'
  scm {
    git {
      remote {
        github 'dta/necronomicon-agent', 'ssh', 'git-aws.internal.justin.tv'
        credentials 'git-aws-read-key'
      }
    }
  }
  steps {
    shell 'manta -v -f build.json'
  }
}

job('dta-necronomicon-agent-deploy') {
    parameters {
        stringParam('GIT_BRANCH')
        stringParam('PACKAGE_ITERATION', '1')
    }
    scm {
        git {
            branch('$GIT_BRANCH')
            remote {
                github 'dta/necronomicon-agent', 'ssh', 'git-aws.internal.justin.tv'
                credentials 'git-aws-read-key'
            }
        }
    }
    steps {
        shell '''
manta -v -f build.json
echo \$GIT_BRANCH > package/scripts/VERSION
echo \$PACKAGE_ITERATION > package/scripts/ITERATION
mkdir -p package/out
manta -v -f package.json'''
        uploadDeb "package/out/necronomicon-agent_\${GIT_BRANCH}-\${PACKAGE_ITERATION}_all.deb", 'precise'
        uploadDeb "package/out/necronomicon-agent_\${GIT_BRANCH}-\${PACKAGE_ITERATION}_all.deb", 'trusty'
        uploadDeb "package/out/necronomicon-agent_\${GIT_BRANCH}-\${PACKAGE_ITERATION}_all.deb", 'xenial'
    }
        wrappers {
                sshAgent 'git-aws-read-key'
                preBuildCleanup()
                timestamps()
                credentialsBinding {
                    string 'dta_tools_deploy', 'dta_tools_deploy'
                }
        }
}
