User API reference
==================

Common request parameters
-------------------------

### ?datetime-format={unix|iso8601|rfc1123}

Timestamps are returned in the format requested.

Common request headers
----------------------

### Authorization

Should contain the text "Bearer {token}". {token} is the token returned by the OAuth authorization flow.

Snapshot resources
------------------

### GET /snapshots/

Returns a list of snapshots.

#### Request parameters

- ?limit={limit}

  The number of snapshots is limited by default to 20. This can be changed to a maximum of 100.

- ?from={from_datetime}&to={to_datetime}

  from and to specify a range of times to return snapshots from.

#### Response body

```json
[
    {
        "snapshot_id": 1,
        "user": "gkim",
        "message": "to the world",
        "timestamp": "Tue, 31 May 2016 15:07:32 GMT"
    },
    {
        "snapshot_id": 2,
        "user": "mbarnhill",
        "message": "i made up my mind",
        "timestamp": "Tue, 31 May 2016 15:12:10 GMT"
    },
    {
        "snapshot_id": 3,
        "user": "dnicklay",
        "message": "i’m doing things my way",
        "timestamp": "Tue, 31 May 2016 15:14:34 GMT"
    }
]
```

### GET /snapshots/{snapshot_id}

Returns detailed information about a snapshot.

#### Request parameters

- ?include-values={true|false}

  By default, the returned environments do not include values. If include-values is specified, the returned environments include values.

#### Response body

```json
{
    "user": "mbarnhill",
    "message": "i made up my mind",
    "timestamp": "Tue, 31 May 2016 15:12:10 GMT",
    "changes": {
        "default": [
            "web/webby"
        ],
        "production": [
            "web/webby",
            "video/videoy"
        ]
    }
}
```

### GET /snapshots/{snapshot_id}/environments

Returns the contents of all environments in a snapshot.

#### Response body

```json
{
    "default": {
        "parent": null,
        "values": {
            "chat/chatty": {
                "all_the_memes_enabled": true,
                "dankness_enhancer_disabled": false
            },
            "web/webby": {
                "html5_blink_site_enabled": true,
                "print_money_enabled": false
            },
            "video/videoy": {
                "divx_transcoding_enabled": true,
                "viewbot_singularity_disabled": false
            }
        }
    },
    "production": {
        "parent": "default",
        "values": {
            "chat/chatty": {
                "dankness_enhancer_disabled": true
            },
            "web/webby": {
                "print_money_enabled": true
            },
            "video/videoy": {
                "viewbot_singularity_disabled": true
            }
        },
    }
}

```

### GET /snapshots/{snapshot_id}/environments/{environment}

Returns the merged contents of an environment in a snapshot.

#### Response body

```json
{
    "name": "production",
    "values": {
        "chat/chatty": {
            "all_the_memes_enabled": true,
            "dankness_enhancer_disabled": true
        },
        "web/webby": {
            "html5_blink_site_enabled": true,
            "print_money_enabled": true
        },
        "video/videoy": {
            "divx_transcoding_enabled": true,
            "viewbot_singularity_disabled": true
        }
    }
}

```

### POST /snapshots/

Creates a new snapshot.

#### Request body

```json
{
    "message": "i made up my mind",
    "environments": [
        {
            "name": "dev",
            "operation": "set",
            "parent": "default",
            "values": {
                "chat/chatty": {
                    "dankness_enhancer_disabled": true
                }
            }
        },
        {
            "name": "test",
            "operation": "deleted"
        }
    ]
}
```

#### Response status

-   201 Accepted - successfully created

-   4xx/5xx - could not create

#### Response headers

-   Location: {link to created deployment}

-   Content-Type: application/json

#### Response body

```json
{
    "snapshot_id": 2,
    "user": "mbarnhill",
    "message": "i made up my mind",
    "timestamp": "Tue, 31 May 2016 15:07:32 GMT"
}
```


Deployment resources
--------------------

### GET /deployments/

Returns a list of deployments.

#### Request parameters

-   ?limit={limit}

> The number of deployments is limited by default to 20. This can be
> changed to a maximum of 100.

-   ?from={from_datetime}&to={to_datetime}

> from and to specify a range of times to return deployments from.

#### Response body

```json
[
    {
        "deployment_id": 7,
        "snapshot_id": 1,
        "user": "gkim",
        "message": "i could give it all up",
        "timestamp": "Tue, 31 May 2016 17:13:42 GMT"
    },
    {
        "deployment_id": 8,
        "snapshot_id": 2,
        "user": "mbarnhill",
        "message": "but it\u2019s not enough",
        "timestamp": "Tue, 31 May 2016 17:14:31 GMT"
    },
    {
        "deployment_id": 9,
        "snapshot_id": 3,
        "user": "dnicklay",
        "message": "here you go",
        "timestamp": "Tue, 31 May 2016 17:15:55 GMT"
    }
]
```

### POST /deployments/

Creates a new deployment.

#### Request body

```json
{
    "snapshot_id": 3,
    "message": "hills to the mountains",
}
```

#### Response status

-   201 Created - successfully created

-   4xx/5xx - could not create

#### Response headers

-   Location: {link to created deployment}

-   Content-Type: application/json

#### Response body

```json
{
    "deployment_id": 1,
    "snapshot_id": 7,
    "user": "gkim",
    "message": "i could give it all up",
    "timestamp": "Tue, 31 May 2016 17:13:42 GMT"
}
```

### GET /deployments/{deployment_id}

Returns detailed information about a deployment.

```json
{
    "deployment_id": 1,
    "snapshot_id": 7,
    "user": "gkim",
    "message": "i could give it all up",
    "timestamp": "Tue, 31 May 2016 17:13:42 GMT",
    "targets": {
        "default": [
            "web/webby"
        ],
        "production": [
            "web/webby",
            "video/videoy"
        ]
    },
    "agents": [
        {
            "status": "success",
            "timestamp": "Tue, 31 May 2016 17:14:11 GMT",
            "name": "web-staging-1-b00f3e68"
        },
        {
            "status": "pending",
            "timestamp": "Tue, 31 May 2016 17:14:06 GMT",
            "name": "web-staging-2-66918bbc"
        },
        {
            "status": "failure",
            "timestamp": "Tue, 31 May 2016 17:14:13 GMT",
            "name": "web-staging-3-9eacbc59"
        }
    ]
}
```
