// Code generated by goagen v1.1.0-dirty, command line:
// $ goagen
// --design=code.justin.tv/dta/necronomicon-user-api/design
// --out=$(GOPATH)/src/code.justin.tv/dta/necronomicon-user-api
// --version=v1.1.0-dirty
//
// API "Necronomicon User API": Application Contexts
//
// The content of this file is auto-generated, DO NOT MODIFY

package app

import (
	"github.com/goadesign/goa"
	"golang.org/x/net/context"
	"strconv"
	"time"
)

// CreateDeploymentContext provides the deployment create action context.
type CreateDeploymentContext struct {
	context.Context
	*goa.ResponseData
	*goa.RequestData
	DatetimeFormat *string
	Payload        *DeploymentPayload
}

// NewCreateDeploymentContext parses the incoming request URL and body, performs validations and creates the
// context used by the deployment controller create action.
func NewCreateDeploymentContext(ctx context.Context, service *goa.Service) (*CreateDeploymentContext, error) {
	var err error
	resp := goa.ContextResponse(ctx)
	resp.Service = service
	req := goa.ContextRequest(ctx)
	rctx := CreateDeploymentContext{Context: ctx, ResponseData: resp, RequestData: req}
	paramDatetimeFormat := req.Params["datetime-format"]
	if len(paramDatetimeFormat) > 0 {
		rawDatetimeFormat := paramDatetimeFormat[0]
		rctx.DatetimeFormat = &rawDatetimeFormat
		if rctx.DatetimeFormat != nil {
			if !(*rctx.DatetimeFormat == "unix" || *rctx.DatetimeFormat == "iso8601" || *rctx.DatetimeFormat == "rfc1123") {
				err = goa.MergeErrors(err, goa.InvalidEnumValueError(`datetime-format`, *rctx.DatetimeFormat, []interface{}{"unix", "iso8601", "rfc1123"}))
			}
		}
	}
	return &rctx, err
}

// Created sends a HTTP response with status code 201.
func (ctx *CreateDeploymentContext) Created() error {
	ctx.ResponseData.WriteHeader(201)
	return nil
}

// BadRequest sends a HTTP response with status code 400.
func (ctx *CreateDeploymentContext) BadRequest(r error) error {
	ctx.ResponseData.Header().Set("Content-Type", "application/vnd.goa.error")
	return ctx.ResponseData.Service.Send(ctx.Context, 400, r)
}

// Unauthorized sends a HTTP response with status code 401.
func (ctx *CreateDeploymentContext) Unauthorized() error {
	ctx.ResponseData.WriteHeader(401)
	return nil
}

// ListDeploymentContext provides the deployment list action context.
type ListDeploymentContext struct {
	context.Context
	*goa.ResponseData
	*goa.RequestData
	DatetimeFormat *string
	From           *time.Time
	Limit          int
	To             *time.Time
}

// NewListDeploymentContext parses the incoming request URL and body, performs validations and creates the
// context used by the deployment controller list action.
func NewListDeploymentContext(ctx context.Context, service *goa.Service) (*ListDeploymentContext, error) {
	var err error
	resp := goa.ContextResponse(ctx)
	resp.Service = service
	req := goa.ContextRequest(ctx)
	rctx := ListDeploymentContext{Context: ctx, ResponseData: resp, RequestData: req}
	paramDatetimeFormat := req.Params["datetime-format"]
	if len(paramDatetimeFormat) > 0 {
		rawDatetimeFormat := paramDatetimeFormat[0]
		rctx.DatetimeFormat = &rawDatetimeFormat
		if rctx.DatetimeFormat != nil {
			if !(*rctx.DatetimeFormat == "unix" || *rctx.DatetimeFormat == "iso8601" || *rctx.DatetimeFormat == "rfc1123") {
				err = goa.MergeErrors(err, goa.InvalidEnumValueError(`datetime-format`, *rctx.DatetimeFormat, []interface{}{"unix", "iso8601", "rfc1123"}))
			}
		}
	}
	paramFrom := req.Params["from"]
	if len(paramFrom) > 0 {
		rawFrom := paramFrom[0]
		if from, err2 := time.Parse(time.RFC3339, rawFrom); err2 == nil {
			tmp1 := &from
			rctx.From = tmp1
		} else {
			err = goa.MergeErrors(err, goa.InvalidParamTypeError("from", rawFrom, "datetime"))
		}
	}
	paramLimit := req.Params["limit"]
	if len(paramLimit) > 0 {
		rawLimit := paramLimit[0]
		if limit, err2 := strconv.Atoi(rawLimit); err2 == nil {
			rctx.Limit = limit
		} else {
			err = goa.MergeErrors(err, goa.InvalidParamTypeError("limit", rawLimit, "integer"))
		}
		if rctx.Limit < 1 {
			err = goa.MergeErrors(err, goa.InvalidRangeError(`limit`, rctx.Limit, 1, true))
		}
		if rctx.Limit > 100 {
			err = goa.MergeErrors(err, goa.InvalidRangeError(`limit`, rctx.Limit, 100, false))
		}
	}
	paramTo := req.Params["to"]
	if len(paramTo) > 0 {
		rawTo := paramTo[0]
		if to, err2 := time.Parse(time.RFC3339, rawTo); err2 == nil {
			tmp3 := &to
			rctx.To = tmp3
		} else {
			err = goa.MergeErrors(err, goa.InvalidParamTypeError("to", rawTo, "datetime"))
		}
	}
	return &rctx, err
}

// OK sends a HTTP response with status code 200.
func (ctx *ListDeploymentContext) OK(r TwitchDtaNecronomiconUserapiDeploymentCollection) error {
	ctx.ResponseData.Header().Set("Content-Type", "application/vnd.twitch.dta.necronomicon.userapi.deployment+json; type=collection")
	if r == nil {
		r = TwitchDtaNecronomiconUserapiDeploymentCollection{}
	}
	return ctx.ResponseData.Service.Send(ctx.Context, 200, r)
}

// OKListed sends a HTTP response with status code 200.
func (ctx *ListDeploymentContext) OKListed(r TwitchDtaNecronomiconUserapiDeploymentListedCollection) error {
	ctx.ResponseData.Header().Set("Content-Type", "application/vnd.twitch.dta.necronomicon.userapi.deployment+json; type=collection")
	if r == nil {
		r = TwitchDtaNecronomiconUserapiDeploymentListedCollection{}
	}
	return ctx.ResponseData.Service.Send(ctx.Context, 200, r)
}

// PreviewDeploymentContext provides the deployment preview action context.
type PreviewDeploymentContext struct {
	context.Context
	*goa.ResponseData
	*goa.RequestData
	DatetimeFormat *string
	Payload        *DeploymentPayload
}

// NewPreviewDeploymentContext parses the incoming request URL and body, performs validations and creates the
// context used by the deployment controller preview action.
func NewPreviewDeploymentContext(ctx context.Context, service *goa.Service) (*PreviewDeploymentContext, error) {
	var err error
	resp := goa.ContextResponse(ctx)
	resp.Service = service
	req := goa.ContextRequest(ctx)
	rctx := PreviewDeploymentContext{Context: ctx, ResponseData: resp, RequestData: req}
	paramDatetimeFormat := req.Params["datetime-format"]
	if len(paramDatetimeFormat) > 0 {
		rawDatetimeFormat := paramDatetimeFormat[0]
		rctx.DatetimeFormat = &rawDatetimeFormat
		if rctx.DatetimeFormat != nil {
			if !(*rctx.DatetimeFormat == "unix" || *rctx.DatetimeFormat == "iso8601" || *rctx.DatetimeFormat == "rfc1123") {
				err = goa.MergeErrors(err, goa.InvalidEnumValueError(`datetime-format`, *rctx.DatetimeFormat, []interface{}{"unix", "iso8601", "rfc1123"}))
			}
		}
	}
	return &rctx, err
}

// OK sends a HTTP response with status code 200.
func (ctx *PreviewDeploymentContext) OK(r *TwitchDtaNecronomiconUserapiSnapshotStatemap) error {
	ctx.ResponseData.Header().Set("Content-Type", "application/vnd.twitch.dta.necronomicon.userapi.snapshot.statemap+json")
	return ctx.ResponseData.Service.Send(ctx.Context, 200, r)
}

// BadRequest sends a HTTP response with status code 400.
func (ctx *PreviewDeploymentContext) BadRequest(r error) error {
	ctx.ResponseData.Header().Set("Content-Type", "application/vnd.goa.error")
	return ctx.ResponseData.Service.Send(ctx.Context, 400, r)
}

// ShowDeploymentContext provides the deployment show action context.
type ShowDeploymentContext struct {
	context.Context
	*goa.ResponseData
	*goa.RequestData
	DatetimeFormat *string
	DeploymentID   int
}

// NewShowDeploymentContext parses the incoming request URL and body, performs validations and creates the
// context used by the deployment controller show action.
func NewShowDeploymentContext(ctx context.Context, service *goa.Service) (*ShowDeploymentContext, error) {
	var err error
	resp := goa.ContextResponse(ctx)
	resp.Service = service
	req := goa.ContextRequest(ctx)
	rctx := ShowDeploymentContext{Context: ctx, ResponseData: resp, RequestData: req}
	paramDatetimeFormat := req.Params["datetime-format"]
	if len(paramDatetimeFormat) > 0 {
		rawDatetimeFormat := paramDatetimeFormat[0]
		rctx.DatetimeFormat = &rawDatetimeFormat
		if rctx.DatetimeFormat != nil {
			if !(*rctx.DatetimeFormat == "unix" || *rctx.DatetimeFormat == "iso8601" || *rctx.DatetimeFormat == "rfc1123") {
				err = goa.MergeErrors(err, goa.InvalidEnumValueError(`datetime-format`, *rctx.DatetimeFormat, []interface{}{"unix", "iso8601", "rfc1123"}))
			}
		}
	}
	paramDeploymentID := req.Params["deployment_id"]
	if len(paramDeploymentID) > 0 {
		rawDeploymentID := paramDeploymentID[0]
		if deploymentID, err2 := strconv.Atoi(rawDeploymentID); err2 == nil {
			rctx.DeploymentID = deploymentID
		} else {
			err = goa.MergeErrors(err, goa.InvalidParamTypeError("deployment_id", rawDeploymentID, "integer"))
		}
	}
	return &rctx, err
}

// OK sends a HTTP response with status code 200.
func (ctx *ShowDeploymentContext) OK(r *TwitchDtaNecronomiconUserapiDeployment) error {
	ctx.ResponseData.Header().Set("Content-Type", "application/vnd.twitch.dta.necronomicon.userapi.deployment+json")
	return ctx.ResponseData.Service.Send(ctx.Context, 200, r)
}

// OKListed sends a HTTP response with status code 200.
func (ctx *ShowDeploymentContext) OKListed(r *TwitchDtaNecronomiconUserapiDeploymentListed) error {
	ctx.ResponseData.Header().Set("Content-Type", "application/vnd.twitch.dta.necronomicon.userapi.deployment+json")
	return ctx.ResponseData.Service.Send(ctx.Context, 200, r)
}

// NotFound sends a HTTP response with status code 404.
func (ctx *ShowDeploymentContext) NotFound() error {
	ctx.ResponseData.WriteHeader(404)
	return nil
}

// ListEnvironmentContext provides the environment list action context.
type ListEnvironmentContext struct {
	context.Context
	*goa.ResponseData
	*goa.RequestData
	DatetimeFormat *string
	SnapshotID     int
}

// NewListEnvironmentContext parses the incoming request URL and body, performs validations and creates the
// context used by the environment controller list action.
func NewListEnvironmentContext(ctx context.Context, service *goa.Service) (*ListEnvironmentContext, error) {
	var err error
	resp := goa.ContextResponse(ctx)
	resp.Service = service
	req := goa.ContextRequest(ctx)
	rctx := ListEnvironmentContext{Context: ctx, ResponseData: resp, RequestData: req}
	paramDatetimeFormat := req.Params["datetime-format"]
	if len(paramDatetimeFormat) > 0 {
		rawDatetimeFormat := paramDatetimeFormat[0]
		rctx.DatetimeFormat = &rawDatetimeFormat
		if rctx.DatetimeFormat != nil {
			if !(*rctx.DatetimeFormat == "unix" || *rctx.DatetimeFormat == "iso8601" || *rctx.DatetimeFormat == "rfc1123") {
				err = goa.MergeErrors(err, goa.InvalidEnumValueError(`datetime-format`, *rctx.DatetimeFormat, []interface{}{"unix", "iso8601", "rfc1123"}))
			}
		}
	}
	paramSnapshotID := req.Params["snapshot_id"]
	if len(paramSnapshotID) > 0 {
		rawSnapshotID := paramSnapshotID[0]
		if snapshotID, err2 := strconv.Atoi(rawSnapshotID); err2 == nil {
			rctx.SnapshotID = snapshotID
		} else {
			err = goa.MergeErrors(err, goa.InvalidParamTypeError("snapshot_id", rawSnapshotID, "integer"))
		}
	}
	return &rctx, err
}

// OK sends a HTTP response with status code 200.
func (ctx *ListEnvironmentContext) OK(r EnvironmentMediaCollection) error {
	ctx.ResponseData.Header().Set("Content-Type", "application/vnd.twitch.dta.necronomicon.userapi.environment+json; type=collection")
	if r == nil {
		r = EnvironmentMediaCollection{}
	}
	return ctx.ResponseData.Service.Send(ctx.Context, 200, r)
}

// NotFound sends a HTTP response with status code 404.
func (ctx *ListEnvironmentContext) NotFound() error {
	ctx.ResponseData.WriteHeader(404)
	return nil
}

// ShowEnvironmentContext provides the environment show action context.
type ShowEnvironmentContext struct {
	context.Context
	*goa.ResponseData
	*goa.RequestData
	DatetimeFormat *string
	Environment    string
	SnapshotID     int
}

// NewShowEnvironmentContext parses the incoming request URL and body, performs validations and creates the
// context used by the environment controller show action.
func NewShowEnvironmentContext(ctx context.Context, service *goa.Service) (*ShowEnvironmentContext, error) {
	var err error
	resp := goa.ContextResponse(ctx)
	resp.Service = service
	req := goa.ContextRequest(ctx)
	rctx := ShowEnvironmentContext{Context: ctx, ResponseData: resp, RequestData: req}
	paramDatetimeFormat := req.Params["datetime-format"]
	if len(paramDatetimeFormat) > 0 {
		rawDatetimeFormat := paramDatetimeFormat[0]
		rctx.DatetimeFormat = &rawDatetimeFormat
		if rctx.DatetimeFormat != nil {
			if !(*rctx.DatetimeFormat == "unix" || *rctx.DatetimeFormat == "iso8601" || *rctx.DatetimeFormat == "rfc1123") {
				err = goa.MergeErrors(err, goa.InvalidEnumValueError(`datetime-format`, *rctx.DatetimeFormat, []interface{}{"unix", "iso8601", "rfc1123"}))
			}
		}
	}
	paramEnvironment := req.Params["environment"]
	if len(paramEnvironment) > 0 {
		rawEnvironment := paramEnvironment[0]
		rctx.Environment = rawEnvironment
	}
	paramSnapshotID := req.Params["snapshot_id"]
	if len(paramSnapshotID) > 0 {
		rawSnapshotID := paramSnapshotID[0]
		if snapshotID, err2 := strconv.Atoi(rawSnapshotID); err2 == nil {
			rctx.SnapshotID = snapshotID
		} else {
			err = goa.MergeErrors(err, goa.InvalidParamTypeError("snapshot_id", rawSnapshotID, "integer"))
		}
	}
	return &rctx, err
}

// OK sends a HTTP response with status code 200.
func (ctx *ShowEnvironmentContext) OK(r *EnvironmentMedia) error {
	ctx.ResponseData.Header().Set("Content-Type", "application/json")
	return ctx.ResponseData.Service.Send(ctx.Context, 200, r)
}

// OKMerged sends a HTTP response with status code 200.
func (ctx *ShowEnvironmentContext) OKMerged(r *EnvironmentMediaMerged) error {
	ctx.ResponseData.Header().Set("Content-Type", "application/json")
	return ctx.ResponseData.Service.Send(ctx.Context, 200, r)
}

// NotFound sends a HTTP response with status code 404.
func (ctx *ShowEnvironmentContext) NotFound() error {
	ctx.ResponseData.WriteHeader(404)
	return nil
}

// CreateSnapshotContext provides the snapshot create action context.
type CreateSnapshotContext struct {
	context.Context
	*goa.ResponseData
	*goa.RequestData
	DatetimeFormat *string
	Payload        *SnapshotPayload
}

// NewCreateSnapshotContext parses the incoming request URL and body, performs validations and creates the
// context used by the snapshot controller create action.
func NewCreateSnapshotContext(ctx context.Context, service *goa.Service) (*CreateSnapshotContext, error) {
	var err error
	resp := goa.ContextResponse(ctx)
	resp.Service = service
	req := goa.ContextRequest(ctx)
	rctx := CreateSnapshotContext{Context: ctx, ResponseData: resp, RequestData: req}
	paramDatetimeFormat := req.Params["datetime-format"]
	if len(paramDatetimeFormat) > 0 {
		rawDatetimeFormat := paramDatetimeFormat[0]
		rctx.DatetimeFormat = &rawDatetimeFormat
		if rctx.DatetimeFormat != nil {
			if !(*rctx.DatetimeFormat == "unix" || *rctx.DatetimeFormat == "iso8601" || *rctx.DatetimeFormat == "rfc1123") {
				err = goa.MergeErrors(err, goa.InvalidEnumValueError(`datetime-format`, *rctx.DatetimeFormat, []interface{}{"unix", "iso8601", "rfc1123"}))
			}
		}
	}
	return &rctx, err
}

// Created sends a HTTP response with status code 201.
func (ctx *CreateSnapshotContext) Created() error {
	ctx.ResponseData.WriteHeader(201)
	return nil
}

// Unauthorized sends a HTTP response with status code 401.
func (ctx *CreateSnapshotContext) Unauthorized() error {
	ctx.ResponseData.WriteHeader(401)
	return nil
}

// ListSnapshotContext provides the snapshot list action context.
type ListSnapshotContext struct {
	context.Context
	*goa.ResponseData
	*goa.RequestData
	DatetimeFormat *string
	From           *time.Time
	Limit          int
	To             *time.Time
}

// NewListSnapshotContext parses the incoming request URL and body, performs validations and creates the
// context used by the snapshot controller list action.
func NewListSnapshotContext(ctx context.Context, service *goa.Service) (*ListSnapshotContext, error) {
	var err error
	resp := goa.ContextResponse(ctx)
	resp.Service = service
	req := goa.ContextRequest(ctx)
	rctx := ListSnapshotContext{Context: ctx, ResponseData: resp, RequestData: req}
	paramDatetimeFormat := req.Params["datetime-format"]
	if len(paramDatetimeFormat) > 0 {
		rawDatetimeFormat := paramDatetimeFormat[0]
		rctx.DatetimeFormat = &rawDatetimeFormat
		if rctx.DatetimeFormat != nil {
			if !(*rctx.DatetimeFormat == "unix" || *rctx.DatetimeFormat == "iso8601" || *rctx.DatetimeFormat == "rfc1123") {
				err = goa.MergeErrors(err, goa.InvalidEnumValueError(`datetime-format`, *rctx.DatetimeFormat, []interface{}{"unix", "iso8601", "rfc1123"}))
			}
		}
	}
	paramFrom := req.Params["from"]
	if len(paramFrom) > 0 {
		rawFrom := paramFrom[0]
		if from, err2 := time.Parse(time.RFC3339, rawFrom); err2 == nil {
			tmp7 := &from
			rctx.From = tmp7
		} else {
			err = goa.MergeErrors(err, goa.InvalidParamTypeError("from", rawFrom, "datetime"))
		}
	}
	paramLimit := req.Params["limit"]
	if len(paramLimit) > 0 {
		rawLimit := paramLimit[0]
		if limit, err2 := strconv.Atoi(rawLimit); err2 == nil {
			rctx.Limit = limit
		} else {
			err = goa.MergeErrors(err, goa.InvalidParamTypeError("limit", rawLimit, "integer"))
		}
		if rctx.Limit < 1 {
			err = goa.MergeErrors(err, goa.InvalidRangeError(`limit`, rctx.Limit, 1, true))
		}
		if rctx.Limit > 100 {
			err = goa.MergeErrors(err, goa.InvalidRangeError(`limit`, rctx.Limit, 100, false))
		}
	}
	paramTo := req.Params["to"]
	if len(paramTo) > 0 {
		rawTo := paramTo[0]
		if to, err2 := time.Parse(time.RFC3339, rawTo); err2 == nil {
			tmp9 := &to
			rctx.To = tmp9
		} else {
			err = goa.MergeErrors(err, goa.InvalidParamTypeError("to", rawTo, "datetime"))
		}
	}
	return &rctx, err
}

// OK sends a HTTP response with status code 200.
func (ctx *ListSnapshotContext) OK(r SnapshotMediaCollection) error {
	ctx.ResponseData.Header().Set("Content-Type", "application/vnd.twitch.dta.necronomicon.userapi.snapshot+json; type=collection")
	if r == nil {
		r = SnapshotMediaCollection{}
	}
	return ctx.ResponseData.Service.Send(ctx.Context, 200, r)
}

// OKListed sends a HTTP response with status code 200.
func (ctx *ListSnapshotContext) OKListed(r SnapshotMediaListedCollection) error {
	ctx.ResponseData.Header().Set("Content-Type", "application/vnd.twitch.dta.necronomicon.userapi.snapshot+json; type=collection")
	if r == nil {
		r = SnapshotMediaListedCollection{}
	}
	return ctx.ResponseData.Service.Send(ctx.Context, 200, r)
}

// ShowSnapshotContext provides the snapshot show action context.
type ShowSnapshotContext struct {
	context.Context
	*goa.ResponseData
	*goa.RequestData
	DatetimeFormat *string
	SnapshotID     int
}

// NewShowSnapshotContext parses the incoming request URL and body, performs validations and creates the
// context used by the snapshot controller show action.
func NewShowSnapshotContext(ctx context.Context, service *goa.Service) (*ShowSnapshotContext, error) {
	var err error
	resp := goa.ContextResponse(ctx)
	resp.Service = service
	req := goa.ContextRequest(ctx)
	rctx := ShowSnapshotContext{Context: ctx, ResponseData: resp, RequestData: req}
	paramDatetimeFormat := req.Params["datetime-format"]
	if len(paramDatetimeFormat) > 0 {
		rawDatetimeFormat := paramDatetimeFormat[0]
		rctx.DatetimeFormat = &rawDatetimeFormat
		if rctx.DatetimeFormat != nil {
			if !(*rctx.DatetimeFormat == "unix" || *rctx.DatetimeFormat == "iso8601" || *rctx.DatetimeFormat == "rfc1123") {
				err = goa.MergeErrors(err, goa.InvalidEnumValueError(`datetime-format`, *rctx.DatetimeFormat, []interface{}{"unix", "iso8601", "rfc1123"}))
			}
		}
	}
	paramSnapshotID := req.Params["snapshot_id"]
	if len(paramSnapshotID) > 0 {
		rawSnapshotID := paramSnapshotID[0]
		if snapshotID, err2 := strconv.Atoi(rawSnapshotID); err2 == nil {
			rctx.SnapshotID = snapshotID
		} else {
			err = goa.MergeErrors(err, goa.InvalidParamTypeError("snapshot_id", rawSnapshotID, "integer"))
		}
	}
	return &rctx, err
}

// OK sends a HTTP response with status code 200.
func (ctx *ShowSnapshotContext) OK(r *SnapshotMedia) error {
	ctx.ResponseData.Header().Set("Content-Type", "application/json")
	return ctx.ResponseData.Service.Send(ctx.Context, 200, r)
}

// OKListed sends a HTTP response with status code 200.
func (ctx *ShowSnapshotContext) OKListed(r *SnapshotMediaListed) error {
	ctx.ResponseData.Header().Set("Content-Type", "application/json")
	return ctx.ResponseData.Service.Send(ctx.Context, 200, r)
}

// NotFound sends a HTTP response with status code 404.
func (ctx *ShowSnapshotContext) NotFound() error {
	ctx.ResponseData.WriteHeader(404)
	return nil
}
