// Code generated by goagen v1.1.0-dirty, command line:
// $ goagen
// --design=code.justin.tv/dta/necronomicon-user-api/design
// --out=$(GOPATH)/src/code.justin.tv/dta/necronomicon-user-api
// --version=v1.1.0-dirty
//
// API "Necronomicon User API": Application Controllers
//
// The content of this file is auto-generated, DO NOT MODIFY

package app

import (
	"github.com/goadesign/goa"
	"github.com/goadesign/goa/cors"
	"golang.org/x/net/context"
	"net/http"
)

// initService sets up the service encoders, decoders and mux.
func initService(service *goa.Service) {
	// Setup encoders and decoders
	service.Encoder.Register(goa.NewJSONEncoder, "application/json")
	service.Decoder.Register(goa.NewJSONDecoder, "application/json")

	// Setup default encoder and decoder
	service.Encoder.Register(goa.NewJSONEncoder, "*/*")
	service.Decoder.Register(goa.NewJSONDecoder, "*/*")
}

// DeploymentController is the controller interface for the Deployment actions.
type DeploymentController interface {
	goa.Muxer
	Create(*CreateDeploymentContext) error
	List(*ListDeploymentContext) error
	Preview(*PreviewDeploymentContext) error
	Show(*ShowDeploymentContext) error
}

// MountDeploymentController "mounts" a Deployment resource controller on the given service.
func MountDeploymentController(service *goa.Service, ctrl DeploymentController) {
	initService(service)
	var h goa.Handler

	h = func(ctx context.Context, rw http.ResponseWriter, req *http.Request) error {
		// Check if there was an error loading the request
		if err := goa.ContextError(ctx); err != nil {
			return err
		}
		// Build the context
		rctx, err := NewCreateDeploymentContext(ctx, service)
		if err != nil {
			return err
		}
		// Build the payload
		if rawPayload := goa.ContextRequest(ctx).Payload; rawPayload != nil {
			rctx.Payload = rawPayload.(*DeploymentPayload)
		} else {
			return goa.MissingPayloadError()
		}
		return ctrl.Create(rctx)
	}
	h = handleSecurity("basic_auth", h)
	service.Mux.Handle("POST", "/deployments", ctrl.MuxHandler("Create", h, unmarshalCreateDeploymentPayload))
	service.LogInfo("mount", "ctrl", "Deployment", "action", "Create", "route", "POST /deployments", "security", "basic_auth")

	h = func(ctx context.Context, rw http.ResponseWriter, req *http.Request) error {
		// Check if there was an error loading the request
		if err := goa.ContextError(ctx); err != nil {
			return err
		}
		// Build the context
		rctx, err := NewListDeploymentContext(ctx, service)
		if err != nil {
			return err
		}
		return ctrl.List(rctx)
	}
	service.Mux.Handle("GET", "/deployments", ctrl.MuxHandler("List", h, nil))
	service.LogInfo("mount", "ctrl", "Deployment", "action", "List", "route", "GET /deployments")

	h = func(ctx context.Context, rw http.ResponseWriter, req *http.Request) error {
		// Check if there was an error loading the request
		if err := goa.ContextError(ctx); err != nil {
			return err
		}
		// Build the context
		rctx, err := NewPreviewDeploymentContext(ctx, service)
		if err != nil {
			return err
		}
		// Build the payload
		if rawPayload := goa.ContextRequest(ctx).Payload; rawPayload != nil {
			rctx.Payload = rawPayload.(*DeploymentPayload)
		} else {
			return goa.MissingPayloadError()
		}
		return ctrl.Preview(rctx)
	}
	service.Mux.Handle("POST", "/deployments/preview", ctrl.MuxHandler("Preview", h, unmarshalPreviewDeploymentPayload))
	service.LogInfo("mount", "ctrl", "Deployment", "action", "Preview", "route", "POST /deployments/preview")

	h = func(ctx context.Context, rw http.ResponseWriter, req *http.Request) error {
		// Check if there was an error loading the request
		if err := goa.ContextError(ctx); err != nil {
			return err
		}
		// Build the context
		rctx, err := NewShowDeploymentContext(ctx, service)
		if err != nil {
			return err
		}
		return ctrl.Show(rctx)
	}
	service.Mux.Handle("GET", "/deployments/:deployment_id", ctrl.MuxHandler("Show", h, nil))
	service.LogInfo("mount", "ctrl", "Deployment", "action", "Show", "route", "GET /deployments/:deployment_id")
}

// unmarshalCreateDeploymentPayload unmarshals the request body into the context request data Payload field.
func unmarshalCreateDeploymentPayload(ctx context.Context, service *goa.Service, req *http.Request) error {
	payload := &deploymentPayload{}
	if err := service.DecodeRequest(req, payload); err != nil {
		return err
	}
	if err := payload.Validate(); err != nil {
		// Initialize payload with private data structure so it can be logged
		goa.ContextRequest(ctx).Payload = payload
		return err
	}
	goa.ContextRequest(ctx).Payload = payload.Publicize()
	return nil
}

// unmarshalPreviewDeploymentPayload unmarshals the request body into the context request data Payload field.
func unmarshalPreviewDeploymentPayload(ctx context.Context, service *goa.Service, req *http.Request) error {
	payload := &deploymentPayload{}
	if err := service.DecodeRequest(req, payload); err != nil {
		return err
	}
	if err := payload.Validate(); err != nil {
		// Initialize payload with private data structure so it can be logged
		goa.ContextRequest(ctx).Payload = payload
		return err
	}
	goa.ContextRequest(ctx).Payload = payload.Publicize()
	return nil
}

// EnvironmentController is the controller interface for the Environment actions.
type EnvironmentController interface {
	goa.Muxer
	List(*ListEnvironmentContext) error
	Show(*ShowEnvironmentContext) error
}

// MountEnvironmentController "mounts" a Environment resource controller on the given service.
func MountEnvironmentController(service *goa.Service, ctrl EnvironmentController) {
	initService(service)
	var h goa.Handler

	h = func(ctx context.Context, rw http.ResponseWriter, req *http.Request) error {
		// Check if there was an error loading the request
		if err := goa.ContextError(ctx); err != nil {
			return err
		}
		// Build the context
		rctx, err := NewListEnvironmentContext(ctx, service)
		if err != nil {
			return err
		}
		return ctrl.List(rctx)
	}
	service.Mux.Handle("GET", "/snapshots/:snapshot_id/environments", ctrl.MuxHandler("List", h, nil))
	service.LogInfo("mount", "ctrl", "Environment", "action", "List", "route", "GET /snapshots/:snapshot_id/environments")

	h = func(ctx context.Context, rw http.ResponseWriter, req *http.Request) error {
		// Check if there was an error loading the request
		if err := goa.ContextError(ctx); err != nil {
			return err
		}
		// Build the context
		rctx, err := NewShowEnvironmentContext(ctx, service)
		if err != nil {
			return err
		}
		return ctrl.Show(rctx)
	}
	service.Mux.Handle("GET", "/snapshots/:snapshot_id/environments/:environment", ctrl.MuxHandler("Show", h, nil))
	service.LogInfo("mount", "ctrl", "Environment", "action", "Show", "route", "GET /snapshots/:snapshot_id/environments/:environment")
}

// PublicController is the controller interface for the Public actions.
type PublicController interface {
	goa.Muxer
	goa.FileServer
}

// MountPublicController "mounts" a Public resource controller on the given service.
func MountPublicController(service *goa.Service, ctrl PublicController) {
	initService(service)
	var h goa.Handler
	service.Mux.Handle("OPTIONS", "/ui/*filepath", ctrl.MuxHandler("preflight", handlePublicOrigin(cors.HandlePreflight()), nil))
	service.Mux.Handle("OPTIONS", "/schema.json", ctrl.MuxHandler("preflight", handlePublicOrigin(cors.HandlePreflight()), nil))
	service.Mux.Handle("OPTIONS", "/swagger.json", ctrl.MuxHandler("preflight", handlePublicOrigin(cors.HandlePreflight()), nil))

	h = ctrl.FileHandler("/ui/*filepath", "public/swagger-ui/")
	h = handlePublicOrigin(h)
	service.Mux.Handle("GET", "/ui/*filepath", ctrl.MuxHandler("serve", h, nil))
	service.LogInfo("mount", "ctrl", "Public", "files", "public/swagger-ui/", "route", "GET /ui/*filepath")

	h = ctrl.FileHandler("/schema.json", "schema/schema.json")
	h = handlePublicOrigin(h)
	service.Mux.Handle("GET", "/schema.json", ctrl.MuxHandler("serve", h, nil))
	service.LogInfo("mount", "ctrl", "Public", "files", "schema/schema.json", "route", "GET /schema.json")

	h = ctrl.FileHandler("/swagger.json", "swagger/swagger.json")
	h = handlePublicOrigin(h)
	service.Mux.Handle("GET", "/swagger.json", ctrl.MuxHandler("serve", h, nil))
	service.LogInfo("mount", "ctrl", "Public", "files", "swagger/swagger.json", "route", "GET /swagger.json")

	h = ctrl.FileHandler("/ui/", "public/swagger-ui/index.html")
	h = handlePublicOrigin(h)
	service.Mux.Handle("GET", "/ui/", ctrl.MuxHandler("serve", h, nil))
	service.LogInfo("mount", "ctrl", "Public", "files", "public/swagger-ui/index.html", "route", "GET /ui/")
}

// handlePublicOrigin applies the CORS response headers corresponding to the origin.
func handlePublicOrigin(h goa.Handler) goa.Handler {

	return func(ctx context.Context, rw http.ResponseWriter, req *http.Request) error {
		origin := req.Header.Get("Origin")
		if origin == "" {
			// Not a CORS request
			return h(ctx, rw, req)
		}
		if cors.MatchOrigin(origin, "*") {
			ctx = goa.WithLogContext(ctx, "origin", origin)
			rw.Header().Set("Access-Control-Allow-Origin", origin)
			rw.Header().Set("Access-Control-Allow-Credentials", "false")
			if acrm := req.Header.Get("Access-Control-Request-Method"); acrm != "" {
				// We are handling a preflight request
				rw.Header().Set("Access-Control-Allow-Methods", "GET")
			}
			return h(ctx, rw, req)
		}

		return h(ctx, rw, req)
	}
}

// SnapshotController is the controller interface for the Snapshot actions.
type SnapshotController interface {
	goa.Muxer
	Create(*CreateSnapshotContext) error
	List(*ListSnapshotContext) error
	Show(*ShowSnapshotContext) error
}

// MountSnapshotController "mounts" a Snapshot resource controller on the given service.
func MountSnapshotController(service *goa.Service, ctrl SnapshotController) {
	initService(service)
	var h goa.Handler

	h = func(ctx context.Context, rw http.ResponseWriter, req *http.Request) error {
		// Check if there was an error loading the request
		if err := goa.ContextError(ctx); err != nil {
			return err
		}
		// Build the context
		rctx, err := NewCreateSnapshotContext(ctx, service)
		if err != nil {
			return err
		}
		// Build the payload
		if rawPayload := goa.ContextRequest(ctx).Payload; rawPayload != nil {
			rctx.Payload = rawPayload.(*SnapshotPayload)
		} else {
			return goa.MissingPayloadError()
		}
		return ctrl.Create(rctx)
	}
	h = handleSecurity("basic_auth", h)
	service.Mux.Handle("POST", "/snapshots", ctrl.MuxHandler("Create", h, unmarshalCreateSnapshotPayload))
	service.LogInfo("mount", "ctrl", "Snapshot", "action", "Create", "route", "POST /snapshots", "security", "basic_auth")

	h = func(ctx context.Context, rw http.ResponseWriter, req *http.Request) error {
		// Check if there was an error loading the request
		if err := goa.ContextError(ctx); err != nil {
			return err
		}
		// Build the context
		rctx, err := NewListSnapshotContext(ctx, service)
		if err != nil {
			return err
		}
		return ctrl.List(rctx)
	}
	service.Mux.Handle("GET", "/snapshots", ctrl.MuxHandler("List", h, nil))
	service.LogInfo("mount", "ctrl", "Snapshot", "action", "List", "route", "GET /snapshots")

	h = func(ctx context.Context, rw http.ResponseWriter, req *http.Request) error {
		// Check if there was an error loading the request
		if err := goa.ContextError(ctx); err != nil {
			return err
		}
		// Build the context
		rctx, err := NewShowSnapshotContext(ctx, service)
		if err != nil {
			return err
		}
		return ctrl.Show(rctx)
	}
	service.Mux.Handle("GET", "/snapshots/:snapshot_id", ctrl.MuxHandler("Show", h, nil))
	service.LogInfo("mount", "ctrl", "Snapshot", "action", "Show", "route", "GET /snapshots/:snapshot_id")
}

// unmarshalCreateSnapshotPayload unmarshals the request body into the context request data Payload field.
func unmarshalCreateSnapshotPayload(ctx context.Context, service *goa.Service, req *http.Request) error {
	payload := &snapshotPayload{}
	if err := service.DecodeRequest(req, payload); err != nil {
		return err
	}
	if err := payload.Validate(); err != nil {
		// Initialize payload with private data structure so it can be logged
		goa.ContextRequest(ctx).Payload = payload
		return err
	}
	goa.ContextRequest(ctx).Payload = payload.Publicize()
	return nil
}
