// Code generated by goagen v1.1.0-dirty, command line:
// $ goagen
// --design=code.justin.tv/dta/necronomicon-user-api/design
// --out=$(GOPATH)/src/code.justin.tv/dta/necronomicon-user-api
// --version=v1.1.0-dirty
//
// API "Necronomicon User API": deployment TestHelpers
//
// The content of this file is auto-generated, DO NOT MODIFY

package test

import (
	"bytes"
	"code.justin.tv/dta/necronomicon-user-api/app"
	"fmt"
	"github.com/goadesign/goa"
	"github.com/goadesign/goa/goatest"
	"golang.org/x/net/context"
	"io"
	"log"
	"net/http"
	"net/http/httptest"
	"net/url"
	"strconv"
	"time"
)

// CreateDeploymentBadRequest runs the method Create of the given controller with the given parameters and payload.
// It returns the response writer so it's possible to inspect the response headers and the media type struct written to the response.
// If ctx is nil then context.Background() is used.
// If service is nil then a default service is created.
func CreateDeploymentBadRequest(t goatest.TInterface, ctx context.Context, service *goa.Service, ctrl app.DeploymentController, datetimeFormat *string, payload *app.DeploymentPayload) (http.ResponseWriter, error) {
	// Setup service
	var (
		logBuf bytes.Buffer
		resp   interface{}

		respSetter goatest.ResponseSetterFunc = func(r interface{}) { resp = r }
	)
	if service == nil {
		service = goatest.Service(&logBuf, respSetter)
	} else {
		logger := log.New(&logBuf, "", log.Ltime)
		service.WithLogger(goa.NewLogger(logger))
		newEncoder := func(io.Writer) goa.Encoder { return respSetter }
		service.Encoder = goa.NewHTTPEncoder() // Make sure the code ends up using this decoder
		service.Encoder.Register(newEncoder, "*/*")
	}

	// Validate payload
	err := payload.Validate()
	if err != nil {
		e, ok := err.(goa.ServiceError)
		if !ok {
			panic(err) // bug
		}
		return nil, e
	}

	// Setup request context
	rw := httptest.NewRecorder()
	query := url.Values{}
	if datetimeFormat != nil {
		sliceVal := []string{*datetimeFormat}
		query["datetime-format"] = sliceVal
	}
	u := &url.URL{
		Path:     fmt.Sprintf("/deployments"),
		RawQuery: query.Encode(),
	}
	req, err := http.NewRequest("POST", u.String(), nil)
	if err != nil {
		panic("invalid test " + err.Error()) // bug
	}
	prms := url.Values{}
	if datetimeFormat != nil {
		sliceVal := []string{*datetimeFormat}
		prms["datetime-format"] = sliceVal
	}
	if ctx == nil {
		ctx = context.Background()
	}
	goaCtx := goa.NewContext(goa.WithAction(ctx, "DeploymentTest"), rw, req, prms)
	createCtx, err := app.NewCreateDeploymentContext(goaCtx, service)
	if err != nil {
		panic("invalid test data " + err.Error()) // bug
	}
	createCtx.Payload = payload

	// Perform action
	err = ctrl.Create(createCtx)

	// Validate response
	if err != nil {
		t.Fatalf("controller returned %s, logs:\n%s", err, logBuf.String())
	}
	if rw.Code != 400 {
		t.Errorf("invalid response status code: got %+v, expected 400", rw.Code)
	}
	var mt error
	if resp != nil {
		var ok bool
		mt, ok = resp.(error)
		if !ok {
			t.Fatalf("invalid response media: got %+v, expected instance of error", resp)
		}
	}

	// Return results
	return rw, mt
}

// CreateDeploymentCreated runs the method Create of the given controller with the given parameters and payload.
// It returns the response writer so it's possible to inspect the response headers.
// If ctx is nil then context.Background() is used.
// If service is nil then a default service is created.
func CreateDeploymentCreated(t goatest.TInterface, ctx context.Context, service *goa.Service, ctrl app.DeploymentController, datetimeFormat *string, payload *app.DeploymentPayload) http.ResponseWriter {
	// Setup service
	var (
		logBuf bytes.Buffer
		resp   interface{}

		respSetter goatest.ResponseSetterFunc = func(r interface{}) { resp = r }
	)
	if service == nil {
		service = goatest.Service(&logBuf, respSetter)
	} else {
		logger := log.New(&logBuf, "", log.Ltime)
		service.WithLogger(goa.NewLogger(logger))
		newEncoder := func(io.Writer) goa.Encoder { return respSetter }
		service.Encoder = goa.NewHTTPEncoder() // Make sure the code ends up using this decoder
		service.Encoder.Register(newEncoder, "*/*")
	}

	// Validate payload
	err := payload.Validate()
	if err != nil {
		e, ok := err.(goa.ServiceError)
		if !ok {
			panic(err) // bug
		}
		t.Errorf("unexpected payload validation error: %+v", e)
		return nil
	}

	// Setup request context
	rw := httptest.NewRecorder()
	query := url.Values{}
	if datetimeFormat != nil {
		sliceVal := []string{*datetimeFormat}
		query["datetime-format"] = sliceVal
	}
	u := &url.URL{
		Path:     fmt.Sprintf("/deployments"),
		RawQuery: query.Encode(),
	}
	req, err := http.NewRequest("POST", u.String(), nil)
	if err != nil {
		panic("invalid test " + err.Error()) // bug
	}
	prms := url.Values{}
	if datetimeFormat != nil {
		sliceVal := []string{*datetimeFormat}
		prms["datetime-format"] = sliceVal
	}
	if ctx == nil {
		ctx = context.Background()
	}
	goaCtx := goa.NewContext(goa.WithAction(ctx, "DeploymentTest"), rw, req, prms)
	createCtx, err := app.NewCreateDeploymentContext(goaCtx, service)
	if err != nil {
		panic("invalid test data " + err.Error()) // bug
	}
	createCtx.Payload = payload

	// Perform action
	err = ctrl.Create(createCtx)

	// Validate response
	if err != nil {
		t.Fatalf("controller returned %s, logs:\n%s", err, logBuf.String())
	}
	if rw.Code != 201 {
		t.Errorf("invalid response status code: got %+v, expected 201", rw.Code)
	}

	// Return results
	return rw
}

// CreateDeploymentUnauthorized runs the method Create of the given controller with the given parameters and payload.
// It returns the response writer so it's possible to inspect the response headers.
// If ctx is nil then context.Background() is used.
// If service is nil then a default service is created.
func CreateDeploymentUnauthorized(t goatest.TInterface, ctx context.Context, service *goa.Service, ctrl app.DeploymentController, datetimeFormat *string, payload *app.DeploymentPayload) http.ResponseWriter {
	// Setup service
	var (
		logBuf bytes.Buffer
		resp   interface{}

		respSetter goatest.ResponseSetterFunc = func(r interface{}) { resp = r }
	)
	if service == nil {
		service = goatest.Service(&logBuf, respSetter)
	} else {
		logger := log.New(&logBuf, "", log.Ltime)
		service.WithLogger(goa.NewLogger(logger))
		newEncoder := func(io.Writer) goa.Encoder { return respSetter }
		service.Encoder = goa.NewHTTPEncoder() // Make sure the code ends up using this decoder
		service.Encoder.Register(newEncoder, "*/*")
	}

	// Validate payload
	err := payload.Validate()
	if err != nil {
		e, ok := err.(goa.ServiceError)
		if !ok {
			panic(err) // bug
		}
		t.Errorf("unexpected payload validation error: %+v", e)
		return nil
	}

	// Setup request context
	rw := httptest.NewRecorder()
	query := url.Values{}
	if datetimeFormat != nil {
		sliceVal := []string{*datetimeFormat}
		query["datetime-format"] = sliceVal
	}
	u := &url.URL{
		Path:     fmt.Sprintf("/deployments"),
		RawQuery: query.Encode(),
	}
	req, err := http.NewRequest("POST", u.String(), nil)
	if err != nil {
		panic("invalid test " + err.Error()) // bug
	}
	prms := url.Values{}
	if datetimeFormat != nil {
		sliceVal := []string{*datetimeFormat}
		prms["datetime-format"] = sliceVal
	}
	if ctx == nil {
		ctx = context.Background()
	}
	goaCtx := goa.NewContext(goa.WithAction(ctx, "DeploymentTest"), rw, req, prms)
	createCtx, err := app.NewCreateDeploymentContext(goaCtx, service)
	if err != nil {
		panic("invalid test data " + err.Error()) // bug
	}
	createCtx.Payload = payload

	// Perform action
	err = ctrl.Create(createCtx)

	// Validate response
	if err != nil {
		t.Fatalf("controller returned %s, logs:\n%s", err, logBuf.String())
	}
	if rw.Code != 401 {
		t.Errorf("invalid response status code: got %+v, expected 401", rw.Code)
	}

	// Return results
	return rw
}

// ListDeploymentOK runs the method List of the given controller with the given parameters.
// It returns the response writer so it's possible to inspect the response headers and the media type struct written to the response.
// If ctx is nil then context.Background() is used.
// If service is nil then a default service is created.
func ListDeploymentOK(t goatest.TInterface, ctx context.Context, service *goa.Service, ctrl app.DeploymentController, datetimeFormat *string, from *time.Time, limit int, to *time.Time) (http.ResponseWriter, app.TwitchDtaNecronomiconUserapiDeploymentCollection) {
	// Setup service
	var (
		logBuf bytes.Buffer
		resp   interface{}

		respSetter goatest.ResponseSetterFunc = func(r interface{}) { resp = r }
	)
	if service == nil {
		service = goatest.Service(&logBuf, respSetter)
	} else {
		logger := log.New(&logBuf, "", log.Ltime)
		service.WithLogger(goa.NewLogger(logger))
		newEncoder := func(io.Writer) goa.Encoder { return respSetter }
		service.Encoder = goa.NewHTTPEncoder() // Make sure the code ends up using this decoder
		service.Encoder.Register(newEncoder, "*/*")
	}

	// Setup request context
	rw := httptest.NewRecorder()
	query := url.Values{}
	if datetimeFormat != nil {
		sliceVal := []string{*datetimeFormat}
		query["datetime-format"] = sliceVal
	}
	if from != nil {
		sliceVal := []string{(*from).Format(time.RFC3339)}
		query["from"] = sliceVal
	}
	{
		sliceVal := []string{strconv.Itoa(limit)}
		query["limit"] = sliceVal
	}
	if to != nil {
		sliceVal := []string{(*to).Format(time.RFC3339)}
		query["to"] = sliceVal
	}
	u := &url.URL{
		Path:     fmt.Sprintf("/deployments"),
		RawQuery: query.Encode(),
	}
	req, err := http.NewRequest("GET", u.String(), nil)
	if err != nil {
		panic("invalid test " + err.Error()) // bug
	}
	prms := url.Values{}
	if datetimeFormat != nil {
		sliceVal := []string{*datetimeFormat}
		prms["datetime-format"] = sliceVal
	}
	if from != nil {
		sliceVal := []string{(*from).Format(time.RFC3339)}
		prms["from"] = sliceVal
	}
	{
		sliceVal := []string{strconv.Itoa(limit)}
		prms["limit"] = sliceVal
	}
	if to != nil {
		sliceVal := []string{(*to).Format(time.RFC3339)}
		prms["to"] = sliceVal
	}
	if ctx == nil {
		ctx = context.Background()
	}
	goaCtx := goa.NewContext(goa.WithAction(ctx, "DeploymentTest"), rw, req, prms)
	listCtx, err := app.NewListDeploymentContext(goaCtx, service)
	if err != nil {
		panic("invalid test data " + err.Error()) // bug
	}

	// Perform action
	err = ctrl.List(listCtx)

	// Validate response
	if err != nil {
		t.Fatalf("controller returned %s, logs:\n%s", err, logBuf.String())
	}
	if rw.Code != 200 {
		t.Errorf("invalid response status code: got %+v, expected 200", rw.Code)
	}
	var mt app.TwitchDtaNecronomiconUserapiDeploymentCollection
	if resp != nil {
		var ok bool
		mt, ok = resp.(app.TwitchDtaNecronomiconUserapiDeploymentCollection)
		if !ok {
			t.Fatalf("invalid response media: got %+v, expected instance of app.TwitchDtaNecronomiconUserapiDeploymentCollection", resp)
		}
		err = mt.Validate()
		if err != nil {
			t.Errorf("invalid response media type: %s", err)
		}
	}

	// Return results
	return rw, mt
}

// ListDeploymentOKListed runs the method List of the given controller with the given parameters.
// It returns the response writer so it's possible to inspect the response headers and the media type struct written to the response.
// If ctx is nil then context.Background() is used.
// If service is nil then a default service is created.
func ListDeploymentOKListed(t goatest.TInterface, ctx context.Context, service *goa.Service, ctrl app.DeploymentController, datetimeFormat *string, from *time.Time, limit int, to *time.Time) (http.ResponseWriter, app.TwitchDtaNecronomiconUserapiDeploymentListedCollection) {
	// Setup service
	var (
		logBuf bytes.Buffer
		resp   interface{}

		respSetter goatest.ResponseSetterFunc = func(r interface{}) { resp = r }
	)
	if service == nil {
		service = goatest.Service(&logBuf, respSetter)
	} else {
		logger := log.New(&logBuf, "", log.Ltime)
		service.WithLogger(goa.NewLogger(logger))
		newEncoder := func(io.Writer) goa.Encoder { return respSetter }
		service.Encoder = goa.NewHTTPEncoder() // Make sure the code ends up using this decoder
		service.Encoder.Register(newEncoder, "*/*")
	}

	// Setup request context
	rw := httptest.NewRecorder()
	query := url.Values{}
	if datetimeFormat != nil {
		sliceVal := []string{*datetimeFormat}
		query["datetime-format"] = sliceVal
	}
	if from != nil {
		sliceVal := []string{(*from).Format(time.RFC3339)}
		query["from"] = sliceVal
	}
	{
		sliceVal := []string{strconv.Itoa(limit)}
		query["limit"] = sliceVal
	}
	if to != nil {
		sliceVal := []string{(*to).Format(time.RFC3339)}
		query["to"] = sliceVal
	}
	u := &url.URL{
		Path:     fmt.Sprintf("/deployments"),
		RawQuery: query.Encode(),
	}
	req, err := http.NewRequest("GET", u.String(), nil)
	if err != nil {
		panic("invalid test " + err.Error()) // bug
	}
	prms := url.Values{}
	if datetimeFormat != nil {
		sliceVal := []string{*datetimeFormat}
		prms["datetime-format"] = sliceVal
	}
	if from != nil {
		sliceVal := []string{(*from).Format(time.RFC3339)}
		prms["from"] = sliceVal
	}
	{
		sliceVal := []string{strconv.Itoa(limit)}
		prms["limit"] = sliceVal
	}
	if to != nil {
		sliceVal := []string{(*to).Format(time.RFC3339)}
		prms["to"] = sliceVal
	}
	if ctx == nil {
		ctx = context.Background()
	}
	goaCtx := goa.NewContext(goa.WithAction(ctx, "DeploymentTest"), rw, req, prms)
	listCtx, err := app.NewListDeploymentContext(goaCtx, service)
	if err != nil {
		panic("invalid test data " + err.Error()) // bug
	}

	// Perform action
	err = ctrl.List(listCtx)

	// Validate response
	if err != nil {
		t.Fatalf("controller returned %s, logs:\n%s", err, logBuf.String())
	}
	if rw.Code != 200 {
		t.Errorf("invalid response status code: got %+v, expected 200", rw.Code)
	}
	var mt app.TwitchDtaNecronomiconUserapiDeploymentListedCollection
	if resp != nil {
		var ok bool
		mt, ok = resp.(app.TwitchDtaNecronomiconUserapiDeploymentListedCollection)
		if !ok {
			t.Fatalf("invalid response media: got %+v, expected instance of app.TwitchDtaNecronomiconUserapiDeploymentListedCollection", resp)
		}
		err = mt.Validate()
		if err != nil {
			t.Errorf("invalid response media type: %s", err)
		}
	}

	// Return results
	return rw, mt
}

// PreviewDeploymentBadRequest runs the method Preview of the given controller with the given parameters and payload.
// It returns the response writer so it's possible to inspect the response headers and the media type struct written to the response.
// If ctx is nil then context.Background() is used.
// If service is nil then a default service is created.
func PreviewDeploymentBadRequest(t goatest.TInterface, ctx context.Context, service *goa.Service, ctrl app.DeploymentController, datetimeFormat *string, payload *app.DeploymentPayload) (http.ResponseWriter, error) {
	// Setup service
	var (
		logBuf bytes.Buffer
		resp   interface{}

		respSetter goatest.ResponseSetterFunc = func(r interface{}) { resp = r }
	)
	if service == nil {
		service = goatest.Service(&logBuf, respSetter)
	} else {
		logger := log.New(&logBuf, "", log.Ltime)
		service.WithLogger(goa.NewLogger(logger))
		newEncoder := func(io.Writer) goa.Encoder { return respSetter }
		service.Encoder = goa.NewHTTPEncoder() // Make sure the code ends up using this decoder
		service.Encoder.Register(newEncoder, "*/*")
	}

	// Validate payload
	err := payload.Validate()
	if err != nil {
		e, ok := err.(goa.ServiceError)
		if !ok {
			panic(err) // bug
		}
		return nil, e
	}

	// Setup request context
	rw := httptest.NewRecorder()
	query := url.Values{}
	if datetimeFormat != nil {
		sliceVal := []string{*datetimeFormat}
		query["datetime-format"] = sliceVal
	}
	u := &url.URL{
		Path:     fmt.Sprintf("/deployments/preview"),
		RawQuery: query.Encode(),
	}
	req, err := http.NewRequest("POST", u.String(), nil)
	if err != nil {
		panic("invalid test " + err.Error()) // bug
	}
	prms := url.Values{}
	if datetimeFormat != nil {
		sliceVal := []string{*datetimeFormat}
		prms["datetime-format"] = sliceVal
	}
	if ctx == nil {
		ctx = context.Background()
	}
	goaCtx := goa.NewContext(goa.WithAction(ctx, "DeploymentTest"), rw, req, prms)
	previewCtx, err := app.NewPreviewDeploymentContext(goaCtx, service)
	if err != nil {
		panic("invalid test data " + err.Error()) // bug
	}
	previewCtx.Payload = payload

	// Perform action
	err = ctrl.Preview(previewCtx)

	// Validate response
	if err != nil {
		t.Fatalf("controller returned %s, logs:\n%s", err, logBuf.String())
	}
	if rw.Code != 400 {
		t.Errorf("invalid response status code: got %+v, expected 400", rw.Code)
	}
	var mt error
	if resp != nil {
		var ok bool
		mt, ok = resp.(error)
		if !ok {
			t.Fatalf("invalid response media: got %+v, expected instance of error", resp)
		}
	}

	// Return results
	return rw, mt
}

// PreviewDeploymentOK runs the method Preview of the given controller with the given parameters and payload.
// It returns the response writer so it's possible to inspect the response headers and the media type struct written to the response.
// If ctx is nil then context.Background() is used.
// If service is nil then a default service is created.
func PreviewDeploymentOK(t goatest.TInterface, ctx context.Context, service *goa.Service, ctrl app.DeploymentController, datetimeFormat *string, payload *app.DeploymentPayload) (http.ResponseWriter, *app.TwitchDtaNecronomiconUserapiSnapshotStatemap) {
	// Setup service
	var (
		logBuf bytes.Buffer
		resp   interface{}

		respSetter goatest.ResponseSetterFunc = func(r interface{}) { resp = r }
	)
	if service == nil {
		service = goatest.Service(&logBuf, respSetter)
	} else {
		logger := log.New(&logBuf, "", log.Ltime)
		service.WithLogger(goa.NewLogger(logger))
		newEncoder := func(io.Writer) goa.Encoder { return respSetter }
		service.Encoder = goa.NewHTTPEncoder() // Make sure the code ends up using this decoder
		service.Encoder.Register(newEncoder, "*/*")
	}

	// Validate payload
	err := payload.Validate()
	if err != nil {
		e, ok := err.(goa.ServiceError)
		if !ok {
			panic(err) // bug
		}
		t.Errorf("unexpected payload validation error: %+v", e)
		return nil, nil
	}

	// Setup request context
	rw := httptest.NewRecorder()
	query := url.Values{}
	if datetimeFormat != nil {
		sliceVal := []string{*datetimeFormat}
		query["datetime-format"] = sliceVal
	}
	u := &url.URL{
		Path:     fmt.Sprintf("/deployments/preview"),
		RawQuery: query.Encode(),
	}
	req, err := http.NewRequest("POST", u.String(), nil)
	if err != nil {
		panic("invalid test " + err.Error()) // bug
	}
	prms := url.Values{}
	if datetimeFormat != nil {
		sliceVal := []string{*datetimeFormat}
		prms["datetime-format"] = sliceVal
	}
	if ctx == nil {
		ctx = context.Background()
	}
	goaCtx := goa.NewContext(goa.WithAction(ctx, "DeploymentTest"), rw, req, prms)
	previewCtx, err := app.NewPreviewDeploymentContext(goaCtx, service)
	if err != nil {
		panic("invalid test data " + err.Error()) // bug
	}
	previewCtx.Payload = payload

	// Perform action
	err = ctrl.Preview(previewCtx)

	// Validate response
	if err != nil {
		t.Fatalf("controller returned %s, logs:\n%s", err, logBuf.String())
	}
	if rw.Code != 200 {
		t.Errorf("invalid response status code: got %+v, expected 200", rw.Code)
	}
	var mt *app.TwitchDtaNecronomiconUserapiSnapshotStatemap
	if resp != nil {
		var ok bool
		mt, ok = resp.(*app.TwitchDtaNecronomiconUserapiSnapshotStatemap)
		if !ok {
			t.Fatalf("invalid response media: got %+v, expected instance of app.TwitchDtaNecronomiconUserapiSnapshotStatemap", resp)
		}
		err = mt.Validate()
		if err != nil {
			t.Errorf("invalid response media type: %s", err)
		}
	}

	// Return results
	return rw, mt
}

// ShowDeploymentNotFound runs the method Show of the given controller with the given parameters.
// It returns the response writer so it's possible to inspect the response headers.
// If ctx is nil then context.Background() is used.
// If service is nil then a default service is created.
func ShowDeploymentNotFound(t goatest.TInterface, ctx context.Context, service *goa.Service, ctrl app.DeploymentController, deploymentID int, datetimeFormat *string) http.ResponseWriter {
	// Setup service
	var (
		logBuf bytes.Buffer
		resp   interface{}

		respSetter goatest.ResponseSetterFunc = func(r interface{}) { resp = r }
	)
	if service == nil {
		service = goatest.Service(&logBuf, respSetter)
	} else {
		logger := log.New(&logBuf, "", log.Ltime)
		service.WithLogger(goa.NewLogger(logger))
		newEncoder := func(io.Writer) goa.Encoder { return respSetter }
		service.Encoder = goa.NewHTTPEncoder() // Make sure the code ends up using this decoder
		service.Encoder.Register(newEncoder, "*/*")
	}

	// Setup request context
	rw := httptest.NewRecorder()
	query := url.Values{}
	if datetimeFormat != nil {
		sliceVal := []string{*datetimeFormat}
		query["datetime-format"] = sliceVal
	}
	u := &url.URL{
		Path:     fmt.Sprintf("/deployments/%v", deploymentID),
		RawQuery: query.Encode(),
	}
	req, err := http.NewRequest("GET", u.String(), nil)
	if err != nil {
		panic("invalid test " + err.Error()) // bug
	}
	prms := url.Values{}
	prms["deployment_id"] = []string{fmt.Sprintf("%v", deploymentID)}
	if datetimeFormat != nil {
		sliceVal := []string{*datetimeFormat}
		prms["datetime-format"] = sliceVal
	}
	if ctx == nil {
		ctx = context.Background()
	}
	goaCtx := goa.NewContext(goa.WithAction(ctx, "DeploymentTest"), rw, req, prms)
	showCtx, err := app.NewShowDeploymentContext(goaCtx, service)
	if err != nil {
		panic("invalid test data " + err.Error()) // bug
	}

	// Perform action
	err = ctrl.Show(showCtx)

	// Validate response
	if err != nil {
		t.Fatalf("controller returned %s, logs:\n%s", err, logBuf.String())
	}
	if rw.Code != 404 {
		t.Errorf("invalid response status code: got %+v, expected 404", rw.Code)
	}

	// Return results
	return rw
}

// ShowDeploymentOK runs the method Show of the given controller with the given parameters.
// It returns the response writer so it's possible to inspect the response headers and the media type struct written to the response.
// If ctx is nil then context.Background() is used.
// If service is nil then a default service is created.
func ShowDeploymentOK(t goatest.TInterface, ctx context.Context, service *goa.Service, ctrl app.DeploymentController, deploymentID int, datetimeFormat *string) (http.ResponseWriter, *app.TwitchDtaNecronomiconUserapiDeployment) {
	// Setup service
	var (
		logBuf bytes.Buffer
		resp   interface{}

		respSetter goatest.ResponseSetterFunc = func(r interface{}) { resp = r }
	)
	if service == nil {
		service = goatest.Service(&logBuf, respSetter)
	} else {
		logger := log.New(&logBuf, "", log.Ltime)
		service.WithLogger(goa.NewLogger(logger))
		newEncoder := func(io.Writer) goa.Encoder { return respSetter }
		service.Encoder = goa.NewHTTPEncoder() // Make sure the code ends up using this decoder
		service.Encoder.Register(newEncoder, "*/*")
	}

	// Setup request context
	rw := httptest.NewRecorder()
	query := url.Values{}
	if datetimeFormat != nil {
		sliceVal := []string{*datetimeFormat}
		query["datetime-format"] = sliceVal
	}
	u := &url.URL{
		Path:     fmt.Sprintf("/deployments/%v", deploymentID),
		RawQuery: query.Encode(),
	}
	req, err := http.NewRequest("GET", u.String(), nil)
	if err != nil {
		panic("invalid test " + err.Error()) // bug
	}
	prms := url.Values{}
	prms["deployment_id"] = []string{fmt.Sprintf("%v", deploymentID)}
	if datetimeFormat != nil {
		sliceVal := []string{*datetimeFormat}
		prms["datetime-format"] = sliceVal
	}
	if ctx == nil {
		ctx = context.Background()
	}
	goaCtx := goa.NewContext(goa.WithAction(ctx, "DeploymentTest"), rw, req, prms)
	showCtx, err := app.NewShowDeploymentContext(goaCtx, service)
	if err != nil {
		panic("invalid test data " + err.Error()) // bug
	}

	// Perform action
	err = ctrl.Show(showCtx)

	// Validate response
	if err != nil {
		t.Fatalf("controller returned %s, logs:\n%s", err, logBuf.String())
	}
	if rw.Code != 200 {
		t.Errorf("invalid response status code: got %+v, expected 200", rw.Code)
	}
	var mt *app.TwitchDtaNecronomiconUserapiDeployment
	if resp != nil {
		var ok bool
		mt, ok = resp.(*app.TwitchDtaNecronomiconUserapiDeployment)
		if !ok {
			t.Fatalf("invalid response media: got %+v, expected instance of app.TwitchDtaNecronomiconUserapiDeployment", resp)
		}
		err = mt.Validate()
		if err != nil {
			t.Errorf("invalid response media type: %s", err)
		}
	}

	// Return results
	return rw, mt
}

// ShowDeploymentOKListed runs the method Show of the given controller with the given parameters.
// It returns the response writer so it's possible to inspect the response headers and the media type struct written to the response.
// If ctx is nil then context.Background() is used.
// If service is nil then a default service is created.
func ShowDeploymentOKListed(t goatest.TInterface, ctx context.Context, service *goa.Service, ctrl app.DeploymentController, deploymentID int, datetimeFormat *string) (http.ResponseWriter, *app.TwitchDtaNecronomiconUserapiDeploymentListed) {
	// Setup service
	var (
		logBuf bytes.Buffer
		resp   interface{}

		respSetter goatest.ResponseSetterFunc = func(r interface{}) { resp = r }
	)
	if service == nil {
		service = goatest.Service(&logBuf, respSetter)
	} else {
		logger := log.New(&logBuf, "", log.Ltime)
		service.WithLogger(goa.NewLogger(logger))
		newEncoder := func(io.Writer) goa.Encoder { return respSetter }
		service.Encoder = goa.NewHTTPEncoder() // Make sure the code ends up using this decoder
		service.Encoder.Register(newEncoder, "*/*")
	}

	// Setup request context
	rw := httptest.NewRecorder()
	query := url.Values{}
	if datetimeFormat != nil {
		sliceVal := []string{*datetimeFormat}
		query["datetime-format"] = sliceVal
	}
	u := &url.URL{
		Path:     fmt.Sprintf("/deployments/%v", deploymentID),
		RawQuery: query.Encode(),
	}
	req, err := http.NewRequest("GET", u.String(), nil)
	if err != nil {
		panic("invalid test " + err.Error()) // bug
	}
	prms := url.Values{}
	prms["deployment_id"] = []string{fmt.Sprintf("%v", deploymentID)}
	if datetimeFormat != nil {
		sliceVal := []string{*datetimeFormat}
		prms["datetime-format"] = sliceVal
	}
	if ctx == nil {
		ctx = context.Background()
	}
	goaCtx := goa.NewContext(goa.WithAction(ctx, "DeploymentTest"), rw, req, prms)
	showCtx, err := app.NewShowDeploymentContext(goaCtx, service)
	if err != nil {
		panic("invalid test data " + err.Error()) // bug
	}

	// Perform action
	err = ctrl.Show(showCtx)

	// Validate response
	if err != nil {
		t.Fatalf("controller returned %s, logs:\n%s", err, logBuf.String())
	}
	if rw.Code != 200 {
		t.Errorf("invalid response status code: got %+v, expected 200", rw.Code)
	}
	var mt *app.TwitchDtaNecronomiconUserapiDeploymentListed
	if resp != nil {
		var ok bool
		mt, ok = resp.(*app.TwitchDtaNecronomiconUserapiDeploymentListed)
		if !ok {
			t.Fatalf("invalid response media: got %+v, expected instance of app.TwitchDtaNecronomiconUserapiDeploymentListed", resp)
		}
		err = mt.Validate()
		if err != nil {
			t.Errorf("invalid response media type: %s", err)
		}
	}

	// Return results
	return rw, mt
}
