// Code generated by goagen v1.1.0-dirty, command line:
// $ goagen
// --design=code.justin.tv/dta/necronomicon-user-api/design
// --out=$(GOPATH)/src/code.justin.tv/dta/necronomicon-user-api
// --version=v1.1.0-dirty
//
// API "Necronomicon User API": environment TestHelpers
//
// The content of this file is auto-generated, DO NOT MODIFY

package test

import (
	"bytes"
	"code.justin.tv/dta/necronomicon-user-api/app"
	"fmt"
	"github.com/goadesign/goa"
	"github.com/goadesign/goa/goatest"
	"golang.org/x/net/context"
	"io"
	"log"
	"net/http"
	"net/http/httptest"
	"net/url"
)

// ListEnvironmentNotFound runs the method List of the given controller with the given parameters.
// It returns the response writer so it's possible to inspect the response headers.
// If ctx is nil then context.Background() is used.
// If service is nil then a default service is created.
func ListEnvironmentNotFound(t goatest.TInterface, ctx context.Context, service *goa.Service, ctrl app.EnvironmentController, snapshotID int, datetimeFormat *string) http.ResponseWriter {
	// Setup service
	var (
		logBuf bytes.Buffer
		resp   interface{}

		respSetter goatest.ResponseSetterFunc = func(r interface{}) { resp = r }
	)
	if service == nil {
		service = goatest.Service(&logBuf, respSetter)
	} else {
		logger := log.New(&logBuf, "", log.Ltime)
		service.WithLogger(goa.NewLogger(logger))
		newEncoder := func(io.Writer) goa.Encoder { return respSetter }
		service.Encoder = goa.NewHTTPEncoder() // Make sure the code ends up using this decoder
		service.Encoder.Register(newEncoder, "*/*")
	}

	// Setup request context
	rw := httptest.NewRecorder()
	query := url.Values{}
	if datetimeFormat != nil {
		sliceVal := []string{*datetimeFormat}
		query["datetime-format"] = sliceVal
	}
	u := &url.URL{
		Path:     fmt.Sprintf("/snapshots/%v/environments", snapshotID),
		RawQuery: query.Encode(),
	}
	req, err := http.NewRequest("GET", u.String(), nil)
	if err != nil {
		panic("invalid test " + err.Error()) // bug
	}
	prms := url.Values{}
	prms["snapshot_id"] = []string{fmt.Sprintf("%v", snapshotID)}
	if datetimeFormat != nil {
		sliceVal := []string{*datetimeFormat}
		prms["datetime-format"] = sliceVal
	}
	if ctx == nil {
		ctx = context.Background()
	}
	goaCtx := goa.NewContext(goa.WithAction(ctx, "EnvironmentTest"), rw, req, prms)
	listCtx, err := app.NewListEnvironmentContext(goaCtx, service)
	if err != nil {
		panic("invalid test data " + err.Error()) // bug
	}

	// Perform action
	err = ctrl.List(listCtx)

	// Validate response
	if err != nil {
		t.Fatalf("controller returned %s, logs:\n%s", err, logBuf.String())
	}
	if rw.Code != 404 {
		t.Errorf("invalid response status code: got %+v, expected 404", rw.Code)
	}

	// Return results
	return rw
}

// ListEnvironmentOK runs the method List of the given controller with the given parameters.
// It returns the response writer so it's possible to inspect the response headers and the media type struct written to the response.
// If ctx is nil then context.Background() is used.
// If service is nil then a default service is created.
func ListEnvironmentOK(t goatest.TInterface, ctx context.Context, service *goa.Service, ctrl app.EnvironmentController, snapshotID int, datetimeFormat *string) (http.ResponseWriter, app.EnvironmentMediaCollection) {
	// Setup service
	var (
		logBuf bytes.Buffer
		resp   interface{}

		respSetter goatest.ResponseSetterFunc = func(r interface{}) { resp = r }
	)
	if service == nil {
		service = goatest.Service(&logBuf, respSetter)
	} else {
		logger := log.New(&logBuf, "", log.Ltime)
		service.WithLogger(goa.NewLogger(logger))
		newEncoder := func(io.Writer) goa.Encoder { return respSetter }
		service.Encoder = goa.NewHTTPEncoder() // Make sure the code ends up using this decoder
		service.Encoder.Register(newEncoder, "*/*")
	}

	// Setup request context
	rw := httptest.NewRecorder()
	query := url.Values{}
	if datetimeFormat != nil {
		sliceVal := []string{*datetimeFormat}
		query["datetime-format"] = sliceVal
	}
	u := &url.URL{
		Path:     fmt.Sprintf("/snapshots/%v/environments", snapshotID),
		RawQuery: query.Encode(),
	}
	req, err := http.NewRequest("GET", u.String(), nil)
	if err != nil {
		panic("invalid test " + err.Error()) // bug
	}
	prms := url.Values{}
	prms["snapshot_id"] = []string{fmt.Sprintf("%v", snapshotID)}
	if datetimeFormat != nil {
		sliceVal := []string{*datetimeFormat}
		prms["datetime-format"] = sliceVal
	}
	if ctx == nil {
		ctx = context.Background()
	}
	goaCtx := goa.NewContext(goa.WithAction(ctx, "EnvironmentTest"), rw, req, prms)
	listCtx, err := app.NewListEnvironmentContext(goaCtx, service)
	if err != nil {
		panic("invalid test data " + err.Error()) // bug
	}

	// Perform action
	err = ctrl.List(listCtx)

	// Validate response
	if err != nil {
		t.Fatalf("controller returned %s, logs:\n%s", err, logBuf.String())
	}
	if rw.Code != 200 {
		t.Errorf("invalid response status code: got %+v, expected 200", rw.Code)
	}
	var mt app.EnvironmentMediaCollection
	if resp != nil {
		var ok bool
		mt, ok = resp.(app.EnvironmentMediaCollection)
		if !ok {
			t.Fatalf("invalid response media: got %+v, expected instance of app.EnvironmentMediaCollection", resp)
		}
		err = mt.Validate()
		if err != nil {
			t.Errorf("invalid response media type: %s", err)
		}
	}

	// Return results
	return rw, mt
}

// ShowEnvironmentNotFound runs the method Show of the given controller with the given parameters.
// It returns the response writer so it's possible to inspect the response headers.
// If ctx is nil then context.Background() is used.
// If service is nil then a default service is created.
func ShowEnvironmentNotFound(t goatest.TInterface, ctx context.Context, service *goa.Service, ctrl app.EnvironmentController, snapshotID int, environment string, datetimeFormat *string) http.ResponseWriter {
	// Setup service
	var (
		logBuf bytes.Buffer
		resp   interface{}

		respSetter goatest.ResponseSetterFunc = func(r interface{}) { resp = r }
	)
	if service == nil {
		service = goatest.Service(&logBuf, respSetter)
	} else {
		logger := log.New(&logBuf, "", log.Ltime)
		service.WithLogger(goa.NewLogger(logger))
		newEncoder := func(io.Writer) goa.Encoder { return respSetter }
		service.Encoder = goa.NewHTTPEncoder() // Make sure the code ends up using this decoder
		service.Encoder.Register(newEncoder, "*/*")
	}

	// Setup request context
	rw := httptest.NewRecorder()
	query := url.Values{}
	if datetimeFormat != nil {
		sliceVal := []string{*datetimeFormat}
		query["datetime-format"] = sliceVal
	}
	u := &url.URL{
		Path:     fmt.Sprintf("/snapshots/%v/environments/%v", snapshotID, environment),
		RawQuery: query.Encode(),
	}
	req, err := http.NewRequest("GET", u.String(), nil)
	if err != nil {
		panic("invalid test " + err.Error()) // bug
	}
	prms := url.Values{}
	prms["snapshot_id"] = []string{fmt.Sprintf("%v", snapshotID)}
	prms["environment"] = []string{fmt.Sprintf("%v", environment)}
	if datetimeFormat != nil {
		sliceVal := []string{*datetimeFormat}
		prms["datetime-format"] = sliceVal
	}
	if ctx == nil {
		ctx = context.Background()
	}
	goaCtx := goa.NewContext(goa.WithAction(ctx, "EnvironmentTest"), rw, req, prms)
	showCtx, err := app.NewShowEnvironmentContext(goaCtx, service)
	if err != nil {
		panic("invalid test data " + err.Error()) // bug
	}

	// Perform action
	err = ctrl.Show(showCtx)

	// Validate response
	if err != nil {
		t.Fatalf("controller returned %s, logs:\n%s", err, logBuf.String())
	}
	if rw.Code != 404 {
		t.Errorf("invalid response status code: got %+v, expected 404", rw.Code)
	}

	// Return results
	return rw
}

// ShowEnvironmentOK runs the method Show of the given controller with the given parameters.
// It returns the response writer so it's possible to inspect the response headers and the media type struct written to the response.
// If ctx is nil then context.Background() is used.
// If service is nil then a default service is created.
func ShowEnvironmentOK(t goatest.TInterface, ctx context.Context, service *goa.Service, ctrl app.EnvironmentController, snapshotID int, environment string, datetimeFormat *string) (http.ResponseWriter, *app.EnvironmentMedia) {
	// Setup service
	var (
		logBuf bytes.Buffer
		resp   interface{}

		respSetter goatest.ResponseSetterFunc = func(r interface{}) { resp = r }
	)
	if service == nil {
		service = goatest.Service(&logBuf, respSetter)
	} else {
		logger := log.New(&logBuf, "", log.Ltime)
		service.WithLogger(goa.NewLogger(logger))
		newEncoder := func(io.Writer) goa.Encoder { return respSetter }
		service.Encoder = goa.NewHTTPEncoder() // Make sure the code ends up using this decoder
		service.Encoder.Register(newEncoder, "*/*")
	}

	// Setup request context
	rw := httptest.NewRecorder()
	query := url.Values{}
	if datetimeFormat != nil {
		sliceVal := []string{*datetimeFormat}
		query["datetime-format"] = sliceVal
	}
	u := &url.URL{
		Path:     fmt.Sprintf("/snapshots/%v/environments/%v", snapshotID, environment),
		RawQuery: query.Encode(),
	}
	req, err := http.NewRequest("GET", u.String(), nil)
	if err != nil {
		panic("invalid test " + err.Error()) // bug
	}
	prms := url.Values{}
	prms["snapshot_id"] = []string{fmt.Sprintf("%v", snapshotID)}
	prms["environment"] = []string{fmt.Sprintf("%v", environment)}
	if datetimeFormat != nil {
		sliceVal := []string{*datetimeFormat}
		prms["datetime-format"] = sliceVal
	}
	if ctx == nil {
		ctx = context.Background()
	}
	goaCtx := goa.NewContext(goa.WithAction(ctx, "EnvironmentTest"), rw, req, prms)
	showCtx, err := app.NewShowEnvironmentContext(goaCtx, service)
	if err != nil {
		panic("invalid test data " + err.Error()) // bug
	}

	// Perform action
	err = ctrl.Show(showCtx)

	// Validate response
	if err != nil {
		t.Fatalf("controller returned %s, logs:\n%s", err, logBuf.String())
	}
	if rw.Code != 200 {
		t.Errorf("invalid response status code: got %+v, expected 200", rw.Code)
	}
	var mt *app.EnvironmentMedia
	if resp != nil {
		var ok bool
		mt, ok = resp.(*app.EnvironmentMedia)
		if !ok {
			t.Fatalf("invalid response media: got %+v, expected instance of app.EnvironmentMedia", resp)
		}
		err = mt.Validate()
		if err != nil {
			t.Errorf("invalid response media type: %s", err)
		}
	}

	// Return results
	return rw, mt
}

// ShowEnvironmentOKMerged runs the method Show of the given controller with the given parameters.
// It returns the response writer so it's possible to inspect the response headers and the media type struct written to the response.
// If ctx is nil then context.Background() is used.
// If service is nil then a default service is created.
func ShowEnvironmentOKMerged(t goatest.TInterface, ctx context.Context, service *goa.Service, ctrl app.EnvironmentController, snapshotID int, environment string, datetimeFormat *string) (http.ResponseWriter, *app.EnvironmentMediaMerged) {
	// Setup service
	var (
		logBuf bytes.Buffer
		resp   interface{}

		respSetter goatest.ResponseSetterFunc = func(r interface{}) { resp = r }
	)
	if service == nil {
		service = goatest.Service(&logBuf, respSetter)
	} else {
		logger := log.New(&logBuf, "", log.Ltime)
		service.WithLogger(goa.NewLogger(logger))
		newEncoder := func(io.Writer) goa.Encoder { return respSetter }
		service.Encoder = goa.NewHTTPEncoder() // Make sure the code ends up using this decoder
		service.Encoder.Register(newEncoder, "*/*")
	}

	// Setup request context
	rw := httptest.NewRecorder()
	query := url.Values{}
	if datetimeFormat != nil {
		sliceVal := []string{*datetimeFormat}
		query["datetime-format"] = sliceVal
	}
	u := &url.URL{
		Path:     fmt.Sprintf("/snapshots/%v/environments/%v", snapshotID, environment),
		RawQuery: query.Encode(),
	}
	req, err := http.NewRequest("GET", u.String(), nil)
	if err != nil {
		panic("invalid test " + err.Error()) // bug
	}
	prms := url.Values{}
	prms["snapshot_id"] = []string{fmt.Sprintf("%v", snapshotID)}
	prms["environment"] = []string{fmt.Sprintf("%v", environment)}
	if datetimeFormat != nil {
		sliceVal := []string{*datetimeFormat}
		prms["datetime-format"] = sliceVal
	}
	if ctx == nil {
		ctx = context.Background()
	}
	goaCtx := goa.NewContext(goa.WithAction(ctx, "EnvironmentTest"), rw, req, prms)
	showCtx, err := app.NewShowEnvironmentContext(goaCtx, service)
	if err != nil {
		panic("invalid test data " + err.Error()) // bug
	}

	// Perform action
	err = ctrl.Show(showCtx)

	// Validate response
	if err != nil {
		t.Fatalf("controller returned %s, logs:\n%s", err, logBuf.String())
	}
	if rw.Code != 200 {
		t.Errorf("invalid response status code: got %+v, expected 200", rw.Code)
	}
	var mt *app.EnvironmentMediaMerged
	if resp != nil {
		var ok bool
		mt, ok = resp.(*app.EnvironmentMediaMerged)
		if !ok {
			t.Fatalf("invalid response media: got %+v, expected instance of app.EnvironmentMediaMerged", resp)
		}
		err = mt.Validate()
		if err != nil {
			t.Errorf("invalid response media type: %s", err)
		}
	}

	// Return results
	return rw, mt
}
