// Code generated by goagen v1.1.0-dirty, command line:
// $ goagen
// --design=code.justin.tv/dta/necronomicon-user-api/design
// --out=$(GOPATH)/src/code.justin.tv/dta/necronomicon-user-api
// --version=v1.1.0-dirty
//
// API "Necronomicon User API": snapshot TestHelpers
//
// The content of this file is auto-generated, DO NOT MODIFY

package test

import (
	"bytes"
	"code.justin.tv/dta/necronomicon-user-api/app"
	"fmt"
	"github.com/goadesign/goa"
	"github.com/goadesign/goa/goatest"
	"golang.org/x/net/context"
	"io"
	"log"
	"net/http"
	"net/http/httptest"
	"net/url"
	"strconv"
	"time"
)

// CreateSnapshotCreated runs the method Create of the given controller with the given parameters and payload.
// It returns the response writer so it's possible to inspect the response headers.
// If ctx is nil then context.Background() is used.
// If service is nil then a default service is created.
func CreateSnapshotCreated(t goatest.TInterface, ctx context.Context, service *goa.Service, ctrl app.SnapshotController, datetimeFormat *string, payload *app.SnapshotPayload) http.ResponseWriter {
	// Setup service
	var (
		logBuf bytes.Buffer
		resp   interface{}

		respSetter goatest.ResponseSetterFunc = func(r interface{}) { resp = r }
	)
	if service == nil {
		service = goatest.Service(&logBuf, respSetter)
	} else {
		logger := log.New(&logBuf, "", log.Ltime)
		service.WithLogger(goa.NewLogger(logger))
		newEncoder := func(io.Writer) goa.Encoder { return respSetter }
		service.Encoder = goa.NewHTTPEncoder() // Make sure the code ends up using this decoder
		service.Encoder.Register(newEncoder, "*/*")
	}

	// Validate payload
	err := payload.Validate()
	if err != nil {
		e, ok := err.(goa.ServiceError)
		if !ok {
			panic(err) // bug
		}
		t.Errorf("unexpected payload validation error: %+v", e)
		return nil
	}

	// Setup request context
	rw := httptest.NewRecorder()
	query := url.Values{}
	if datetimeFormat != nil {
		sliceVal := []string{*datetimeFormat}
		query["datetime-format"] = sliceVal
	}
	u := &url.URL{
		Path:     fmt.Sprintf("/snapshots"),
		RawQuery: query.Encode(),
	}
	req, err := http.NewRequest("POST", u.String(), nil)
	if err != nil {
		panic("invalid test " + err.Error()) // bug
	}
	prms := url.Values{}
	if datetimeFormat != nil {
		sliceVal := []string{*datetimeFormat}
		prms["datetime-format"] = sliceVal
	}
	if ctx == nil {
		ctx = context.Background()
	}
	goaCtx := goa.NewContext(goa.WithAction(ctx, "SnapshotTest"), rw, req, prms)
	createCtx, err := app.NewCreateSnapshotContext(goaCtx, service)
	if err != nil {
		panic("invalid test data " + err.Error()) // bug
	}
	createCtx.Payload = payload

	// Perform action
	err = ctrl.Create(createCtx)

	// Validate response
	if err != nil {
		t.Fatalf("controller returned %s, logs:\n%s", err, logBuf.String())
	}
	if rw.Code != 201 {
		t.Errorf("invalid response status code: got %+v, expected 201", rw.Code)
	}

	// Return results
	return rw
}

// CreateSnapshotUnauthorized runs the method Create of the given controller with the given parameters and payload.
// It returns the response writer so it's possible to inspect the response headers.
// If ctx is nil then context.Background() is used.
// If service is nil then a default service is created.
func CreateSnapshotUnauthorized(t goatest.TInterface, ctx context.Context, service *goa.Service, ctrl app.SnapshotController, datetimeFormat *string, payload *app.SnapshotPayload) http.ResponseWriter {
	// Setup service
	var (
		logBuf bytes.Buffer
		resp   interface{}

		respSetter goatest.ResponseSetterFunc = func(r interface{}) { resp = r }
	)
	if service == nil {
		service = goatest.Service(&logBuf, respSetter)
	} else {
		logger := log.New(&logBuf, "", log.Ltime)
		service.WithLogger(goa.NewLogger(logger))
		newEncoder := func(io.Writer) goa.Encoder { return respSetter }
		service.Encoder = goa.NewHTTPEncoder() // Make sure the code ends up using this decoder
		service.Encoder.Register(newEncoder, "*/*")
	}

	// Validate payload
	err := payload.Validate()
	if err != nil {
		e, ok := err.(goa.ServiceError)
		if !ok {
			panic(err) // bug
		}
		t.Errorf("unexpected payload validation error: %+v", e)
		return nil
	}

	// Setup request context
	rw := httptest.NewRecorder()
	query := url.Values{}
	if datetimeFormat != nil {
		sliceVal := []string{*datetimeFormat}
		query["datetime-format"] = sliceVal
	}
	u := &url.URL{
		Path:     fmt.Sprintf("/snapshots"),
		RawQuery: query.Encode(),
	}
	req, err := http.NewRequest("POST", u.String(), nil)
	if err != nil {
		panic("invalid test " + err.Error()) // bug
	}
	prms := url.Values{}
	if datetimeFormat != nil {
		sliceVal := []string{*datetimeFormat}
		prms["datetime-format"] = sliceVal
	}
	if ctx == nil {
		ctx = context.Background()
	}
	goaCtx := goa.NewContext(goa.WithAction(ctx, "SnapshotTest"), rw, req, prms)
	createCtx, err := app.NewCreateSnapshotContext(goaCtx, service)
	if err != nil {
		panic("invalid test data " + err.Error()) // bug
	}
	createCtx.Payload = payload

	// Perform action
	err = ctrl.Create(createCtx)

	// Validate response
	if err != nil {
		t.Fatalf("controller returned %s, logs:\n%s", err, logBuf.String())
	}
	if rw.Code != 401 {
		t.Errorf("invalid response status code: got %+v, expected 401", rw.Code)
	}

	// Return results
	return rw
}

// ListSnapshotOK runs the method List of the given controller with the given parameters.
// It returns the response writer so it's possible to inspect the response headers and the media type struct written to the response.
// If ctx is nil then context.Background() is used.
// If service is nil then a default service is created.
func ListSnapshotOK(t goatest.TInterface, ctx context.Context, service *goa.Service, ctrl app.SnapshotController, datetimeFormat *string, from *time.Time, limit int, to *time.Time) (http.ResponseWriter, app.SnapshotMediaCollection) {
	// Setup service
	var (
		logBuf bytes.Buffer
		resp   interface{}

		respSetter goatest.ResponseSetterFunc = func(r interface{}) { resp = r }
	)
	if service == nil {
		service = goatest.Service(&logBuf, respSetter)
	} else {
		logger := log.New(&logBuf, "", log.Ltime)
		service.WithLogger(goa.NewLogger(logger))
		newEncoder := func(io.Writer) goa.Encoder { return respSetter }
		service.Encoder = goa.NewHTTPEncoder() // Make sure the code ends up using this decoder
		service.Encoder.Register(newEncoder, "*/*")
	}

	// Setup request context
	rw := httptest.NewRecorder()
	query := url.Values{}
	if datetimeFormat != nil {
		sliceVal := []string{*datetimeFormat}
		query["datetime-format"] = sliceVal
	}
	if from != nil {
		sliceVal := []string{(*from).Format(time.RFC3339)}
		query["from"] = sliceVal
	}
	{
		sliceVal := []string{strconv.Itoa(limit)}
		query["limit"] = sliceVal
	}
	if to != nil {
		sliceVal := []string{(*to).Format(time.RFC3339)}
		query["to"] = sliceVal
	}
	u := &url.URL{
		Path:     fmt.Sprintf("/snapshots"),
		RawQuery: query.Encode(),
	}
	req, err := http.NewRequest("GET", u.String(), nil)
	if err != nil {
		panic("invalid test " + err.Error()) // bug
	}
	prms := url.Values{}
	if datetimeFormat != nil {
		sliceVal := []string{*datetimeFormat}
		prms["datetime-format"] = sliceVal
	}
	if from != nil {
		sliceVal := []string{(*from).Format(time.RFC3339)}
		prms["from"] = sliceVal
	}
	{
		sliceVal := []string{strconv.Itoa(limit)}
		prms["limit"] = sliceVal
	}
	if to != nil {
		sliceVal := []string{(*to).Format(time.RFC3339)}
		prms["to"] = sliceVal
	}
	if ctx == nil {
		ctx = context.Background()
	}
	goaCtx := goa.NewContext(goa.WithAction(ctx, "SnapshotTest"), rw, req, prms)
	listCtx, err := app.NewListSnapshotContext(goaCtx, service)
	if err != nil {
		panic("invalid test data " + err.Error()) // bug
	}

	// Perform action
	err = ctrl.List(listCtx)

	// Validate response
	if err != nil {
		t.Fatalf("controller returned %s, logs:\n%s", err, logBuf.String())
	}
	if rw.Code != 200 {
		t.Errorf("invalid response status code: got %+v, expected 200", rw.Code)
	}
	var mt app.SnapshotMediaCollection
	if resp != nil {
		var ok bool
		mt, ok = resp.(app.SnapshotMediaCollection)
		if !ok {
			t.Fatalf("invalid response media: got %+v, expected instance of app.SnapshotMediaCollection", resp)
		}
		err = mt.Validate()
		if err != nil {
			t.Errorf("invalid response media type: %s", err)
		}
	}

	// Return results
	return rw, mt
}

// ListSnapshotOKListed runs the method List of the given controller with the given parameters.
// It returns the response writer so it's possible to inspect the response headers and the media type struct written to the response.
// If ctx is nil then context.Background() is used.
// If service is nil then a default service is created.
func ListSnapshotOKListed(t goatest.TInterface, ctx context.Context, service *goa.Service, ctrl app.SnapshotController, datetimeFormat *string, from *time.Time, limit int, to *time.Time) (http.ResponseWriter, app.SnapshotMediaListedCollection) {
	// Setup service
	var (
		logBuf bytes.Buffer
		resp   interface{}

		respSetter goatest.ResponseSetterFunc = func(r interface{}) { resp = r }
	)
	if service == nil {
		service = goatest.Service(&logBuf, respSetter)
	} else {
		logger := log.New(&logBuf, "", log.Ltime)
		service.WithLogger(goa.NewLogger(logger))
		newEncoder := func(io.Writer) goa.Encoder { return respSetter }
		service.Encoder = goa.NewHTTPEncoder() // Make sure the code ends up using this decoder
		service.Encoder.Register(newEncoder, "*/*")
	}

	// Setup request context
	rw := httptest.NewRecorder()
	query := url.Values{}
	if datetimeFormat != nil {
		sliceVal := []string{*datetimeFormat}
		query["datetime-format"] = sliceVal
	}
	if from != nil {
		sliceVal := []string{(*from).Format(time.RFC3339)}
		query["from"] = sliceVal
	}
	{
		sliceVal := []string{strconv.Itoa(limit)}
		query["limit"] = sliceVal
	}
	if to != nil {
		sliceVal := []string{(*to).Format(time.RFC3339)}
		query["to"] = sliceVal
	}
	u := &url.URL{
		Path:     fmt.Sprintf("/snapshots"),
		RawQuery: query.Encode(),
	}
	req, err := http.NewRequest("GET", u.String(), nil)
	if err != nil {
		panic("invalid test " + err.Error()) // bug
	}
	prms := url.Values{}
	if datetimeFormat != nil {
		sliceVal := []string{*datetimeFormat}
		prms["datetime-format"] = sliceVal
	}
	if from != nil {
		sliceVal := []string{(*from).Format(time.RFC3339)}
		prms["from"] = sliceVal
	}
	{
		sliceVal := []string{strconv.Itoa(limit)}
		prms["limit"] = sliceVal
	}
	if to != nil {
		sliceVal := []string{(*to).Format(time.RFC3339)}
		prms["to"] = sliceVal
	}
	if ctx == nil {
		ctx = context.Background()
	}
	goaCtx := goa.NewContext(goa.WithAction(ctx, "SnapshotTest"), rw, req, prms)
	listCtx, err := app.NewListSnapshotContext(goaCtx, service)
	if err != nil {
		panic("invalid test data " + err.Error()) // bug
	}

	// Perform action
	err = ctrl.List(listCtx)

	// Validate response
	if err != nil {
		t.Fatalf("controller returned %s, logs:\n%s", err, logBuf.String())
	}
	if rw.Code != 200 {
		t.Errorf("invalid response status code: got %+v, expected 200", rw.Code)
	}
	var mt app.SnapshotMediaListedCollection
	if resp != nil {
		var ok bool
		mt, ok = resp.(app.SnapshotMediaListedCollection)
		if !ok {
			t.Fatalf("invalid response media: got %+v, expected instance of app.SnapshotMediaListedCollection", resp)
		}
		err = mt.Validate()
		if err != nil {
			t.Errorf("invalid response media type: %s", err)
		}
	}

	// Return results
	return rw, mt
}

// ShowSnapshotNotFound runs the method Show of the given controller with the given parameters.
// It returns the response writer so it's possible to inspect the response headers.
// If ctx is nil then context.Background() is used.
// If service is nil then a default service is created.
func ShowSnapshotNotFound(t goatest.TInterface, ctx context.Context, service *goa.Service, ctrl app.SnapshotController, snapshotID int, datetimeFormat *string) http.ResponseWriter {
	// Setup service
	var (
		logBuf bytes.Buffer
		resp   interface{}

		respSetter goatest.ResponseSetterFunc = func(r interface{}) { resp = r }
	)
	if service == nil {
		service = goatest.Service(&logBuf, respSetter)
	} else {
		logger := log.New(&logBuf, "", log.Ltime)
		service.WithLogger(goa.NewLogger(logger))
		newEncoder := func(io.Writer) goa.Encoder { return respSetter }
		service.Encoder = goa.NewHTTPEncoder() // Make sure the code ends up using this decoder
		service.Encoder.Register(newEncoder, "*/*")
	}

	// Setup request context
	rw := httptest.NewRecorder()
	query := url.Values{}
	if datetimeFormat != nil {
		sliceVal := []string{*datetimeFormat}
		query["datetime-format"] = sliceVal
	}
	u := &url.URL{
		Path:     fmt.Sprintf("/snapshots/%v", snapshotID),
		RawQuery: query.Encode(),
	}
	req, err := http.NewRequest("GET", u.String(), nil)
	if err != nil {
		panic("invalid test " + err.Error()) // bug
	}
	prms := url.Values{}
	prms["snapshot_id"] = []string{fmt.Sprintf("%v", snapshotID)}
	if datetimeFormat != nil {
		sliceVal := []string{*datetimeFormat}
		prms["datetime-format"] = sliceVal
	}
	if ctx == nil {
		ctx = context.Background()
	}
	goaCtx := goa.NewContext(goa.WithAction(ctx, "SnapshotTest"), rw, req, prms)
	showCtx, err := app.NewShowSnapshotContext(goaCtx, service)
	if err != nil {
		panic("invalid test data " + err.Error()) // bug
	}

	// Perform action
	err = ctrl.Show(showCtx)

	// Validate response
	if err != nil {
		t.Fatalf("controller returned %s, logs:\n%s", err, logBuf.String())
	}
	if rw.Code != 404 {
		t.Errorf("invalid response status code: got %+v, expected 404", rw.Code)
	}

	// Return results
	return rw
}

// ShowSnapshotOK runs the method Show of the given controller with the given parameters.
// It returns the response writer so it's possible to inspect the response headers and the media type struct written to the response.
// If ctx is nil then context.Background() is used.
// If service is nil then a default service is created.
func ShowSnapshotOK(t goatest.TInterface, ctx context.Context, service *goa.Service, ctrl app.SnapshotController, snapshotID int, datetimeFormat *string) (http.ResponseWriter, *app.SnapshotMedia) {
	// Setup service
	var (
		logBuf bytes.Buffer
		resp   interface{}

		respSetter goatest.ResponseSetterFunc = func(r interface{}) { resp = r }
	)
	if service == nil {
		service = goatest.Service(&logBuf, respSetter)
	} else {
		logger := log.New(&logBuf, "", log.Ltime)
		service.WithLogger(goa.NewLogger(logger))
		newEncoder := func(io.Writer) goa.Encoder { return respSetter }
		service.Encoder = goa.NewHTTPEncoder() // Make sure the code ends up using this decoder
		service.Encoder.Register(newEncoder, "*/*")
	}

	// Setup request context
	rw := httptest.NewRecorder()
	query := url.Values{}
	if datetimeFormat != nil {
		sliceVal := []string{*datetimeFormat}
		query["datetime-format"] = sliceVal
	}
	u := &url.URL{
		Path:     fmt.Sprintf("/snapshots/%v", snapshotID),
		RawQuery: query.Encode(),
	}
	req, err := http.NewRequest("GET", u.String(), nil)
	if err != nil {
		panic("invalid test " + err.Error()) // bug
	}
	prms := url.Values{}
	prms["snapshot_id"] = []string{fmt.Sprintf("%v", snapshotID)}
	if datetimeFormat != nil {
		sliceVal := []string{*datetimeFormat}
		prms["datetime-format"] = sliceVal
	}
	if ctx == nil {
		ctx = context.Background()
	}
	goaCtx := goa.NewContext(goa.WithAction(ctx, "SnapshotTest"), rw, req, prms)
	showCtx, err := app.NewShowSnapshotContext(goaCtx, service)
	if err != nil {
		panic("invalid test data " + err.Error()) // bug
	}

	// Perform action
	err = ctrl.Show(showCtx)

	// Validate response
	if err != nil {
		t.Fatalf("controller returned %s, logs:\n%s", err, logBuf.String())
	}
	if rw.Code != 200 {
		t.Errorf("invalid response status code: got %+v, expected 200", rw.Code)
	}
	var mt *app.SnapshotMedia
	if resp != nil {
		var ok bool
		mt, ok = resp.(*app.SnapshotMedia)
		if !ok {
			t.Fatalf("invalid response media: got %+v, expected instance of app.SnapshotMedia", resp)
		}
		err = mt.Validate()
		if err != nil {
			t.Errorf("invalid response media type: %s", err)
		}
	}

	// Return results
	return rw, mt
}

// ShowSnapshotOKListed runs the method Show of the given controller with the given parameters.
// It returns the response writer so it's possible to inspect the response headers and the media type struct written to the response.
// If ctx is nil then context.Background() is used.
// If service is nil then a default service is created.
func ShowSnapshotOKListed(t goatest.TInterface, ctx context.Context, service *goa.Service, ctrl app.SnapshotController, snapshotID int, datetimeFormat *string) (http.ResponseWriter, *app.SnapshotMediaListed) {
	// Setup service
	var (
		logBuf bytes.Buffer
		resp   interface{}

		respSetter goatest.ResponseSetterFunc = func(r interface{}) { resp = r }
	)
	if service == nil {
		service = goatest.Service(&logBuf, respSetter)
	} else {
		logger := log.New(&logBuf, "", log.Ltime)
		service.WithLogger(goa.NewLogger(logger))
		newEncoder := func(io.Writer) goa.Encoder { return respSetter }
		service.Encoder = goa.NewHTTPEncoder() // Make sure the code ends up using this decoder
		service.Encoder.Register(newEncoder, "*/*")
	}

	// Setup request context
	rw := httptest.NewRecorder()
	query := url.Values{}
	if datetimeFormat != nil {
		sliceVal := []string{*datetimeFormat}
		query["datetime-format"] = sliceVal
	}
	u := &url.URL{
		Path:     fmt.Sprintf("/snapshots/%v", snapshotID),
		RawQuery: query.Encode(),
	}
	req, err := http.NewRequest("GET", u.String(), nil)
	if err != nil {
		panic("invalid test " + err.Error()) // bug
	}
	prms := url.Values{}
	prms["snapshot_id"] = []string{fmt.Sprintf("%v", snapshotID)}
	if datetimeFormat != nil {
		sliceVal := []string{*datetimeFormat}
		prms["datetime-format"] = sliceVal
	}
	if ctx == nil {
		ctx = context.Background()
	}
	goaCtx := goa.NewContext(goa.WithAction(ctx, "SnapshotTest"), rw, req, prms)
	showCtx, err := app.NewShowSnapshotContext(goaCtx, service)
	if err != nil {
		panic("invalid test data " + err.Error()) // bug
	}

	// Perform action
	err = ctrl.Show(showCtx)

	// Validate response
	if err != nil {
		t.Fatalf("controller returned %s, logs:\n%s", err, logBuf.String())
	}
	if rw.Code != 200 {
		t.Errorf("invalid response status code: got %+v, expected 200", rw.Code)
	}
	var mt *app.SnapshotMediaListed
	if resp != nil {
		var ok bool
		mt, ok = resp.(*app.SnapshotMediaListed)
		if !ok {
			t.Fatalf("invalid response media: got %+v, expected instance of app.SnapshotMediaListed", resp)
		}
		err = mt.Validate()
		if err != nil {
			t.Errorf("invalid response media type: %s", err)
		}
	}

	// Return results
	return rw, mt
}
