// Code generated by goagen v1.1.0-dirty, command line:
// $ goagen
// --design=code.justin.tv/dta/necronomicon-user-api/design
// --out=$(GOPATH)/src/code.justin.tv/dta/necronomicon-user-api
// --version=v1.1.0-dirty
//
// API "Necronomicon User API": Application User Types
//
// The content of this file is auto-generated, DO NOT MODIFY

package app

import (
	"github.com/goadesign/goa"
	"time"
)

// agent user type.
type agent struct {
	// Host
	Name      *string    `form:"name,omitempty" json:"name,omitempty" xml:"name,omitempty"`
	Status    *string    `form:"status,omitempty" json:"status,omitempty" xml:"status,omitempty"`
	Timestamp *time.Time `form:"timestamp,omitempty" json:"timestamp,omitempty" xml:"timestamp,omitempty"`
}

// Validate validates the agent type instance.
func (ut *agent) Validate() (err error) {
	if ut.Status == nil {
		err = goa.MergeErrors(err, goa.MissingAttributeError(`response`, "status"))
	}
	if ut.Timestamp == nil {
		err = goa.MergeErrors(err, goa.MissingAttributeError(`response`, "timestamp"))
	}
	if ut.Name == nil {
		err = goa.MergeErrors(err, goa.MissingAttributeError(`response`, "name"))
	}
	if ut.Status != nil {
		if !(*ut.Status == "success" || *ut.Status == "pending" || *ut.Status == "failure") {
			err = goa.MergeErrors(err, goa.InvalidEnumValueError(`response.status`, *ut.Status, []interface{}{"success", "pending", "failure"}))
		}
	}
	return
}

// Publicize creates Agent from agent
func (ut *agent) Publicize() *Agent {
	var pub Agent
	if ut.Name != nil {
		pub.Name = *ut.Name
	}
	if ut.Status != nil {
		pub.Status = *ut.Status
	}
	if ut.Timestamp != nil {
		pub.Timestamp = *ut.Timestamp
	}
	return &pub
}

// Agent user type.
type Agent struct {
	// Host
	Name      string    `form:"name" json:"name" xml:"name"`
	Status    string    `form:"status" json:"status" xml:"status"`
	Timestamp time.Time `form:"timestamp" json:"timestamp" xml:"timestamp"`
}

// Validate validates the Agent type instance.
func (ut *Agent) Validate() (err error) {
	if ut.Status == "" {
		err = goa.MergeErrors(err, goa.MissingAttributeError(`response`, "status"))
	}

	if ut.Name == "" {
		err = goa.MergeErrors(err, goa.MissingAttributeError(`response`, "name"))
	}
	if !(ut.Status == "success" || ut.Status == "pending" || ut.Status == "failure") {
		err = goa.MergeErrors(err, goa.InvalidEnumValueError(`response.status`, ut.Status, []interface{}{"success", "pending", "failure"}))
	}
	return
}

// deploymentPayload user type.
type deploymentPayload struct {
	// A message
	Message *string `form:"message,omitempty" json:"message,omitempty" xml:"message,omitempty"`
	// The snapshot ID
	SnapshotID *int `form:"snapshot_id,omitempty" json:"snapshot_id,omitempty" xml:"snapshot_id,omitempty"`
}

// Validate validates the deploymentPayload type instance.
func (ut *deploymentPayload) Validate() (err error) {
	if ut.SnapshotID == nil {
		err = goa.MergeErrors(err, goa.MissingAttributeError(`response`, "snapshot_id"))
	}
	if ut.Message == nil {
		err = goa.MergeErrors(err, goa.MissingAttributeError(`response`, "message"))
	}
	return
}

// Publicize creates DeploymentPayload from deploymentPayload
func (ut *deploymentPayload) Publicize() *DeploymentPayload {
	var pub DeploymentPayload
	if ut.Message != nil {
		pub.Message = *ut.Message
	}
	if ut.SnapshotID != nil {
		pub.SnapshotID = *ut.SnapshotID
	}
	return &pub
}

// DeploymentPayload user type.
type DeploymentPayload struct {
	// A message
	Message string `form:"message" json:"message" xml:"message"`
	// The snapshot ID
	SnapshotID int `form:"snapshot_id" json:"snapshot_id" xml:"snapshot_id"`
}

// Validate validates the DeploymentPayload type instance.
func (ut *DeploymentPayload) Validate() (err error) {

	if ut.Message == "" {
		err = goa.MergeErrors(err, goa.MissingAttributeError(`response`, "message"))
	}
	return
}

// snapshotChangeType user type.
type snapshotChangeType struct {
	// Environment Name
	Name *string `form:"name,omitempty" json:"name,omitempty" xml:"name,omitempty"`
	// Operation that occured.
	Operation *string `form:"operation,omitempty" json:"operation,omitempty" xml:"operation,omitempty"`
	// Parent environment
	Parent *string `form:"parent,omitempty" json:"parent,omitempty" xml:"parent,omitempty"`
	// JSON
	Values map[string]map[string]interface{} `form:"values,omitempty" json:"values,omitempty" xml:"values,omitempty"`
}

// Validate validates the snapshotChangeType type instance.
func (ut *snapshotChangeType) Validate() (err error) {
	if ut.Name == nil {
		err = goa.MergeErrors(err, goa.MissingAttributeError(`response`, "name"))
	}
	if ut.Operation == nil {
		err = goa.MergeErrors(err, goa.MissingAttributeError(`response`, "operation"))
	}
	if ut.Values == nil {
		err = goa.MergeErrors(err, goa.MissingAttributeError(`response`, "values"))
	}
	if ut.Operation != nil {
		if !(*ut.Operation == "modified" || *ut.Operation == "deleted") {
			err = goa.MergeErrors(err, goa.InvalidEnumValueError(`response.operation`, *ut.Operation, []interface{}{"modified", "deleted"}))
		}
	}
	return
}

// Publicize creates SnapshotChangeType from snapshotChangeType
func (ut *snapshotChangeType) Publicize() *SnapshotChangeType {
	var pub SnapshotChangeType
	if ut.Name != nil {
		pub.Name = *ut.Name
	}
	if ut.Operation != nil {
		pub.Operation = *ut.Operation
	}
	if ut.Parent != nil {
		pub.Parent = ut.Parent
	}
	if ut.Values != nil {
		pub.Values = ut.Values
	}
	return &pub
}

// SnapshotChangeType user type.
type SnapshotChangeType struct {
	// Environment Name
	Name string `form:"name" json:"name" xml:"name"`
	// Operation that occured.
	Operation string `form:"operation" json:"operation" xml:"operation"`
	// Parent environment
	Parent *string `form:"parent,omitempty" json:"parent,omitempty" xml:"parent,omitempty"`
	// JSON
	Values map[string]map[string]interface{} `form:"values" json:"values" xml:"values"`
}

// Validate validates the SnapshotChangeType type instance.
func (ut *SnapshotChangeType) Validate() (err error) {
	if ut.Name == "" {
		err = goa.MergeErrors(err, goa.MissingAttributeError(`response`, "name"))
	}
	if ut.Operation == "" {
		err = goa.MergeErrors(err, goa.MissingAttributeError(`response`, "operation"))
	}
	if ut.Values == nil {
		err = goa.MergeErrors(err, goa.MissingAttributeError(`response`, "values"))
	}
	if !(ut.Operation == "modified" || ut.Operation == "deleted") {
		err = goa.MergeErrors(err, goa.InvalidEnumValueError(`response.operation`, ut.Operation, []interface{}{"modified", "deleted"}))
	}
	return
}

// snapshotPayload user type.
type snapshotPayload struct {
	Environments []*snapshotChangeType `form:"environments,omitempty" json:"environments,omitempty" xml:"environments,omitempty"`
	// The snapshot message
	Message *string `form:"message,omitempty" json:"message,omitempty" xml:"message,omitempty"`
}

// Validate validates the snapshotPayload type instance.
func (ut *snapshotPayload) Validate() (err error) {
	if ut.Message == nil {
		err = goa.MergeErrors(err, goa.MissingAttributeError(`response`, "message"))
	}
	if ut.Environments == nil {
		err = goa.MergeErrors(err, goa.MissingAttributeError(`response`, "environments"))
	}
	for _, e := range ut.Environments {
		if e != nil {
			if err2 := e.Validate(); err2 != nil {
				err = goa.MergeErrors(err, err2)
			}
		}
	}
	return
}

// Publicize creates SnapshotPayload from snapshotPayload
func (ut *snapshotPayload) Publicize() *SnapshotPayload {
	var pub SnapshotPayload
	if ut.Environments != nil {
		pub.Environments = make([]*SnapshotChangeType, len(ut.Environments))
		for i2, elem2 := range ut.Environments {
			pub.Environments[i2] = elem2.Publicize()
		}
	}
	if ut.Message != nil {
		pub.Message = *ut.Message
	}
	return &pub
}

// SnapshotPayload user type.
type SnapshotPayload struct {
	Environments []*SnapshotChangeType `form:"environments" json:"environments" xml:"environments"`
	// The snapshot message
	Message string `form:"message" json:"message" xml:"message"`
}

// Validate validates the SnapshotPayload type instance.
func (ut *SnapshotPayload) Validate() (err error) {
	if ut.Message == "" {
		err = goa.MergeErrors(err, goa.MissingAttributeError(`response`, "message"))
	}
	if ut.Environments == nil {
		err = goa.MergeErrors(err, goa.MissingAttributeError(`response`, "environments"))
	}
	for _, e := range ut.Environments {
		if e != nil {
			if err2 := e.Validate(); err2 != nil {
				err = goa.MergeErrors(err, err2)
			}
		}
	}
	return
}
