package client

import (
	"github.com/goadesign/goa"
	goaclient "github.com/goadesign/goa/client"
)

// Client is the Necronomicon User API service client.
type Client struct {
	*goaclient.Client
	BasicAuthSigner goaclient.Signer
	Encoder         *goa.HTTPEncoder
	Decoder         *goa.HTTPDecoder
}

// New instantiates the client.
func New(c goaclient.Doer) *Client {
	client := &Client{
		Client:  goaclient.New(c),
		Encoder: goa.NewHTTPEncoder(),
		Decoder: goa.NewHTTPDecoder(),
	}

	// Setup encoders and decoders
	client.Encoder.Register(goa.NewJSONEncoder, "application/json")
	client.Decoder.Register(goa.NewJSONDecoder, "application/json")

	// Setup default encoder and decoder
	client.Encoder.Register(goa.NewJSONEncoder, "*/*")
	client.Decoder.Register(goa.NewJSONDecoder, "*/*")

	return client
}

// SetBasicAuthSigner sets the request signer for the basic_auth security scheme.
func (c *Client) SetBasicAuthSigner(signer goaclient.Signer) {
	c.BasicAuthSigner = signer
}
