// Code generated by goagen v1.1.0-dirty, command line:
// $ goagen
// --design=code.justin.tv/dta/necronomicon-user-api/design
// --out=$(GOPATH)/src/code.justin.tv/dta/necronomicon-user-api
// --version=v1.1.0-dirty
//
// API "Necronomicon User API": Application Media Types
//
// The content of this file is auto-generated, DO NOT MODIFY

package client

import (
	"github.com/goadesign/goa"
	"net/http"
	"time"
)

// DecodeErrorResponse decodes the ErrorResponse instance encoded in resp body.
func (c *Client) DecodeErrorResponse(resp *http.Response) (*goa.ErrorResponse, error) {
	var decoded goa.ErrorResponse
	err := c.Decoder.Decode(&decoded, resp.Body, resp.Header.Get("Content-Type"))
	return &decoded, err
}

// TwitchDtaNecronomiconUserapiDeployment media type (default view)
//
// Identifier: application/vnd.twitch.dta.necronomicon.userapi.deployment+json; view=default
type TwitchDtaNecronomiconUserapiDeployment struct {
	// List of Agents
	Agents       []*Agent `form:"agents" json:"agents" xml:"agents"`
	DeploymentID int      `form:"deployment_id" json:"deployment_id" xml:"deployment_id"`
	Message      string   `form:"message" json:"message" xml:"message"`
	SnapshotID   int      `form:"snapshot_id" json:"snapshot_id" xml:"snapshot_id"`
	// List of targets
	Targets map[string][]string `form:"targets" json:"targets" xml:"targets"`
	// Creation time
	Timestamp time.Time `form:"timestamp" json:"timestamp" xml:"timestamp"`
	User      string    `form:"user" json:"user" xml:"user"`
}

// Validate validates the TwitchDtaNecronomiconUserapiDeployment media type instance.
func (mt *TwitchDtaNecronomiconUserapiDeployment) Validate() (err error) {

	if mt.User == "" {
		err = goa.MergeErrors(err, goa.MissingAttributeError(`response`, "user"))
	}
	if mt.Message == "" {
		err = goa.MergeErrors(err, goa.MissingAttributeError(`response`, "message"))
	}

	if mt.Targets == nil {
		err = goa.MergeErrors(err, goa.MissingAttributeError(`response`, "targets"))
	}
	if mt.Agents == nil {
		err = goa.MergeErrors(err, goa.MissingAttributeError(`response`, "agents"))
	}
	for _, e := range mt.Agents {
		if e != nil {
			if err2 := e.Validate(); err2 != nil {
				err = goa.MergeErrors(err, err2)
			}
		}
	}
	return
}

// TwitchDtaNecronomiconUserapiDeployment media type (listed view)
//
// Identifier: application/vnd.twitch.dta.necronomicon.userapi.deployment+json; view=listed
type TwitchDtaNecronomiconUserapiDeploymentListed struct {
	DeploymentID int    `form:"deployment_id" json:"deployment_id" xml:"deployment_id"`
	Message      string `form:"message" json:"message" xml:"message"`
	SnapshotID   int    `form:"snapshot_id" json:"snapshot_id" xml:"snapshot_id"`
	// Creation time
	Timestamp time.Time `form:"timestamp" json:"timestamp" xml:"timestamp"`
	User      string    `form:"user" json:"user" xml:"user"`
}

// Validate validates the TwitchDtaNecronomiconUserapiDeploymentListed media type instance.
func (mt *TwitchDtaNecronomiconUserapiDeploymentListed) Validate() (err error) {

	if mt.User == "" {
		err = goa.MergeErrors(err, goa.MissingAttributeError(`response`, "user"))
	}
	if mt.Message == "" {
		err = goa.MergeErrors(err, goa.MissingAttributeError(`response`, "message"))
	}

	return
}

// DecodeTwitchDtaNecronomiconUserapiDeployment decodes the TwitchDtaNecronomiconUserapiDeployment instance encoded in resp body.
func (c *Client) DecodeTwitchDtaNecronomiconUserapiDeployment(resp *http.Response) (*TwitchDtaNecronomiconUserapiDeployment, error) {
	var decoded TwitchDtaNecronomiconUserapiDeployment
	err := c.Decoder.Decode(&decoded, resp.Body, resp.Header.Get("Content-Type"))
	return &decoded, err
}

// DecodeTwitchDtaNecronomiconUserapiDeploymentListed decodes the TwitchDtaNecronomiconUserapiDeploymentListed instance encoded in resp body.
func (c *Client) DecodeTwitchDtaNecronomiconUserapiDeploymentListed(resp *http.Response) (*TwitchDtaNecronomiconUserapiDeploymentListed, error) {
	var decoded TwitchDtaNecronomiconUserapiDeploymentListed
	err := c.Decoder.Decode(&decoded, resp.Body, resp.Header.Get("Content-Type"))
	return &decoded, err
}

// TwitchDtaNecronomiconUserapiDeploymentCollection is the media type for an array of TwitchDtaNecronomiconUserapiDeployment (default view)
//
// Identifier: application/vnd.twitch.dta.necronomicon.userapi.deployment+json; type=collection; view=default
type TwitchDtaNecronomiconUserapiDeploymentCollection []*TwitchDtaNecronomiconUserapiDeployment

// Validate validates the TwitchDtaNecronomiconUserapiDeploymentCollection media type instance.
func (mt TwitchDtaNecronomiconUserapiDeploymentCollection) Validate() (err error) {
	for _, e := range mt {
		if e != nil {
			if err2 := e.Validate(); err2 != nil {
				err = goa.MergeErrors(err, err2)
			}
		}
	}
	return
}

// TwitchDtaNecronomiconUserapiDeploymentCollection is the media type for an array of TwitchDtaNecronomiconUserapiDeployment (listed view)
//
// Identifier: application/vnd.twitch.dta.necronomicon.userapi.deployment+json; type=collection; view=listed
type TwitchDtaNecronomiconUserapiDeploymentListedCollection []*TwitchDtaNecronomiconUserapiDeploymentListed

// Validate validates the TwitchDtaNecronomiconUserapiDeploymentListedCollection media type instance.
func (mt TwitchDtaNecronomiconUserapiDeploymentListedCollection) Validate() (err error) {
	for _, e := range mt {
		if e != nil {
			if err2 := e.Validate(); err2 != nil {
				err = goa.MergeErrors(err, err2)
			}
		}
	}
	return
}

// DecodeTwitchDtaNecronomiconUserapiDeploymentCollection decodes the TwitchDtaNecronomiconUserapiDeploymentCollection instance encoded in resp body.
func (c *Client) DecodeTwitchDtaNecronomiconUserapiDeploymentCollection(resp *http.Response) (TwitchDtaNecronomiconUserapiDeploymentCollection, error) {
	var decoded TwitchDtaNecronomiconUserapiDeploymentCollection
	err := c.Decoder.Decode(&decoded, resp.Body, resp.Header.Get("Content-Type"))
	return decoded, err
}

// DecodeTwitchDtaNecronomiconUserapiDeploymentListedCollection decodes the TwitchDtaNecronomiconUserapiDeploymentListedCollection instance encoded in resp body.
func (c *Client) DecodeTwitchDtaNecronomiconUserapiDeploymentListedCollection(resp *http.Response) (TwitchDtaNecronomiconUserapiDeploymentListedCollection, error) {
	var decoded TwitchDtaNecronomiconUserapiDeploymentListedCollection
	err := c.Decoder.Decode(&decoded, resp.Body, resp.Header.Get("Content-Type"))
	return decoded, err
}

// An environment Kappa (default view)
//
// Identifier: application/vnd.twitch.dta.necronomicon.userapi.environment+json; view=default
type EnvironmentMedia struct {
	Name   string                            `form:"name" json:"name" xml:"name"`
	Parent *string                           `form:"parent,omitempty" json:"parent,omitempty" xml:"parent,omitempty"`
	Values map[string]map[string]interface{} `form:"values" json:"values" xml:"values"`
}

// Validate validates the EnvironmentMedia media type instance.
func (mt *EnvironmentMedia) Validate() (err error) {
	if mt.Name == "" {
		err = goa.MergeErrors(err, goa.MissingAttributeError(`response`, "name"))
	}
	if mt.Values == nil {
		err = goa.MergeErrors(err, goa.MissingAttributeError(`response`, "values"))
	}
	return
}

// An environment Kappa (merged view)
//
// Identifier: application/vnd.twitch.dta.necronomicon.userapi.environment+json; view=merged
type EnvironmentMediaMerged struct {
	Name   string                            `form:"name" json:"name" xml:"name"`
	Values map[string]map[string]interface{} `form:"values" json:"values" xml:"values"`
}

// Validate validates the EnvironmentMediaMerged media type instance.
func (mt *EnvironmentMediaMerged) Validate() (err error) {
	if mt.Name == "" {
		err = goa.MergeErrors(err, goa.MissingAttributeError(`response`, "name"))
	}
	if mt.Values == nil {
		err = goa.MergeErrors(err, goa.MissingAttributeError(`response`, "values"))
	}
	return
}

// DecodeEnvironmentMedia decodes the EnvironmentMedia instance encoded in resp body.
func (c *Client) DecodeEnvironmentMedia(resp *http.Response) (*EnvironmentMedia, error) {
	var decoded EnvironmentMedia
	err := c.Decoder.Decode(&decoded, resp.Body, resp.Header.Get("Content-Type"))
	return &decoded, err
}

// DecodeEnvironmentMediaMerged decodes the EnvironmentMediaMerged instance encoded in resp body.
func (c *Client) DecodeEnvironmentMediaMerged(resp *http.Response) (*EnvironmentMediaMerged, error) {
	var decoded EnvironmentMediaMerged
	err := c.Decoder.Decode(&decoded, resp.Body, resp.Header.Get("Content-Type"))
	return &decoded, err
}

// EnvironmentMediaCollection is the media type for an array of EnvironmentMedia (default view)
//
// Identifier: application/vnd.twitch.dta.necronomicon.userapi.environment+json; type=collection; view=default
type EnvironmentMediaCollection []*EnvironmentMedia

// Validate validates the EnvironmentMediaCollection media type instance.
func (mt EnvironmentMediaCollection) Validate() (err error) {
	for _, e := range mt {
		if e != nil {
			if err2 := e.Validate(); err2 != nil {
				err = goa.MergeErrors(err, err2)
			}
		}
	}
	return
}

// DecodeEnvironmentMediaCollection decodes the EnvironmentMediaCollection instance encoded in resp body.
func (c *Client) DecodeEnvironmentMediaCollection(resp *http.Response) (EnvironmentMediaCollection, error) {
	var decoded EnvironmentMediaCollection
	err := c.Decoder.Decode(&decoded, resp.Body, resp.Header.Get("Content-Type"))
	return decoded, err
}

// A snapshot! (default view)
//
// Identifier: application/vnd.twitch.dta.necronomicon.userapi.snapshot+json; view=default
type SnapshotMedia struct {
	// Changes committed in the snapshot
	Changes TwitchDtaNecronomiconUserapiSnapshotChangeCollection `form:"changes,omitempty" json:"changes,omitempty" xml:"changes,omitempty"`
	// A message
	Message string `form:"message" json:"message" xml:"message"`
	// Creation time
	Timestamp time.Time `form:"timestamp" json:"timestamp" xml:"timestamp"`
	// LDAP username
	User string `form:"user" json:"user" xml:"user"`
}

// Validate validates the SnapshotMedia media type instance.
func (mt *SnapshotMedia) Validate() (err error) {
	if mt.User == "" {
		err = goa.MergeErrors(err, goa.MissingAttributeError(`response`, "user"))
	}
	if mt.Message == "" {
		err = goa.MergeErrors(err, goa.MissingAttributeError(`response`, "message"))
	}

	if err2 := mt.Changes.Validate(); err2 != nil {
		err = goa.MergeErrors(err, err2)
	}
	return
}

// A snapshot! (listed view)
//
// Identifier: application/vnd.twitch.dta.necronomicon.userapi.snapshot+json; view=listed
type SnapshotMediaListed struct {
	// A message
	Message string `form:"message" json:"message" xml:"message"`
	// Unique snapshot ID
	SnapshotID int `form:"snapshot_id" json:"snapshot_id" xml:"snapshot_id"`
	// Creation time
	Timestamp time.Time `form:"timestamp" json:"timestamp" xml:"timestamp"`
	// LDAP username
	User string `form:"user" json:"user" xml:"user"`
}

// Validate validates the SnapshotMediaListed media type instance.
func (mt *SnapshotMediaListed) Validate() (err error) {

	if mt.User == "" {
		err = goa.MergeErrors(err, goa.MissingAttributeError(`response`, "user"))
	}
	if mt.Message == "" {
		err = goa.MergeErrors(err, goa.MissingAttributeError(`response`, "message"))
	}

	return
}

// DecodeSnapshotMedia decodes the SnapshotMedia instance encoded in resp body.
func (c *Client) DecodeSnapshotMedia(resp *http.Response) (*SnapshotMedia, error) {
	var decoded SnapshotMedia
	err := c.Decoder.Decode(&decoded, resp.Body, resp.Header.Get("Content-Type"))
	return &decoded, err
}

// DecodeSnapshotMediaListed decodes the SnapshotMediaListed instance encoded in resp body.
func (c *Client) DecodeSnapshotMediaListed(resp *http.Response) (*SnapshotMediaListed, error) {
	var decoded SnapshotMediaListed
	err := c.Decoder.Decode(&decoded, resp.Body, resp.Header.Get("Content-Type"))
	return &decoded, err
}

// TwitchDtaNecronomiconUserapiSnapshotChange media type (default view)
//
// Identifier: application/vnd.twitch.dta.necronomicon.userapi.snapshot.change+json; view=default
type TwitchDtaNecronomiconUserapiSnapshotChange struct {
	// Environment Name
	Name string `form:"name" json:"name" xml:"name"`
	// Operation that occured.
	Operation string `form:"operation" json:"operation" xml:"operation"`
	// Parent environment
	Parent *string `form:"parent,omitempty" json:"parent,omitempty" xml:"parent,omitempty"`
	// JSON
	Values map[string]map[string]interface{} `form:"values" json:"values" xml:"values"`
}

// Validate validates the TwitchDtaNecronomiconUserapiSnapshotChange media type instance.
func (mt *TwitchDtaNecronomiconUserapiSnapshotChange) Validate() (err error) {
	if mt.Name == "" {
		err = goa.MergeErrors(err, goa.MissingAttributeError(`response`, "name"))
	}
	if mt.Operation == "" {
		err = goa.MergeErrors(err, goa.MissingAttributeError(`response`, "operation"))
	}
	if mt.Values == nil {
		err = goa.MergeErrors(err, goa.MissingAttributeError(`response`, "values"))
	}
	if !(mt.Operation == "modified" || mt.Operation == "unmodified" || mt.Operation == "deleted") {
		err = goa.MergeErrors(err, goa.InvalidEnumValueError(`response.operation`, mt.Operation, []interface{}{"modified", "unmodified", "deleted"}))
	}
	return
}

// DecodeTwitchDtaNecronomiconUserapiSnapshotChange decodes the TwitchDtaNecronomiconUserapiSnapshotChange instance encoded in resp body.
func (c *Client) DecodeTwitchDtaNecronomiconUserapiSnapshotChange(resp *http.Response) (*TwitchDtaNecronomiconUserapiSnapshotChange, error) {
	var decoded TwitchDtaNecronomiconUserapiSnapshotChange
	err := c.Decoder.Decode(&decoded, resp.Body, resp.Header.Get("Content-Type"))
	return &decoded, err
}

// TwitchDtaNecronomiconUserapiSnapshotChangeCollection is the media type for an array of TwitchDtaNecronomiconUserapiSnapshotChange (default view)
//
// Identifier: application/vnd.twitch.dta.necronomicon.userapi.snapshot.change+json; type=collection; view=default
type TwitchDtaNecronomiconUserapiSnapshotChangeCollection []*TwitchDtaNecronomiconUserapiSnapshotChange

// Validate validates the TwitchDtaNecronomiconUserapiSnapshotChangeCollection media type instance.
func (mt TwitchDtaNecronomiconUserapiSnapshotChangeCollection) Validate() (err error) {
	for _, e := range mt {
		if e != nil {
			if err2 := e.Validate(); err2 != nil {
				err = goa.MergeErrors(err, err2)
			}
		}
	}
	return
}

// DecodeTwitchDtaNecronomiconUserapiSnapshotChangeCollection decodes the TwitchDtaNecronomiconUserapiSnapshotChangeCollection instance encoded in resp body.
func (c *Client) DecodeTwitchDtaNecronomiconUserapiSnapshotChangeCollection(resp *http.Response) (TwitchDtaNecronomiconUserapiSnapshotChangeCollection, error) {
	var decoded TwitchDtaNecronomiconUserapiSnapshotChangeCollection
	err := c.Decoder.Decode(&decoded, resp.Body, resp.Header.Get("Content-Type"))
	return decoded, err
}

// TwitchDtaNecronomiconUserapiSnapshotState media type (default view)
//
// Identifier: application/vnd.twitch.dta.necronomicon.userapi.snapshot.state+json; view=default
type TwitchDtaNecronomiconUserapiSnapshotState struct {
	// Parent environment
	Parent *string `form:"parent,omitempty" json:"parent,omitempty" xml:"parent,omitempty"`
	// JSON
	Values map[string]map[string]interface{} `form:"values" json:"values" xml:"values"`
}

// Validate validates the TwitchDtaNecronomiconUserapiSnapshotState media type instance.
func (mt *TwitchDtaNecronomiconUserapiSnapshotState) Validate() (err error) {
	if mt.Values == nil {
		err = goa.MergeErrors(err, goa.MissingAttributeError(`response`, "values"))
	}
	return
}

// DecodeTwitchDtaNecronomiconUserapiSnapshotState decodes the TwitchDtaNecronomiconUserapiSnapshotState instance encoded in resp body.
func (c *Client) DecodeTwitchDtaNecronomiconUserapiSnapshotState(resp *http.Response) (*TwitchDtaNecronomiconUserapiSnapshotState, error) {
	var decoded TwitchDtaNecronomiconUserapiSnapshotState
	err := c.Decoder.Decode(&decoded, resp.Body, resp.Header.Get("Content-Type"))
	return &decoded, err
}

// TwitchDtaNecronomiconUserapiSnapshotStatemap media type (default view)
//
// Identifier: application/vnd.twitch.dta.necronomicon.userapi.snapshot.statemap+json; view=default
type TwitchDtaNecronomiconUserapiSnapshotStatemap struct {
	// JSON
	Map map[string]*TwitchDtaNecronomiconUserapiSnapshotState `form:"map" json:"map" xml:"map"`
}

// Validate validates the TwitchDtaNecronomiconUserapiSnapshotStatemap media type instance.
func (mt *TwitchDtaNecronomiconUserapiSnapshotStatemap) Validate() (err error) {
	if mt.Map == nil {
		err = goa.MergeErrors(err, goa.MissingAttributeError(`response`, "map"))
	}
	return
}

// DecodeTwitchDtaNecronomiconUserapiSnapshotStatemap decodes the TwitchDtaNecronomiconUserapiSnapshotStatemap instance encoded in resp body.
func (c *Client) DecodeTwitchDtaNecronomiconUserapiSnapshotStatemap(resp *http.Response) (*TwitchDtaNecronomiconUserapiSnapshotStatemap, error) {
	var decoded TwitchDtaNecronomiconUserapiSnapshotStatemap
	err := c.Decoder.Decode(&decoded, resp.Body, resp.Header.Get("Content-Type"))
	return &decoded, err
}

// SnapshotMediaCollection is the media type for an array of SnapshotMedia (default view)
//
// Identifier: application/vnd.twitch.dta.necronomicon.userapi.snapshot+json; type=collection; view=default
type SnapshotMediaCollection []*SnapshotMedia

// Validate validates the SnapshotMediaCollection media type instance.
func (mt SnapshotMediaCollection) Validate() (err error) {
	for _, e := range mt {
		if e != nil {
			if err2 := e.Validate(); err2 != nil {
				err = goa.MergeErrors(err, err2)
			}
		}
	}
	return
}

// SnapshotMediaCollection is the media type for an array of SnapshotMedia (listed view)
//
// Identifier: application/vnd.twitch.dta.necronomicon.userapi.snapshot+json; type=collection; view=listed
type SnapshotMediaListedCollection []*SnapshotMediaListed

// Validate validates the SnapshotMediaListedCollection media type instance.
func (mt SnapshotMediaListedCollection) Validate() (err error) {
	for _, e := range mt {
		if e != nil {
			if err2 := e.Validate(); err2 != nil {
				err = goa.MergeErrors(err, err2)
			}
		}
	}
	return
}

// DecodeSnapshotMediaCollection decodes the SnapshotMediaCollection instance encoded in resp body.
func (c *Client) DecodeSnapshotMediaCollection(resp *http.Response) (SnapshotMediaCollection, error) {
	var decoded SnapshotMediaCollection
	err := c.Decoder.Decode(&decoded, resp.Body, resp.Header.Get("Content-Type"))
	return decoded, err
}

// DecodeSnapshotMediaListedCollection decodes the SnapshotMediaListedCollection instance encoded in resp body.
func (c *Client) DecodeSnapshotMediaListedCollection(resp *http.Response) (SnapshotMediaListedCollection, error) {
	var decoded SnapshotMediaListedCollection
	err := c.Decoder.Decode(&decoded, resp.Body, resp.Header.Get("Content-Type"))
	return decoded, err
}
