-- +goose Up
-- SQL in section 'Up' is executed when this migration is applied
CREATE TABLE snapshots (
  id          SERIAL PRIMARY KEY,
  "user"      TEXT NOT NULL,
  message     TEXT NOT NULL,
  changes     JSONB NOT NULL,
  state       JSONB NOT NULL,
  created_at  TIMESTAMP WITH time zone NOT NULL
);
CREATE INDEX snapshots_created_at_index ON snapshots(created_at DESC);

CREATE TABLE deployments (
  id          SERIAL PRIMARY KEY,
  "user"      TEXT NOT NULL,
  message     TEXT NOT NULL,
  created_at  TIMESTAMP WITH TIME ZONE NOT NULL,
  snapshot_id INTEGER NOT NULL REFERENCES snapshots
);
CREATE INDEX deployments_created_at_index ON deployments(created_at DESC);

-- +goose Down
-- SQL section 'Down' is executed when this migration is rolled back
DROP TABLE deployments;
-- DROP TABLE environments_snapshots;
-- DROP TABLE environments;
DROP TABLE snapshots;
