package design

import (
	. "github.com/goadesign/goa/design"
	. "github.com/goadesign/goa/design/apidsl"
)

var _ = API("Necronomicon User API", func() {
	Title("Necronomicon User API")
	Description("This is the Necronomicon User API.")
	Version("1.0")
	Contact(func() {
		Name("Devtools")
		Email("dta@justin.tv")
		URL("https://git-aws.internal.justin.tv/orgs/dta/teams/devtools")
	})
	Scheme("https")
	Host("necronomicon.internal.justin.tv")
	Params(func() {
		Param("datetime-format", String, "Timestamps are returned in the format requested.", func() {
			Enum("unix", "iso8601", "rfc1123")
		})
	})
	Consumes("application/json")
	Produces("application/json")
	BasePath("/")

	ResponseTemplate(Created, func(pattern string) {
		Description("Resource created")
		Status(201)
		Headers(func() {
			Header("Location", String, "href to created resource", func() {
				Pattern(pattern)
			})
		})
	})
})
