package design

import (
	. "github.com/goadesign/goa/design" // Use . imports to enable the DSL
	. "github.com/goadesign/goa/design/apidsl"
)

var SnapshotChangeMedia = MediaType("application/vnd.twitch.dta.necronomicon.userapi.snapshot.change+json", func() {
	Attribute("name", String, "Environment Name")
	Attribute("parent", String, "Parent environment")
	Attribute("operation", String, "Operation that occured.", func() {
		Enum("modified", "unmodified", "deleted")
	})
	Attribute("values", HashOf(String, HashOf(String, Any)), "JSON")
	Required("name", "operation", "values")
	View("default", func() {
		Attribute("name")
		Attribute("operation")
		Attribute("parent")
		Attribute("values")
	})
})

var SnapshotStateMedia = MediaType("application/vnd.twitch.dta.necronomicon.userapi.snapshot.state+json", func() {
	Attribute("name", String, "Environment name")
	Attribute("parent", String, "Parent environment")
	Attribute("values", HashOf(String, HashOf(String, Any)), "JSON")
	Required("name", "values")
	View("default", func() {
		Attribute("parent")
		Attribute("values")
	})
})

var SnapshotStateMapMedia = MediaType("application/vnd.twitch.dta.necronomicon.userapi.snapshot.statemap+json", func() {
	Attribute("map", HashOf(String, SnapshotStateMedia), "JSON")
	Required("map")
	View("default", func() {
		Attribute("map")
	})
})


var SnapshotMedia = MediaType("application/vnd.twitch.dta.necronomicon.userapi.snapshot+json", func() {
	Description("A snapshot!")
	TypeName("SnapshotMedia")
	ContentType("application/json")
	Attributes(func() {
		Attribute("snapshot_id", Integer, "Unique snapshot ID")
		Attribute("user", String, "LDAP username")
		Attribute("message", String, "A message")
		Attribute("timestamp", DateTime, "Creation time")
		//Attribute("changes", HashOf(String, HashOf(String, Any)), "Changes committed in the snapshot")
		Attribute("changes", CollectionOf(SnapshotChangeMedia), "Changes committed in the snapshot")
		Attribute("state", HashOf(String, SnapshotStateMedia), "Full state after snapshot commit")
		Required("snapshot_id", "user", "message", "timestamp")
	})
	View("default", func() {
		Attribute("user")
		Attribute("message")
		Attribute("timestamp")
		Attribute("changes")
	})
	View("listed", func() {
		Attribute("snapshot_id")
		Attribute("user")
		Attribute("message")
		Attribute("timestamp")
	})
})

var EnvironmentMedia = MediaType("application/vnd.twitch.dta.necronomicon.userapi.environment+json", func() {
	Description("An environment Kappa")
	TypeName("EnvironmentMedia")
	ContentType("application/json")
	Attributes(func() {
		Attribute("name", String)
		Attribute("parent", String)
		Attribute("values", HashOf(String, HashOf(String, Any)))
		Required("name", "values")
	})

	View("default", func() { // XXX
		Attribute("name")
		Attribute("parent")
		Attribute("values")
	})
	View("merged", func() {
		Attribute("name")
		Attribute("values")
	})
})

var DeploymentMedia = MediaType("application/vnd.twitch.dta.necronomicon.userapi.deployment+json", func() {
	Attribute("deployment_id", Integer)
	Attribute("snapshot_id", Integer)
	Attribute("user", String)
	Attribute("message", String)
	Attribute("timestamp", DateTime, "Creation time")
	Attribute("targets", HashOf(String, ArrayOf(String)), "List of targets")
	Attribute("agents", ArrayOf(Agent), "List of Agents")
	Required("deployment_id", "snapshot_id", "user", "message", "timestamp", "targets", "agents")
	View("default", func() {
		Attribute("deployment_id")
		Attribute("snapshot_id")
		Attribute("user")
		Attribute("message")
		Attribute("timestamp")
		Attribute("targets")
		Attribute("agents")
	})
	View("listed", func() {
		Attribute("deployment_id")
		Attribute("snapshot_id")
		Attribute("user")
		Attribute("message")
		Attribute("timestamp")
	})
})
