package design

import (
	. "github.com/goadesign/goa/design" // Use . imports to enable the DSL
	. "github.com/goadesign/goa/design/apidsl"
)

var SnapshotChangeType = Type("SnapshotChangeType", func() {
	Attribute("name", String, "Environment Name")
	Attribute("parent", String, "Parent environment")
	Attribute("operation", String, "Operation that occured.", func() {
		Enum("modified", "deleted")
	})
	Attribute("values", HashOf(String, HashOf(String, Any)), "JSON")
	Required("name", "operation", "values")
})

var SnapshotPayload = Type("SnapshotPayload", func() {
	Attribute("message", String, "The snapshot message")
	Attribute("environments", ArrayOf(SnapshotChangeType), "")
	Required("message", "environments")
})

var DeploymentPayload = Type("DeploymentPayload", func() {
	Attribute("snapshot_id", Integer, "The snapshot ID")
	Attribute("message", String, "A message")
	Required("snapshot_id", "message")
})

var Agent = Type("Agent", func() {
	Attribute("status", String, func() {
		Enum("success", "pending", "failure")
	})
	Attribute("timestamp", DateTime)
	Attribute("name", String, "Host")
	Required("status", "timestamp", "name")
})
