package main

import (
	"code.justin.tv/dta/necronomicon-user-api/app/test"
	"github.com/goadesign/goa"
	"golang.org/x/net/context"
	"testing"
)

func setupEnvironmentTest(t *testing.T) (db *DB, snapshotId int, service *goa.Service, ctrl *EnvironmentController, ctx context.Context) {
	db, snapshotId, err := CreateLotrSnapshots(t)
	if err != nil {
		t.Fatalf("Couldn't setup database for test")
		return
	}
	service = goa.New("necronomicon-user-api-test")
	resources := new(Resources)
	resources.db = db
	ctrl = NewEnvironmentController(service)
	ctrl.resources = resources
	ctx = context.Background()
	return
}

func TestShowEnvironmentOK(t *testing.T) {
	_, snapshotId, service, ctrl, ctx := setupEnvironmentTest(t)
	_, env := test.ShowEnvironmentOK(t, ctx, service, ctrl, snapshotId, "prod", nil)
	if env == nil {
		t.Fatalf("Couldn't get environment!")
	}
	if env.Name != "prod" {
		t.Fatalf("Was expecting environment `prod` but got `%s` instead", env.Name)
	}
}

func TestShowEnvironmentSnapshotNotFound(t *testing.T) {
	_, snapshotId, service, ctrl, ctx := setupEnvironmentTest(t)
	test.ShowEnvironmentNotFound(t, ctx, service, ctrl, snapshotId+999, "prod", nil)
}

func TestShowEnvironmentNotFound(t *testing.T) {
	_, snapshotId, service, ctrl, ctx := setupEnvironmentTest(t)
	test.ShowEnvironmentNotFound(t, ctx, service, ctrl, snapshotId, "somethingmissing", nil)
}

func TestListEnvironmentNotFound(t *testing.T) {
	_, snapshotId, service, ctrl, ctx := setupEnvironmentTest(t)
	test.ListEnvironmentNotFound(t, ctx, service, ctrl, snapshotId+999, nil)
}

//func TestListEnvironment(t *testing.T) {
//	_, snapshotId, service, ctrl, ctx := setupEnvironmentTest(t)
//	test.ListEnvironmentOK(t, ctx, service, ctrl, snapshotId)
//}
