freeStyleJob('dta-necronomicon-user-api-trigger') {
  triggers {
    githubPush()
  }
  scm {
    git {
      branches("*/master")
      remote {
        github 'dta/necronomicon-user-api', 'ssh', 'git-aws.internal.justin.tv'
        credentials 'git-aws-read-key'
      }
    }
  }
  steps {
    shell '''
cat <<EOF>output.properties
GIT_COMMIT=\$GIT_COMMIT
GIT_BRANCH=\$GIT_BRANCH
GIT_AUTHOR_NAME=\$GIT_AUTHOR_NAME
GIT_AUTHOR_EMAIL=\$GIT_AUTHOR_EMAIL
BUILD_ID=\$BUILD_ID
JOB_NAME=\$JOB_NAME
EOF
'''
  }
  publishers {
    archiveArtifacts('output.properties')
  }
}

freeStyleJob('dta-necronomicon-user-api-build-publish') {
  parameters {
    stringParam 'GIT_COMMIT'
  }
  scm {
    git {
      remote {
        github 'dta/necronomicon-user-api', 'ssh', 'git-aws.internal.justin.tv'
        credentials 'git-aws-read-key'
      }
    }
  }
  steps {
    shell '''
docker build -q -t docker.internal.justin.tv/dta/necronomicon/user-api/build:\$GIT_COMMIT .
docker push docker.internal.justin.tv/dta/necronomicon/user-api/build:\$GIT_COMMIT
'''
  }
}

freeStyleJob('dta-necronomicon-user-api-promote-staging') {
  parameters {
    stringParam 'GIT_COMMIT'
  }
  steps {
    shell '''
docker pull docker.internal.justin.tv/dta/necronomicon/user-api/build:\$GIT_COMMIT
docker tag docker.internal.justin.tv/dta/necronomicon/user-api/build:\$GIT_COMMIT docker.internal.justin.tv/dta/necronomicon/user-api/staging:\$GIT_COMMIT
docker push docker.internal.justin.tv/dta/necronomicon/user-api/staging:\$GIT_COMMIT
'''
  }
}

freeStyleJob('dta-necronomicon-user-api-promote-production') {
  parameters {
    stringParam 'GIT_COMMIT'
  }
  steps {
    shell '''
docker pull docker.internal.justin.tv/dta/necronomicon/user-api/build:\$GIT_COMMIT
docker tag docker.internal.justin.tv/dta/necronomicon/user-api/build:\$GIT_COMMIT docker.internal.justin.tv/dta/necronomicon/user-api/production:\$GIT_COMMIT
docker push docker.internal.justin.tv/dta/necronomicon/user-api/production:\$GIT_COMMIT
'''
  }
}
