
module "tf_lambda_app" {
  source = "git::git+ssh://git@git-aws.internal.justin.tv/dta/tf_lambda_app.git?ref=1.4.0"
  aws_region = "${var.aws_region}"
  aws_profile = "twitch-core-services"
  owner = "devtools@twitch.tv"
  repository = "dta/python-lambda-example"
  environment = "development"
  lambda_handler = "run.lambda_handler"
  lambda_function_name = "dta-python-lambda-example-development"
  lambda_timeout = "10"
  lambda_description = "A python lambda app"
  lambda_runtime = "python2.7"
  
  lambda_policy = "${file("../../files/lambda_policy.json")}"
  principal = "043714768218"
  lambda_vpc_subnet_ids = "subnet-bbce86cc,subnet-1fb69c7a,subnet-bf4221e6"
  lambda_vpc_security_group_ids = "sg-708bc514,sg-b0703ed4"
}
