"""Unit tests for code.justin.tv.dta.rockpaperscissors.environment module."""

from __future__ import absolute_import

import logging
import sys
import unittest

import mock

from . import environment
from . import errors
from .testutils import aws_lambda


logging.basicConfig(level=logging.INFO)


class GetEnvironmentTestCase(unittest.TestCase):

    def testBasic(self):
        for function_name in ('rockpaperscissors-development-foo',
                              'rockpaperscissors-development'):
            context = aws_lambda.Context(
              function_name=function_name)
            env = environment.GetEnvironment(context)
            self.assertEqual('rockpaperscissors-development', env.name)
            self.assertIsNotNone(env.IngestQueue())
            self.assertIsNotNone(env.LargeEventStore())
            self.assertIsNotNone(env.EventBus())
            self.assertIsNotNone(env.EventStore())
            self.assertIsNotNone(env.SandstormClient())

    def testNotAnEnvironment(self):
        context = aws_lambda.Context(
          function_name='rockpaperscissors-notanenvironment-foo')
        self.assertRaises(errors.EnvironmentError,
                          environment.GetEnvironment, context)

    def testBadFormat(self):
        context = aws_lambda.Context(
          function_name='doesntmatchformat')
        self.assertRaises(errors.EnvironmentError,
                          environment.GetEnvironment, context)


if __name__ == '__main__':
    unittest.main()
