"""Exceptions raised by rockpaperscissors modules."""


class Error(Exception):
    """RockPaperScissors Error"""


class EnvironmentError(Error):
    """Error trying to figure out the current environment."""


class IngestQueueError(Error):
    """RockPaperScissors Ingest Queue Error"""


class IngestQueueAddRequestsFailures(IngestQueueError):
    """Some requests failed to be added to the ingest queue."""


class IngestQueueRequestTooLarge(IngestQueueError):
    """Request is too large to send to ingest queue."""


class EventBusError(Error):
    """RockPaperScissors Event Bus Error"""


class EventBusRecordTooLarge(EventBusError):
    """Event is too large to put on the event bus."""


class EventDecodeError(Error):
    """Event couldn't be decoded from it's serialized form."""


class EventInvalid(Error):
    """Event's fields aren't set correctly."""


class EventStoreError(Error):
    """RockPaperScissors Event Store Error"""


class EventStoreItemTooLarge(EventStoreError):
    """Event is too large to put in the event store."""


class SandstormError(Error):
    """RockPaperScissors Sandstorm Error"""


class SandstormSecretNotFound(SandstormError):
    """Secret wasn't found in Sandstorm."""
