"""Get JIRA credentials from Sandstorm and configure JIRA client."""

from __future__ import absolute_import

from jira import JIRA


def GetJiraClient(sandstorm_client, secret_name_prefix, consumer_key_name,
                  access_token='jira-access-token',
                  access_token_secret='jira-access-token-secret',
                  jira_private_key='jira-private-key',
                  server='https://twitchtv.atlassian.net'):
    """Make configured JIRA client.

    Credentials are fetched from Sandstorm.

    Args:
      sandstorm_client:
      secret_name_prefix:
      consumer_key_name:
      access_token:
      access_token_secret:
      jira_private_key:
      server:

    Returns:

    """
    options = {
      'server': server,
    }
    access_token = sandstorm_client.GetSecret(
      secret_name_prefix + access_token)
    access_token_secret = sandstorm_client.GetSecret(
      secret_name_prefix + access_token_secret)
    key_cert = sandstorm_client.GetSecret(
      secret_name_prefix + jira_private_key)
    oauth_config = {
      'access_token': access_token,
      'access_token_secret': access_token_secret,
      'consumer_key': consumer_key_name,
      'key_cert': key_cert,
    }
    return JIRA(options, oauth=oauth_config)
