"""Unit tests for code.justin.tv.dta.rockpaperscissors.large_event_store."""

from __future__ import absolute_import

import base64
import logging
import unittest

import mock

from . import event_bus
from . import large_event_store


logging.basicConfig(level=logging.INFO)


class LargeEventStoreTestCase(unittest.TestCase):

    def testBasic(self):
        store = large_event_store.LargeEventStore(
            'bucket_name', 'large_events')
        event = event_bus.Event(
          uuid='abcdef',
          timestamp=0.0,
          event_type='type',
          body='body',
          attributes={'key': 'value'})

        with mock.patch.object(store, 's3', autospec=True):
            mock_bucket = store.s3.Bucket.return_value

            store.PutEvent(event)

            mock_bucket.put_object.assert_called_once_with(
                Key='large_events/' + base64.b64encode(event.uuid) + '.proto',
                Body=event.SerializeToString(),
                ContentType='application/x-protobuf')


if __name__ == '__main__':
    unittest.main()
