"""Unittests for event_store run module."""

import logging
import unittest

import mock

from code.justin.tv.dta.rockpaperscissors import environment
from code.justin.tv.dta.rockpaperscissors import event_bus
from code.justin.tv.dta.rockpaperscissors import event_store
from code.justin.tv.dta.rockpaperscissors.testutils import aws_lambda

import event_store as event_store_lambda


logging.basicConfig(level=logging.INFO)


@mock.patch.object(event_store, 'EventStore', autospec=True)
class TestCase(unittest.TestCase):

    def testBasic(self, mock_store):
        rps_event = event_bus.Event('TestEvent', 'body')
        payload = rps_event.SerializeToString()

        event_store_lambda.lambda_handler(
          aws_lambda.KinesisLambdaEvent([payload]),
          aws_lambda.Context('rockpaperscissors-development-lambda'))

        mock_store_obj = mock_store.return_value
        mock_store_obj.PutEvents.assert_called_once_with([rps_event])

    def testProtobufDecodeError(self, mock_store):
        payload = 'Not a protobuf'

        event_store_lambda.lambda_handler(
          aws_lambda.KinesisLambdaEvent([payload]),
          aws_lambda.Context('rockpaperscissors-development-lambda'))

        mock_store_obj = mock_store.return_value
        mock_store_obj.PutEvents.assert_not_called()


if __name__ == '__main__':
    unittest.main()
