"""Unittests for github_webhook_handler run module."""

import logging
import time
import unittest
import uuid

import mock

from code.justin.tv.dta.rockpaperscissors import event_bus
from code.justin.tv.dta.rockpaperscissors.testutils import aws_lambda

import github_webhook_handler


logging.basicConfig(level=logging.INFO)


PUSH_WEBHOOK_PAYLOAD = u"""{
  "ref": "refs/heads/master",
  "before": "f9f6497fd2396327faa51cd7f952688addc27bfb",
  "after": "a5e1d7d5461e3332e0b262a379adc37e55671bdc",
  "created": false,
  "deleted": false,
  "forced": false,
  "base_ref": null,
  "compare": "https://git-aws.internal.justin.tv/dta/rockpaperscissors/compare/f9f6497fd239...a5e1d7d5461e",
  "commits": [
    {
      "id": "a5e1d7d5461e3332e0b262a379adc37e55671bdc",
      "tree_id": "dc705056d01af8a476188cad288e8b306e32006d",
      "distinct": true,
      "message": "Add API Gateway and Lambda for handling GitHub webhooks",
      "timestamp": "2016-09-27T18:59:46-07:00",
      "url": "https://git-aws.internal.justin.tv/dta/rockpaperscissors/commit/a5e1d7d5461e3332e0b262a379adc37e55671bdc",
      "author": {
        "name": "T.R. Fullhart",
        "email": "fullht@twitch.tv",
        "username": "fullht"
      },
      "committer": {
        "name": "T.R. Fullhart",
        "email": "fullht@twitch.tv",
        "username": "fullht"
      },
      "added": [
        "terraform/modules/rockpaperscissors-github-handler/main.tf",
        "terraform/modules/rockpaperscissors-github-handler/variables.tf"
      ],
      "removed": [

      ],
      "modified": [
        "terraform/development/main.tf",
        "terraform/production/main.tf"
      ]
    }
  ],
  "head_commit": {
    "id": "a5e1d7d5461e3332e0b262a379adc37e55671bdc",
    "tree_id": "dc705056d01af8a476188cad288e8b306e32006d",
    "distinct": true,
    "message": "Add API Gateway and Lambda for handling GitHub webhooks",
    "timestamp": "2016-09-27T18:59:46-07:00",
    "url": "https://git-aws.internal.justin.tv/dta/rockpaperscissors/commit/a5e1d7d5461e3332e0b262a379adc37e55671bdc",
    "author": {
      "name": "T.R. Fullhart",
      "email": "fullht@twitch.tv",
      "username": "fullht"
    },
    "committer": {
      "name": "T.R. Fullhart",
      "email": "fullht@twitch.tv",
      "username": "fullht"
    },
    "added": [
      "terraform/modules/rockpaperscissors-github-handler/main.tf",
      "terraform/modules/rockpaperscissors-github-handler/variables.tf"
    ],
    "removed": [

    ],
    "modified": [
      "terraform/development/main.tf",
      "terraform/production/main.tf"
    ]
  },
  "repository": {
    "id": 3042,
    "name": "rockpaperscissors",
    "full_name": "dta/rockpaperscissors",
    "owner": {
      "name": "dta",
      "email": "devtools@twitch.tv"
    },
    "private": false,
    "html_url": "https://git-aws.internal.justin.tv/dta/rockpaperscissors",
    "description": "A project health metrics and dashboarding system",
    "fork": false,
    "url": "https://git-aws.internal.justin.tv/dta/rockpaperscissors",
    "forks_url": "https://git-aws.internal.justin.tv/api/v3/repos/dta/rockpaperscissors/forks",
    "keys_url": "https://git-aws.internal.justin.tv/api/v3/repos/dta/rockpaperscissors/keys{/key_id}",
    "collaborators_url": "https://git-aws.internal.justin.tv/api/v3/repos/dta/rockpaperscissors/collaborators{/collaborator}",
    "teams_url": "https://git-aws.internal.justin.tv/api/v3/repos/dta/rockpaperscissors/teams",
    "hooks_url": "https://git-aws.internal.justin.tv/api/v3/repos/dta/rockpaperscissors/hooks",
    "issue_events_url": "https://git-aws.internal.justin.tv/api/v3/repos/dta/rockpaperscissors/issues/events{/number}",
    "events_url": "https://git-aws.internal.justin.tv/api/v3/repos/dta/rockpaperscissors/events",
    "assignees_url": "https://git-aws.internal.justin.tv/api/v3/repos/dta/rockpaperscissors/assignees{/user}",
    "branches_url": "https://git-aws.internal.justin.tv/api/v3/repos/dta/rockpaperscissors/branches{/branch}",
    "tags_url": "https://git-aws.internal.justin.tv/api/v3/repos/dta/rockpaperscissors/tags",
    "blobs_url": "https://git-aws.internal.justin.tv/api/v3/repos/dta/rockpaperscissors/git/blobs{/sha}",
    "git_tags_url": "https://git-aws.internal.justin.tv/api/v3/repos/dta/rockpaperscissors/git/tags{/sha}",
    "git_refs_url": "https://git-aws.internal.justin.tv/api/v3/repos/dta/rockpaperscissors/git/refs{/sha}",
    "trees_url": "https://git-aws.internal.justin.tv/api/v3/repos/dta/rockpaperscissors/git/trees{/sha}",
    "statuses_url": "https://git-aws.internal.justin.tv/api/v3/repos/dta/rockpaperscissors/statuses/{sha}",
    "languages_url": "https://git-aws.internal.justin.tv/api/v3/repos/dta/rockpaperscissors/languages",
    "stargazers_url": "https://git-aws.internal.justin.tv/api/v3/repos/dta/rockpaperscissors/stargazers",
    "contributors_url": "https://git-aws.internal.justin.tv/api/v3/repos/dta/rockpaperscissors/contributors",
    "subscribers_url": "https://git-aws.internal.justin.tv/api/v3/repos/dta/rockpaperscissors/subscribers",
    "subscription_url": "https://git-aws.internal.justin.tv/api/v3/repos/dta/rockpaperscissors/subscription",
    "commits_url": "https://git-aws.internal.justin.tv/api/v3/repos/dta/rockpaperscissors/commits{/sha}",
    "git_commits_url": "https://git-aws.internal.justin.tv/api/v3/repos/dta/rockpaperscissors/git/commits{/sha}",
    "comments_url": "https://git-aws.internal.justin.tv/api/v3/repos/dta/rockpaperscissors/comments{/number}",
    "issue_comment_url": "https://git-aws.internal.justin.tv/api/v3/repos/dta/rockpaperscissors/issues/comments{/number}",
    "contents_url": "https://git-aws.internal.justin.tv/api/v3/repos/dta/rockpaperscissors/contents/{+path}",
    "compare_url": "https://git-aws.internal.justin.tv/api/v3/repos/dta/rockpaperscissors/compare/{base}...{head}",
    "merges_url": "https://git-aws.internal.justin.tv/api/v3/repos/dta/rockpaperscissors/merges",
    "archive_url": "https://git-aws.internal.justin.tv/api/v3/repos/dta/rockpaperscissors/{archive_format}{/ref}",
    "downloads_url": "https://git-aws.internal.justin.tv/api/v3/repos/dta/rockpaperscissors/downloads",
    "issues_url": "https://git-aws.internal.justin.tv/api/v3/repos/dta/rockpaperscissors/issues{/number}",
    "pulls_url": "https://git-aws.internal.justin.tv/api/v3/repos/dta/rockpaperscissors/pulls{/number}",
    "milestones_url": "https://git-aws.internal.justin.tv/api/v3/repos/dta/rockpaperscissors/milestones{/number}",
    "notifications_url": "https://git-aws.internal.justin.tv/api/v3/repos/dta/rockpaperscissors/notifications{?since,all,participating}",
    "labels_url": "https://git-aws.internal.justin.tv/api/v3/repos/dta/rockpaperscissors/labels{/name}",
    "releases_url": "https://git-aws.internal.justin.tv/api/v3/repos/dta/rockpaperscissors/releases{/id}",
    "deployments_url": "https://git-aws.internal.justin.tv/api/v3/repos/dta/rockpaperscissors/deployments",
    "created_at": 1470175342,
    "updated_at": "2016-09-01T00:38:27Z",
    "pushed_at": 1475027838,
    "git_url": "git://git-aws.internal.justin.tv/dta/rockpaperscissors.git",
    "ssh_url": "git@git-aws.internal.justin.tv:dta/rockpaperscissors.git",
    "clone_url": "https://git-aws.internal.justin.tv/dta/rockpaperscissors.git",
    "svn_url": "https://git-aws.internal.justin.tv/dta/rockpaperscissors",
    "homepage": "http://link.twitch.tv/rps",
    "size": 7344,
    "stargazers_count": 1,
    "watchers_count": 1,
    "language": "Go",
    "has_issues": false,
    "has_downloads": false,
    "has_wiki": false,
    "has_pages": false,
    "forks_count": 0,
    "mirror_url": null,
    "open_issues_count": 0,
    "forks": 0,
    "open_issues": 0,
    "watchers": 1,
    "default_branch": "master",
    "stargazers": 1,
    "master_branch": "master",
    "organization": "dta"
  },
  "pusher": {
    "name": "fullht",
    "email": "fullht@justin.tv"
  },
  "organization": {
    "login": "dta",
    "id": 181,
    "url": "https://git-aws.internal.justin.tv/api/v3/orgs/dta",
    "repos_url": "https://git-aws.internal.justin.tv/api/v3/orgs/dta/repos",
    "events_url": "https://git-aws.internal.justin.tv/api/v3/orgs/dta/events",
    "hooks_url": "https://git-aws.internal.justin.tv/api/v3/orgs/dta/hooks",
    "issues_url": "https://git-aws.internal.justin.tv/api/v3/orgs/dta/issues",
    "members_url": "https://git-aws.internal.justin.tv/api/v3/orgs/dta/members{/member}",
    "public_members_url": "https://git-aws.internal.justin.tv/api/v3/orgs/dta/public_members{/member}",
    "avatar_url": "https://git-aws.internal.justin.tv/avatars/u/181?",
    "description": "Dank Times Ahead"
  },
  "sender": {
    "login": "fullht",
    "id": 489,
    "avatar_url": "https://git-aws.internal.justin.tv/avatars/u/489?",
    "gravatar_id": "",
    "url": "https://git-aws.internal.justin.tv/api/v3/users/fullht",
    "html_url": "https://git-aws.internal.justin.tv/fullht",
    "followers_url": "https://git-aws.internal.justin.tv/api/v3/users/fullht/followers",
    "following_url": "https://git-aws.internal.justin.tv/api/v3/users/fullht/following{/other_user}",
    "gists_url": "https://git-aws.internal.justin.tv/api/v3/users/fullht/gists{/gist_id}",
    "starred_url": "https://git-aws.internal.justin.tv/api/v3/users/fullht/starred{/owner}{/repo}",
    "subscriptions_url": "https://git-aws.internal.justin.tv/api/v3/users/fullht/subscriptions",
    "organizations_url": "https://git-aws.internal.justin.tv/api/v3/users/fullht/orgs",
    "repos_url": "https://git-aws.internal.justin.tv/api/v3/users/fullht/repos",
    "events_url": "https://git-aws.internal.justin.tv/api/v3/users/fullht/events{/privacy}",
    "received_events_url": "https://git-aws.internal.justin.tv/api/v3/users/fullht/received_events",
    "type": "User",
    "site_admin": true,
    "ldap_dn": "cn=T.R. Fullhart,ou=Users,dc=justin,dc=tv"
  }
}
"""

DEPLOYMENT_STATUS_WEBHOOK_PAYLOAD = u"""{
  "deployment_status": {
    "url": "https://git-aws.internal.justin.tv/api/v3/repos/dta/rockpaperscissors/deployments/99341/statuses/215672",
    "id": 215672,
    "state": "success",
    "creator": {
      "login": "devtools",
      "id": 55,
      "avatar_url": "https://git-aws.internal.justin.tv/avatars/u/55?",
      "gravatar_id": "",
      "url": "https://git-aws.internal.justin.tv/api/v3/users/devtools",
      "html_url": "https://git-aws.internal.justin.tv/devtools",
      "followers_url": "https://git-aws.internal.justin.tv/api/v3/users/devtools/followers",
      "following_url": "https://git-aws.internal.justin.tv/api/v3/users/devtools/following{/other_user}",
      "gists_url": "https://git-aws.internal.justin.tv/api/v3/users/devtools/gists{/gist_id}",
      "starred_url": "https://git-aws.internal.justin.tv/api/v3/users/devtools/starred{/owner}{/repo}",
      "subscriptions_url": "https://git-aws.internal.justin.tv/api/v3/users/devtools/subscriptions",
      "organizations_url": "https://git-aws.internal.justin.tv/api/v3/users/devtools/orgs",
      "repos_url": "https://git-aws.internal.justin.tv/api/v3/users/devtools/repos",
      "events_url": "https://git-aws.internal.justin.tv/api/v3/users/devtools/events{/privacy}",
      "received_events_url": "https://git-aws.internal.justin.tv/api/v3/users/devtools/received_events",
      "type": "User",
      "site_admin": false,
      "ldap_dn": "cn=devtools,ou=Users,dc=justin,dc=tv"
    },
    "description": null,
    "target_url": "https://jenkins.internal.justin.tv/job/dta-rockpaperscissors-deploy/35/",
    "created_at": "2017-05-04T20:42:49Z",
    "updated_at": "2017-05-04T20:42:49Z",
    "deployment_url": "https://git-aws.internal.justin.tv/api/v3/repos/dta/rockpaperscissors/deployments/99341",
    "repository_url": "https://git-aws.internal.justin.tv/api/v3/repos/dta/rockpaperscissors"
  },
  "deployment": {
    "url": "https://git-aws.internal.justin.tv/api/v3/repos/dta/rockpaperscissors/deployments/99341",
    "id": 99341,
    "sha": "31307ba886d42ae2af6d16cb81e56d69b21d0722",
    "ref": "master",
    "task": "deploy",
    "payload": "{\\"previous_sha\\":\\"095c1f4eb97ec69f218838596aa01b53f22d50df\\"}",
    "environment": "development",
    "description": "Merge pull request #173 from dta/fullht-context_cleanup\\n\\nCleanup and update dependencies",
    "creator": {
      "login": "fullht",
      "id": 489,
      "avatar_url": "https://git-aws.internal.justin.tv/avatars/u/489?",
      "gravatar_id": "",
      "url": "https://git-aws.internal.justin.tv/api/v3/users/fullht",
      "html_url": "https://git-aws.internal.justin.tv/fullht",
      "followers_url": "https://git-aws.internal.justin.tv/api/v3/users/fullht/followers",
      "following_url": "https://git-aws.internal.justin.tv/api/v3/users/fullht/following{/other_user}",
      "gists_url": "https://git-aws.internal.justin.tv/api/v3/users/fullht/gists{/gist_id}",
      "starred_url": "https://git-aws.internal.justin.tv/api/v3/users/fullht/starred{/owner}{/repo}",
      "subscriptions_url": "https://git-aws.internal.justin.tv/api/v3/users/fullht/subscriptions",
      "organizations_url": "https://git-aws.internal.justin.tv/api/v3/users/fullht/orgs",
      "repos_url": "https://git-aws.internal.justin.tv/api/v3/users/fullht/repos",
      "events_url": "https://git-aws.internal.justin.tv/api/v3/users/fullht/events{/privacy}",
      "received_events_url": "https://git-aws.internal.justin.tv/api/v3/users/fullht/received_events",
      "type": "User",
      "site_admin": true,
      "ldap_dn": "cn=T.R. Fullhart,ou=Users,dc=justin,dc=tv"
    },
    "created_at": "2017-05-04T20:41:17Z",
    "updated_at": "2017-05-04T20:41:17Z",
    "statuses_url": "https://git-aws.internal.justin.tv/api/v3/repos/dta/rockpaperscissors/deployments/99341/statuses",
    "repository_url": "https://git-aws.internal.justin.tv/api/v3/repos/dta/rockpaperscissors"
  },
  "repository": {
    "id": 3042,
    "name": "rockpaperscissors",
    "full_name": "dta/rockpaperscissors",
    "owner": {
      "login": "dta",
      "id": 181,
      "avatar_url": "https://git-aws.internal.justin.tv/avatars/u/181?",
      "gravatar_id": "",
      "url": "https://git-aws.internal.justin.tv/api/v3/users/dta",
      "html_url": "https://git-aws.internal.justin.tv/dta",
      "followers_url": "https://git-aws.internal.justin.tv/api/v3/users/dta/followers",
      "following_url": "https://git-aws.internal.justin.tv/api/v3/users/dta/following{/other_user}",
      "gists_url": "https://git-aws.internal.justin.tv/api/v3/users/dta/gists{/gist_id}",
      "starred_url": "https://git-aws.internal.justin.tv/api/v3/users/dta/starred{/owner}{/repo}",
      "subscriptions_url": "https://git-aws.internal.justin.tv/api/v3/users/dta/subscriptions",
      "organizations_url": "https://git-aws.internal.justin.tv/api/v3/users/dta/orgs",
      "repos_url": "https://git-aws.internal.justin.tv/api/v3/users/dta/repos",
      "events_url": "https://git-aws.internal.justin.tv/api/v3/users/dta/events{/privacy}",
      "received_events_url": "https://git-aws.internal.justin.tv/api/v3/users/dta/received_events",
      "type": "Organization",
      "site_admin": false
    },
    "private": false,
    "html_url": "https://git-aws.internal.justin.tv/dta/rockpaperscissors",
    "description": "A project health metrics and dashboarding system",
    "fork": false,
    "url": "https://git-aws.internal.justin.tv/api/v3/repos/dta/rockpaperscissors",
    "forks_url": "https://git-aws.internal.justin.tv/api/v3/repos/dta/rockpaperscissors/forks",
    "keys_url": "https://git-aws.internal.justin.tv/api/v3/repos/dta/rockpaperscissors/keys{/key_id}",
    "collaborators_url": "https://git-aws.internal.justin.tv/api/v3/repos/dta/rockpaperscissors/collaborators{/collaborator}",
    "teams_url": "https://git-aws.internal.justin.tv/api/v3/repos/dta/rockpaperscissors/teams",
    "hooks_url": "https://git-aws.internal.justin.tv/api/v3/repos/dta/rockpaperscissors/hooks",
    "issue_events_url": "https://git-aws.internal.justin.tv/api/v3/repos/dta/rockpaperscissors/issues/events{/number}",
    "events_url": "https://git-aws.internal.justin.tv/api/v3/repos/dta/rockpaperscissors/events",
    "assignees_url": "https://git-aws.internal.justin.tv/api/v3/repos/dta/rockpaperscissors/assignees{/user}",
    "branches_url": "https://git-aws.internal.justin.tv/api/v3/repos/dta/rockpaperscissors/branches{/branch}",
    "tags_url": "https://git-aws.internal.justin.tv/api/v3/repos/dta/rockpaperscissors/tags",
    "blobs_url": "https://git-aws.internal.justin.tv/api/v3/repos/dta/rockpaperscissors/git/blobs{/sha}",
    "git_tags_url": "https://git-aws.internal.justin.tv/api/v3/repos/dta/rockpaperscissors/git/tags{/sha}",
    "git_refs_url": "https://git-aws.internal.justin.tv/api/v3/repos/dta/rockpaperscissors/git/refs{/sha}",
    "trees_url": "https://git-aws.internal.justin.tv/api/v3/repos/dta/rockpaperscissors/git/trees{/sha}",
    "statuses_url": "https://git-aws.internal.justin.tv/api/v3/repos/dta/rockpaperscissors/statuses/{sha}",
    "languages_url": "https://git-aws.internal.justin.tv/api/v3/repos/dta/rockpaperscissors/languages",
    "stargazers_url": "https://git-aws.internal.justin.tv/api/v3/repos/dta/rockpaperscissors/stargazers",
    "contributors_url": "https://git-aws.internal.justin.tv/api/v3/repos/dta/rockpaperscissors/contributors",
    "subscribers_url": "https://git-aws.internal.justin.tv/api/v3/repos/dta/rockpaperscissors/subscribers",
    "subscription_url": "https://git-aws.internal.justin.tv/api/v3/repos/dta/rockpaperscissors/subscription",
    "commits_url": "https://git-aws.internal.justin.tv/api/v3/repos/dta/rockpaperscissors/commits{/sha}",
    "git_commits_url": "https://git-aws.internal.justin.tv/api/v3/repos/dta/rockpaperscissors/git/commits{/sha}",
    "comments_url": "https://git-aws.internal.justin.tv/api/v3/repos/dta/rockpaperscissors/comments{/number}",
    "issue_comment_url": "https://git-aws.internal.justin.tv/api/v3/repos/dta/rockpaperscissors/issues/comments{/number}",
    "contents_url": "https://git-aws.internal.justin.tv/api/v3/repos/dta/rockpaperscissors/contents/{+path}",
    "compare_url": "https://git-aws.internal.justin.tv/api/v3/repos/dta/rockpaperscissors/compare/{base}...{head}",
    "merges_url": "https://git-aws.internal.justin.tv/api/v3/repos/dta/rockpaperscissors/merges",
    "archive_url": "https://git-aws.internal.justin.tv/api/v3/repos/dta/rockpaperscissors/{archive_format}{/ref}",
    "downloads_url": "https://git-aws.internal.justin.tv/api/v3/repos/dta/rockpaperscissors/downloads",
    "issues_url": "https://git-aws.internal.justin.tv/api/v3/repos/dta/rockpaperscissors/issues{/number}",
    "pulls_url": "https://git-aws.internal.justin.tv/api/v3/repos/dta/rockpaperscissors/pulls{/number}",
    "milestones_url": "https://git-aws.internal.justin.tv/api/v3/repos/dta/rockpaperscissors/milestones{/number}",
    "notifications_url": "https://git-aws.internal.justin.tv/api/v3/repos/dta/rockpaperscissors/notifications{?since,all,participating}",
    "labels_url": "https://git-aws.internal.justin.tv/api/v3/repos/dta/rockpaperscissors/labels{/name}",
    "releases_url": "https://git-aws.internal.justin.tv/api/v3/repos/dta/rockpaperscissors/releases{/id}",
    "deployments_url": "https://git-aws.internal.justin.tv/api/v3/repos/dta/rockpaperscissors/deployments",
    "created_at": "2016-08-02T22:02:22Z",
    "updated_at": "2016-10-27T22:12:28Z",
    "pushed_at": "2017-05-03T20:50:31Z",
    "git_url": "git://git-aws.internal.justin.tv/dta/rockpaperscissors.git",
    "ssh_url": "git@git-aws.internal.justin.tv:dta/rockpaperscissors.git",
    "clone_url": "https://git-aws.internal.justin.tv/dta/rockpaperscissors.git",
    "svn_url": "https://git-aws.internal.justin.tv/dta/rockpaperscissors",
    "homepage": "http://link.twitch.tv/rps",
    "size": 22666,
    "stargazers_count": 2,
    "watchers_count": 2,
    "language": "JavaScript",
    "has_issues": false,
    "has_downloads": false,
    "has_wiki": false,
    "has_pages": false,
    "forks_count": 0,
    "mirror_url": null,
    "open_issues_count": 0,
    "forks": 0,
    "open_issues": 0,
    "watchers": 2,
    "default_branch": "master"
  },
  "organization": {
    "login": "dta",
    "id": 181,
    "url": "https://git-aws.internal.justin.tv/api/v3/orgs/dta",
    "repos_url": "https://git-aws.internal.justin.tv/api/v3/orgs/dta/repos",
    "events_url": "https://git-aws.internal.justin.tv/api/v3/orgs/dta/events",
    "hooks_url": "https://git-aws.internal.justin.tv/api/v3/orgs/dta/hooks",
    "issues_url": "https://git-aws.internal.justin.tv/api/v3/orgs/dta/issues",
    "members_url": "https://git-aws.internal.justin.tv/api/v3/orgs/dta/members{/member}",
    "public_members_url": "https://git-aws.internal.justin.tv/api/v3/orgs/dta/public_members{/member}",
    "avatar_url": "https://git-aws.internal.justin.tv/avatars/u/181?",
    "description": "Dank Times Ahead"
  },
  "sender": {
    "login": "devtools",
    "id": 55,
    "avatar_url": "https://git-aws.internal.justin.tv/avatars/u/55?",
    "gravatar_id": "",
    "url": "https://git-aws.internal.justin.tv/api/v3/users/devtools",
    "html_url": "https://git-aws.internal.justin.tv/devtools",
    "followers_url": "https://git-aws.internal.justin.tv/api/v3/users/devtools/followers",
    "following_url": "https://git-aws.internal.justin.tv/api/v3/users/devtools/following{/other_user}",
    "gists_url": "https://git-aws.internal.justin.tv/api/v3/users/devtools/gists{/gist_id}",
    "starred_url": "https://git-aws.internal.justin.tv/api/v3/users/devtools/starred{/owner}{/repo}",
    "subscriptions_url": "https://git-aws.internal.justin.tv/api/v3/users/devtools/subscriptions",
    "organizations_url": "https://git-aws.internal.justin.tv/api/v3/users/devtools/orgs",
    "repos_url": "https://git-aws.internal.justin.tv/api/v3/users/devtools/repos",
    "events_url": "https://git-aws.internal.justin.tv/api/v3/users/devtools/events{/privacy}",
    "received_events_url": "https://git-aws.internal.justin.tv/api/v3/users/devtools/received_events",
    "type": "User",
    "site_admin": false,
    "ldap_dn": "cn=devtools,ou=Users,dc=justin,dc=tv"
  }
}
"""

PULL_REQUEST_WEBHOOK_PAYLOAD = u"""{
  "action": "closed",
  "number": 174,
  "pull_request": {
    "url": "https://git-aws.internal.justin.tv/api/v3/repos/dta/rockpaperscissors/pulls/174",
    "id": 56497,
    "html_url": "https://git-aws.internal.justin.tv/dta/rockpaperscissors/pull/174",
    "diff_url": "https://git-aws.internal.justin.tv/dta/rockpaperscissors/pull/174.diff",
    "patch_url": "https://git-aws.internal.justin.tv/dta/rockpaperscissors/pull/174.patch",
    "issue_url": "https://git-aws.internal.justin.tv/api/v3/repos/dta/rockpaperscissors/issues/174",
    "number": 174,
    "state": "closed",
    "locked": false,
    "title": "Tag attributes of GitHub Webhooks",
    "user": {
      "login": "fullht",
      "id": 489,
      "avatar_url": "https://git-aws.internal.justin.tv/avatars/u/489?",
      "gravatar_id": "",
      "url": "https://git-aws.internal.justin.tv/api/v3/users/fullht",
      "html_url": "https://git-aws.internal.justin.tv/fullht",
      "followers_url": "https://git-aws.internal.justin.tv/api/v3/users/fullht/followers",
      "following_url": "https://git-aws.internal.justin.tv/api/v3/users/fullht/following{/other_user}",
      "gists_url": "https://git-aws.internal.justin.tv/api/v3/users/fullht/gists{/gist_id}",
      "starred_url": "https://git-aws.internal.justin.tv/api/v3/users/fullht/starred{/owner}{/repo}",
      "subscriptions_url": "https://git-aws.internal.justin.tv/api/v3/users/fullht/subscriptions",
      "organizations_url": "https://git-aws.internal.justin.tv/api/v3/users/fullht/orgs",
      "repos_url": "https://git-aws.internal.justin.tv/api/v3/users/fullht/repos",
      "events_url": "https://git-aws.internal.justin.tv/api/v3/users/fullht/events{/privacy}",
      "received_events_url": "https://git-aws.internal.justin.tv/api/v3/users/fullht/received_events",
      "type": "User",
      "site_admin": true,
      "ldap_dn": "cn=T.R. Fullhart,ou=Users,dc=justin,dc=tv"
    },
    "body": "This will add attributes to GitHub-pull_request and GitHub-deployment_status events to make them easier to query for.",
    "created_at": "2017-05-04T21:05:27Z",
    "updated_at": "2017-05-04T21:06:50Z",
    "closed_at": "2017-05-04T21:06:50Z",
    "merged_at": null,
    "merge_commit_sha": "0b3de00d08cd5af77c7a8c7e126d404bdd246c81",
    "assignee": null,
    "assignees": [],
    "milestone": null,
    "commits_url": "https://git-aws.internal.justin.tv/api/v3/repos/dta/rockpaperscissors/pulls/174/commits",
    "review_comments_url": "https://git-aws.internal.justin.tv/api/v3/repos/dta/rockpaperscissors/pulls/174/comments",
    "review_comment_url": "https://git-aws.internal.justin.tv/api/v3/repos/dta/rockpaperscissors/pulls/comments{/number}",
    "comments_url": "https://git-aws.internal.justin.tv/api/v3/repos/dta/rockpaperscissors/issues/174/comments",
    "statuses_url": "https://git-aws.internal.justin.tv/api/v3/repos/dta/rockpaperscissors/statuses/9be1d49f4e0ffd79042f80931f25213a934d05ce",
    "head": {
      "label": "dta:fullht-github_webhooks",
      "ref": "fullht-github_webhooks",
      "sha": "9be1d49f4e0ffd79042f80931f25213a934d05ce",
      "user": {
        "login": "dta",
        "id": 181,
        "avatar_url": "https://git-aws.internal.justin.tv/avatars/u/181?",
        "gravatar_id": "",
        "url": "https://git-aws.internal.justin.tv/api/v3/users/dta",
        "html_url": "https://git-aws.internal.justin.tv/dta",
        "followers_url": "https://git-aws.internal.justin.tv/api/v3/users/dta/followers",
        "following_url": "https://git-aws.internal.justin.tv/api/v3/users/dta/following{/other_user}",
        "gists_url": "https://git-aws.internal.justin.tv/api/v3/users/dta/gists{/gist_id}",
        "starred_url": "https://git-aws.internal.justin.tv/api/v3/users/dta/starred{/owner}{/repo}",
        "subscriptions_url": "https://git-aws.internal.justin.tv/api/v3/users/dta/subscriptions",
        "organizations_url": "https://git-aws.internal.justin.tv/api/v3/users/dta/orgs",
        "repos_url": "https://git-aws.internal.justin.tv/api/v3/users/dta/repos",
        "events_url": "https://git-aws.internal.justin.tv/api/v3/users/dta/events{/privacy}",
        "received_events_url": "https://git-aws.internal.justin.tv/api/v3/users/dta/received_events",
        "type": "Organization",
        "site_admin": false
      },
      "repo": {
        "id": 3042,
        "name": "rockpaperscissors",
        "full_name": "dta/rockpaperscissors",
        "owner": {
          "login": "dta",
          "id": 181,
          "avatar_url": "https://git-aws.internal.justin.tv/avatars/u/181?",
          "gravatar_id": "",
          "url": "https://git-aws.internal.justin.tv/api/v3/users/dta",
          "html_url": "https://git-aws.internal.justin.tv/dta",
          "followers_url": "https://git-aws.internal.justin.tv/api/v3/users/dta/followers",
          "following_url": "https://git-aws.internal.justin.tv/api/v3/users/dta/following{/other_user}",
          "gists_url": "https://git-aws.internal.justin.tv/api/v3/users/dta/gists{/gist_id}",
          "starred_url": "https://git-aws.internal.justin.tv/api/v3/users/dta/starred{/owner}{/repo}",
          "subscriptions_url": "https://git-aws.internal.justin.tv/api/v3/users/dta/subscriptions",
          "organizations_url": "https://git-aws.internal.justin.tv/api/v3/users/dta/orgs",
          "repos_url": "https://git-aws.internal.justin.tv/api/v3/users/dta/repos",
          "events_url": "https://git-aws.internal.justin.tv/api/v3/users/dta/events{/privacy}",
          "received_events_url": "https://git-aws.internal.justin.tv/api/v3/users/dta/received_events",
          "type": "Organization",
          "site_admin": false
        },
        "private": false,
        "html_url": "https://git-aws.internal.justin.tv/dta/rockpaperscissors",
        "description": "A project health metrics and dashboarding system",
        "fork": false,
        "url": "https://git-aws.internal.justin.tv/api/v3/repos/dta/rockpaperscissors",
        "forks_url": "https://git-aws.internal.justin.tv/api/v3/repos/dta/rockpaperscissors/forks",
        "keys_url": "https://git-aws.internal.justin.tv/api/v3/repos/dta/rockpaperscissors/keys{/key_id}",
        "collaborators_url": "https://git-aws.internal.justin.tv/api/v3/repos/dta/rockpaperscissors/collaborators{/collaborator}",
        "teams_url": "https://git-aws.internal.justin.tv/api/v3/repos/dta/rockpaperscissors/teams",
        "hooks_url": "https://git-aws.internal.justin.tv/api/v3/repos/dta/rockpaperscissors/hooks",
        "issue_events_url": "https://git-aws.internal.justin.tv/api/v3/repos/dta/rockpaperscissors/issues/events{/number}",
        "events_url": "https://git-aws.internal.justin.tv/api/v3/repos/dta/rockpaperscissors/events",
        "assignees_url": "https://git-aws.internal.justin.tv/api/v3/repos/dta/rockpaperscissors/assignees{/user}",
        "branches_url": "https://git-aws.internal.justin.tv/api/v3/repos/dta/rockpaperscissors/branches{/branch}",
        "tags_url": "https://git-aws.internal.justin.tv/api/v3/repos/dta/rockpaperscissors/tags",
        "blobs_url": "https://git-aws.internal.justin.tv/api/v3/repos/dta/rockpaperscissors/git/blobs{/sha}",
        "git_tags_url": "https://git-aws.internal.justin.tv/api/v3/repos/dta/rockpaperscissors/git/tags{/sha}",
        "git_refs_url": "https://git-aws.internal.justin.tv/api/v3/repos/dta/rockpaperscissors/git/refs{/sha}",
        "trees_url": "https://git-aws.internal.justin.tv/api/v3/repos/dta/rockpaperscissors/git/trees{/sha}",
        "statuses_url": "https://git-aws.internal.justin.tv/api/v3/repos/dta/rockpaperscissors/statuses/{sha}",
        "languages_url": "https://git-aws.internal.justin.tv/api/v3/repos/dta/rockpaperscissors/languages",
        "stargazers_url": "https://git-aws.internal.justin.tv/api/v3/repos/dta/rockpaperscissors/stargazers",
        "contributors_url": "https://git-aws.internal.justin.tv/api/v3/repos/dta/rockpaperscissors/contributors",
        "subscribers_url": "https://git-aws.internal.justin.tv/api/v3/repos/dta/rockpaperscissors/subscribers",
        "subscription_url": "https://git-aws.internal.justin.tv/api/v3/repos/dta/rockpaperscissors/subscription",
        "commits_url": "https://git-aws.internal.justin.tv/api/v3/repos/dta/rockpaperscissors/commits{/sha}",
        "git_commits_url": "https://git-aws.internal.justin.tv/api/v3/repos/dta/rockpaperscissors/git/commits{/sha}",
        "comments_url": "https://git-aws.internal.justin.tv/api/v3/repos/dta/rockpaperscissors/comments{/number}",
        "issue_comment_url": "https://git-aws.internal.justin.tv/api/v3/repos/dta/rockpaperscissors/issues/comments{/number}",
        "contents_url": "https://git-aws.internal.justin.tv/api/v3/repos/dta/rockpaperscissors/contents/{+path}",
        "compare_url": "https://git-aws.internal.justin.tv/api/v3/repos/dta/rockpaperscissors/compare/{base}...{head}",
        "merges_url": "https://git-aws.internal.justin.tv/api/v3/repos/dta/rockpaperscissors/merges",
        "archive_url": "https://git-aws.internal.justin.tv/api/v3/repos/dta/rockpaperscissors/{archive_format}{/ref}",
        "downloads_url": "https://git-aws.internal.justin.tv/api/v3/repos/dta/rockpaperscissors/downloads",
        "issues_url": "https://git-aws.internal.justin.tv/api/v3/repos/dta/rockpaperscissors/issues{/number}",
        "pulls_url": "https://git-aws.internal.justin.tv/api/v3/repos/dta/rockpaperscissors/pulls{/number}",
        "milestones_url": "https://git-aws.internal.justin.tv/api/v3/repos/dta/rockpaperscissors/milestones{/number}",
        "notifications_url": "https://git-aws.internal.justin.tv/api/v3/repos/dta/rockpaperscissors/notifications{?since,all,participating}",
        "labels_url": "https://git-aws.internal.justin.tv/api/v3/repos/dta/rockpaperscissors/labels{/name}",
        "releases_url": "https://git-aws.internal.justin.tv/api/v3/repos/dta/rockpaperscissors/releases{/id}",
        "deployments_url": "https://git-aws.internal.justin.tv/api/v3/repos/dta/rockpaperscissors/deployments",
        "created_at": "2016-08-02T22:02:22Z",
        "updated_at": "2016-10-27T22:12:28Z",
        "pushed_at": "2017-05-04T21:05:28Z",
        "git_url": "git://git-aws.internal.justin.tv/dta/rockpaperscissors.git",
        "ssh_url": "git@git-aws.internal.justin.tv:dta/rockpaperscissors.git",
        "clone_url": "https://git-aws.internal.justin.tv/dta/rockpaperscissors.git",
        "svn_url": "https://git-aws.internal.justin.tv/dta/rockpaperscissors",
        "homepage": "http://link.twitch.tv/rps",
        "size": 22666,
        "stargazers_count": 2,
        "watchers_count": 2,
        "language": "JavaScript",
        "has_issues": false,
        "has_downloads": false,
        "has_wiki": false,
        "has_pages": false,
        "forks_count": 0,
        "mirror_url": null,
        "open_issues_count": 0,
        "forks": 0,
        "open_issues": 0,
        "watchers": 2,
        "default_branch": "master"
      }
    },
    "base": {
      "label": "dta:master",
      "ref": "master",
      "sha": "31307ba886d42ae2af6d16cb81e56d69b21d0722",
      "user": {
        "login": "dta",
        "id": 181,
        "avatar_url": "https://git-aws.internal.justin.tv/avatars/u/181?",
        "gravatar_id": "",
        "url": "https://git-aws.internal.justin.tv/api/v3/users/dta",
        "html_url": "https://git-aws.internal.justin.tv/dta",
        "followers_url": "https://git-aws.internal.justin.tv/api/v3/users/dta/followers",
        "following_url": "https://git-aws.internal.justin.tv/api/v3/users/dta/following{/other_user}",
        "gists_url": "https://git-aws.internal.justin.tv/api/v3/users/dta/gists{/gist_id}",
        "starred_url": "https://git-aws.internal.justin.tv/api/v3/users/dta/starred{/owner}{/repo}",
        "subscriptions_url": "https://git-aws.internal.justin.tv/api/v3/users/dta/subscriptions",
        "organizations_url": "https://git-aws.internal.justin.tv/api/v3/users/dta/orgs",
        "repos_url": "https://git-aws.internal.justin.tv/api/v3/users/dta/repos",
        "events_url": "https://git-aws.internal.justin.tv/api/v3/users/dta/events{/privacy}",
        "received_events_url": "https://git-aws.internal.justin.tv/api/v3/users/dta/received_events",
        "type": "Organization",
        "site_admin": false
      },
      "repo": {
        "id": 3042,
        "name": "rockpaperscissors",
        "full_name": "dta/rockpaperscissors",
        "owner": {
          "login": "dta",
          "id": 181,
          "avatar_url": "https://git-aws.internal.justin.tv/avatars/u/181?",
          "gravatar_id": "",
          "url": "https://git-aws.internal.justin.tv/api/v3/users/dta",
          "html_url": "https://git-aws.internal.justin.tv/dta",
          "followers_url": "https://git-aws.internal.justin.tv/api/v3/users/dta/followers",
          "following_url": "https://git-aws.internal.justin.tv/api/v3/users/dta/following{/other_user}",
          "gists_url": "https://git-aws.internal.justin.tv/api/v3/users/dta/gists{/gist_id}",
          "starred_url": "https://git-aws.internal.justin.tv/api/v3/users/dta/starred{/owner}{/repo}",
          "subscriptions_url": "https://git-aws.internal.justin.tv/api/v3/users/dta/subscriptions",
          "organizations_url": "https://git-aws.internal.justin.tv/api/v3/users/dta/orgs",
          "repos_url": "https://git-aws.internal.justin.tv/api/v3/users/dta/repos",
          "events_url": "https://git-aws.internal.justin.tv/api/v3/users/dta/events{/privacy}",
          "received_events_url": "https://git-aws.internal.justin.tv/api/v3/users/dta/received_events",
          "type": "Organization",
          "site_admin": false
        },
        "private": false,
        "html_url": "https://git-aws.internal.justin.tv/dta/rockpaperscissors",
        "description": "A project health metrics and dashboarding system",
        "fork": false,
        "url": "https://git-aws.internal.justin.tv/api/v3/repos/dta/rockpaperscissors",
        "forks_url": "https://git-aws.internal.justin.tv/api/v3/repos/dta/rockpaperscissors/forks",
        "keys_url": "https://git-aws.internal.justin.tv/api/v3/repos/dta/rockpaperscissors/keys{/key_id}",
        "collaborators_url": "https://git-aws.internal.justin.tv/api/v3/repos/dta/rockpaperscissors/collaborators{/collaborator}",
        "teams_url": "https://git-aws.internal.justin.tv/api/v3/repos/dta/rockpaperscissors/teams",
        "hooks_url": "https://git-aws.internal.justin.tv/api/v3/repos/dta/rockpaperscissors/hooks",
        "issue_events_url": "https://git-aws.internal.justin.tv/api/v3/repos/dta/rockpaperscissors/issues/events{/number}",
        "events_url": "https://git-aws.internal.justin.tv/api/v3/repos/dta/rockpaperscissors/events",
        "assignees_url": "https://git-aws.internal.justin.tv/api/v3/repos/dta/rockpaperscissors/assignees{/user}",
        "branches_url": "https://git-aws.internal.justin.tv/api/v3/repos/dta/rockpaperscissors/branches{/branch}",
        "tags_url": "https://git-aws.internal.justin.tv/api/v3/repos/dta/rockpaperscissors/tags",
        "blobs_url": "https://git-aws.internal.justin.tv/api/v3/repos/dta/rockpaperscissors/git/blobs{/sha}",
        "git_tags_url": "https://git-aws.internal.justin.tv/api/v3/repos/dta/rockpaperscissors/git/tags{/sha}",
        "git_refs_url": "https://git-aws.internal.justin.tv/api/v3/repos/dta/rockpaperscissors/git/refs{/sha}",
        "trees_url": "https://git-aws.internal.justin.tv/api/v3/repos/dta/rockpaperscissors/git/trees{/sha}",
        "statuses_url": "https://git-aws.internal.justin.tv/api/v3/repos/dta/rockpaperscissors/statuses/{sha}",
        "languages_url": "https://git-aws.internal.justin.tv/api/v3/repos/dta/rockpaperscissors/languages",
        "stargazers_url": "https://git-aws.internal.justin.tv/api/v3/repos/dta/rockpaperscissors/stargazers",
        "contributors_url": "https://git-aws.internal.justin.tv/api/v3/repos/dta/rockpaperscissors/contributors",
        "subscribers_url": "https://git-aws.internal.justin.tv/api/v3/repos/dta/rockpaperscissors/subscribers",
        "subscription_url": "https://git-aws.internal.justin.tv/api/v3/repos/dta/rockpaperscissors/subscription",
        "commits_url": "https://git-aws.internal.justin.tv/api/v3/repos/dta/rockpaperscissors/commits{/sha}",
        "git_commits_url": "https://git-aws.internal.justin.tv/api/v3/repos/dta/rockpaperscissors/git/commits{/sha}",
        "comments_url": "https://git-aws.internal.justin.tv/api/v3/repos/dta/rockpaperscissors/comments{/number}",
        "issue_comment_url": "https://git-aws.internal.justin.tv/api/v3/repos/dta/rockpaperscissors/issues/comments{/number}",
        "contents_url": "https://git-aws.internal.justin.tv/api/v3/repos/dta/rockpaperscissors/contents/{+path}",
        "compare_url": "https://git-aws.internal.justin.tv/api/v3/repos/dta/rockpaperscissors/compare/{base}...{head}",
        "merges_url": "https://git-aws.internal.justin.tv/api/v3/repos/dta/rockpaperscissors/merges",
        "archive_url": "https://git-aws.internal.justin.tv/api/v3/repos/dta/rockpaperscissors/{archive_format}{/ref}",
        "downloads_url": "https://git-aws.internal.justin.tv/api/v3/repos/dta/rockpaperscissors/downloads",
        "issues_url": "https://git-aws.internal.justin.tv/api/v3/repos/dta/rockpaperscissors/issues{/number}",
        "pulls_url": "https://git-aws.internal.justin.tv/api/v3/repos/dta/rockpaperscissors/pulls{/number}",
        "milestones_url": "https://git-aws.internal.justin.tv/api/v3/repos/dta/rockpaperscissors/milestones{/number}",
        "notifications_url": "https://git-aws.internal.justin.tv/api/v3/repos/dta/rockpaperscissors/notifications{?since,all,participating}",
        "labels_url": "https://git-aws.internal.justin.tv/api/v3/repos/dta/rockpaperscissors/labels{/name}",
        "releases_url": "https://git-aws.internal.justin.tv/api/v3/repos/dta/rockpaperscissors/releases{/id}",
        "deployments_url": "https://git-aws.internal.justin.tv/api/v3/repos/dta/rockpaperscissors/deployments",
        "created_at": "2016-08-02T22:02:22Z",
        "updated_at": "2016-10-27T22:12:28Z",
        "pushed_at": "2017-05-04T21:05:28Z",
        "git_url": "git://git-aws.internal.justin.tv/dta/rockpaperscissors.git",
        "ssh_url": "git@git-aws.internal.justin.tv:dta/rockpaperscissors.git",
        "clone_url": "https://git-aws.internal.justin.tv/dta/rockpaperscissors.git",
        "svn_url": "https://git-aws.internal.justin.tv/dta/rockpaperscissors",
        "homepage": "http://link.twitch.tv/rps",
        "size": 22666,
        "stargazers_count": 2,
        "watchers_count": 2,
        "language": "JavaScript",
        "has_issues": false,
        "has_downloads": false,
        "has_wiki": false,
        "has_pages": false,
        "forks_count": 0,
        "mirror_url": null,
        "open_issues_count": 0,
        "forks": 0,
        "open_issues": 0,
        "watchers": 2,
        "default_branch": "master"
      }
    },
    "_links": {
      "self": {
        "href": "https://git-aws.internal.justin.tv/api/v3/repos/dta/rockpaperscissors/pulls/174"
      },
      "html": {
        "href": "https://git-aws.internal.justin.tv/dta/rockpaperscissors/pull/174"
      },
      "issue": {
        "href": "https://git-aws.internal.justin.tv/api/v3/repos/dta/rockpaperscissors/issues/174"
      },
      "comments": {
        "href": "https://git-aws.internal.justin.tv/api/v3/repos/dta/rockpaperscissors/issues/174/comments"
      },
      "review_comments": {
        "href": "https://git-aws.internal.justin.tv/api/v3/repos/dta/rockpaperscissors/pulls/174/comments"
      },
      "review_comment": {
        "href": "https://git-aws.internal.justin.tv/api/v3/repos/dta/rockpaperscissors/pulls/comments{/number}"
      },
      "commits": {
        "href": "https://git-aws.internal.justin.tv/api/v3/repos/dta/rockpaperscissors/pulls/174/commits"
      },
      "statuses": {
        "href": "https://git-aws.internal.justin.tv/api/v3/repos/dta/rockpaperscissors/statuses/9be1d49f4e0ffd79042f80931f25213a934d05ce"
      }
    },
    "merged": false,
    "mergeable": true,
    "mergeable_state": "unstable",
    "merged_by": null,
    "comments": 0,
    "review_comments": 0,
    "commits": 1,
    "additions": 18,
    "deletions": 3,
    "changed_files": 2
  },
  "repository": {
    "id": 3042,
    "name": "rockpaperscissors",
    "full_name": "dta/rockpaperscissors",
    "owner": {
      "login": "dta",
      "id": 181,
      "avatar_url": "https://git-aws.internal.justin.tv/avatars/u/181?",
      "gravatar_id": "",
      "url": "https://git-aws.internal.justin.tv/api/v3/users/dta",
      "html_url": "https://git-aws.internal.justin.tv/dta",
      "followers_url": "https://git-aws.internal.justin.tv/api/v3/users/dta/followers",
      "following_url": "https://git-aws.internal.justin.tv/api/v3/users/dta/following{/other_user}",
      "gists_url": "https://git-aws.internal.justin.tv/api/v3/users/dta/gists{/gist_id}",
      "starred_url": "https://git-aws.internal.justin.tv/api/v3/users/dta/starred{/owner}{/repo}",
      "subscriptions_url": "https://git-aws.internal.justin.tv/api/v3/users/dta/subscriptions",
      "organizations_url": "https://git-aws.internal.justin.tv/api/v3/users/dta/orgs",
      "repos_url": "https://git-aws.internal.justin.tv/api/v3/users/dta/repos",
      "events_url": "https://git-aws.internal.justin.tv/api/v3/users/dta/events{/privacy}",
      "received_events_url": "https://git-aws.internal.justin.tv/api/v3/users/dta/received_events",
      "type": "Organization",
      "site_admin": false
    },
    "private": false,
    "html_url": "https://git-aws.internal.justin.tv/dta/rockpaperscissors",
    "description": "A project health metrics and dashboarding system",
    "fork": false,
    "url": "https://git-aws.internal.justin.tv/api/v3/repos/dta/rockpaperscissors",
    "forks_url": "https://git-aws.internal.justin.tv/api/v3/repos/dta/rockpaperscissors/forks",
    "keys_url": "https://git-aws.internal.justin.tv/api/v3/repos/dta/rockpaperscissors/keys{/key_id}",
    "collaborators_url": "https://git-aws.internal.justin.tv/api/v3/repos/dta/rockpaperscissors/collaborators{/collaborator}",
    "teams_url": "https://git-aws.internal.justin.tv/api/v3/repos/dta/rockpaperscissors/teams",
    "hooks_url": "https://git-aws.internal.justin.tv/api/v3/repos/dta/rockpaperscissors/hooks",
    "issue_events_url": "https://git-aws.internal.justin.tv/api/v3/repos/dta/rockpaperscissors/issues/events{/number}",
    "events_url": "https://git-aws.internal.justin.tv/api/v3/repos/dta/rockpaperscissors/events",
    "assignees_url": "https://git-aws.internal.justin.tv/api/v3/repos/dta/rockpaperscissors/assignees{/user}",
    "branches_url": "https://git-aws.internal.justin.tv/api/v3/repos/dta/rockpaperscissors/branches{/branch}",
    "tags_url": "https://git-aws.internal.justin.tv/api/v3/repos/dta/rockpaperscissors/tags",
    "blobs_url": "https://git-aws.internal.justin.tv/api/v3/repos/dta/rockpaperscissors/git/blobs{/sha}",
    "git_tags_url": "https://git-aws.internal.justin.tv/api/v3/repos/dta/rockpaperscissors/git/tags{/sha}",
    "git_refs_url": "https://git-aws.internal.justin.tv/api/v3/repos/dta/rockpaperscissors/git/refs{/sha}",
    "trees_url": "https://git-aws.internal.justin.tv/api/v3/repos/dta/rockpaperscissors/git/trees{/sha}",
    "statuses_url": "https://git-aws.internal.justin.tv/api/v3/repos/dta/rockpaperscissors/statuses/{sha}",
    "languages_url": "https://git-aws.internal.justin.tv/api/v3/repos/dta/rockpaperscissors/languages",
    "stargazers_url": "https://git-aws.internal.justin.tv/api/v3/repos/dta/rockpaperscissors/stargazers",
    "contributors_url": "https://git-aws.internal.justin.tv/api/v3/repos/dta/rockpaperscissors/contributors",
    "subscribers_url": "https://git-aws.internal.justin.tv/api/v3/repos/dta/rockpaperscissors/subscribers",
    "subscription_url": "https://git-aws.internal.justin.tv/api/v3/repos/dta/rockpaperscissors/subscription",
    "commits_url": "https://git-aws.internal.justin.tv/api/v3/repos/dta/rockpaperscissors/commits{/sha}",
    "git_commits_url": "https://git-aws.internal.justin.tv/api/v3/repos/dta/rockpaperscissors/git/commits{/sha}",
    "comments_url": "https://git-aws.internal.justin.tv/api/v3/repos/dta/rockpaperscissors/comments{/number}",
    "issue_comment_url": "https://git-aws.internal.justin.tv/api/v3/repos/dta/rockpaperscissors/issues/comments{/number}",
    "contents_url": "https://git-aws.internal.justin.tv/api/v3/repos/dta/rockpaperscissors/contents/{+path}",
    "compare_url": "https://git-aws.internal.justin.tv/api/v3/repos/dta/rockpaperscissors/compare/{base}...{head}",
    "merges_url": "https://git-aws.internal.justin.tv/api/v3/repos/dta/rockpaperscissors/merges",
    "archive_url": "https://git-aws.internal.justin.tv/api/v3/repos/dta/rockpaperscissors/{archive_format}{/ref}",
    "downloads_url": "https://git-aws.internal.justin.tv/api/v3/repos/dta/rockpaperscissors/downloads",
    "issues_url": "https://git-aws.internal.justin.tv/api/v3/repos/dta/rockpaperscissors/issues{/number}",
    "pulls_url": "https://git-aws.internal.justin.tv/api/v3/repos/dta/rockpaperscissors/pulls{/number}",
    "milestones_url": "https://git-aws.internal.justin.tv/api/v3/repos/dta/rockpaperscissors/milestones{/number}",
    "notifications_url": "https://git-aws.internal.justin.tv/api/v3/repos/dta/rockpaperscissors/notifications{?since,all,participating}",
    "labels_url": "https://git-aws.internal.justin.tv/api/v3/repos/dta/rockpaperscissors/labels{/name}",
    "releases_url": "https://git-aws.internal.justin.tv/api/v3/repos/dta/rockpaperscissors/releases{/id}",
    "deployments_url": "https://git-aws.internal.justin.tv/api/v3/repos/dta/rockpaperscissors/deployments",
    "created_at": "2016-08-02T22:02:22Z",
    "updated_at": "2016-10-27T22:12:28Z",
    "pushed_at": "2017-05-04T21:05:28Z",
    "git_url": "git://git-aws.internal.justin.tv/dta/rockpaperscissors.git",
    "ssh_url": "git@git-aws.internal.justin.tv:dta/rockpaperscissors.git",
    "clone_url": "https://git-aws.internal.justin.tv/dta/rockpaperscissors.git",
    "svn_url": "https://git-aws.internal.justin.tv/dta/rockpaperscissors",
    "homepage": "http://link.twitch.tv/rps",
    "size": 22666,
    "stargazers_count": 2,
    "watchers_count": 2,
    "language": "JavaScript",
    "has_issues": false,
    "has_downloads": false,
    "has_wiki": false,
    "has_pages": false,
    "forks_count": 0,
    "mirror_url": null,
    "open_issues_count": 0,
    "forks": 0,
    "open_issues": 0,
    "watchers": 2,
    "default_branch": "master"
  },
  "organization": {
    "login": "dta",
    "id": 181,
    "url": "https://git-aws.internal.justin.tv/api/v3/orgs/dta",
    "repos_url": "https://git-aws.internal.justin.tv/api/v3/orgs/dta/repos",
    "events_url": "https://git-aws.internal.justin.tv/api/v3/orgs/dta/events",
    "hooks_url": "https://git-aws.internal.justin.tv/api/v3/orgs/dta/hooks",
    "issues_url": "https://git-aws.internal.justin.tv/api/v3/orgs/dta/issues",
    "members_url": "https://git-aws.internal.justin.tv/api/v3/orgs/dta/members{/member}",
    "public_members_url": "https://git-aws.internal.justin.tv/api/v3/orgs/dta/public_members{/member}",
    "avatar_url": "https://git-aws.internal.justin.tv/avatars/u/181?",
    "description": "Dank Times Ahead"
  },
  "sender": {
    "login": "fullht",
    "id": 489,
    "avatar_url": "https://git-aws.internal.justin.tv/avatars/u/489?",
    "gravatar_id": "",
    "url": "https://git-aws.internal.justin.tv/api/v3/users/fullht",
    "html_url": "https://git-aws.internal.justin.tv/fullht",
    "followers_url": "https://git-aws.internal.justin.tv/api/v3/users/fullht/followers",
    "following_url": "https://git-aws.internal.justin.tv/api/v3/users/fullht/following{/other_user}",
    "gists_url": "https://git-aws.internal.justin.tv/api/v3/users/fullht/gists{/gist_id}",
    "starred_url": "https://git-aws.internal.justin.tv/api/v3/users/fullht/starred{/owner}{/repo}",
    "subscriptions_url": "https://git-aws.internal.justin.tv/api/v3/users/fullht/subscriptions",
    "organizations_url": "https://git-aws.internal.justin.tv/api/v3/users/fullht/orgs",
    "repos_url": "https://git-aws.internal.justin.tv/api/v3/users/fullht/repos",
    "events_url": "https://git-aws.internal.justin.tv/api/v3/users/fullht/events{/privacy}",
    "received_events_url": "https://git-aws.internal.justin.tv/api/v3/users/fullht/received_events",
    "type": "User",
    "site_admin": true,
    "ldap_dn": "cn=T.R. Fullhart,ou=Users,dc=justin,dc=tv"
  }
}
"""


@mock.patch.object(event_bus, 'EventBus', autospec=True)
@mock.patch.object(event_bus, 'uuid_mod', autospec=True)
@mock.patch.object(github_webhook_handler, 'time', autospec=True)
class TestCase(unittest.TestCase):

    def testPush(self, mock_time, mock_uuid, mock_bus):
        expected_time = time.time()
        expected_uuid = uuid.uuid4()

        mock_time.time.return_value = expected_time
        mock_uuid.uuid4.return_value = expected_uuid

        response = github_webhook_handler.lambda_handler(
            aws_lambda.APIGatewayProxyLambdaEvent(
                PUSH_WEBHOOK_PAYLOAD, headers={
                  'X-GitHub-Event': 'push',
                  'X-GitHub-Delivery': 'e2aed300-851e-11e6-98d4-c57593e38aa9',
            }),
            aws_lambda.Context('rockpaperscissors-development-lambda'))

        self.assertEqual(response, {
            'statusCode': '200',
            'headers': {},
            'body': 'OK',
        })

        expected_event = event_bus.Event(
            uuid=expected_uuid.bytes,
            timestamp=expected_time,
            event_type='GitHub-push',
            body=str(PUSH_WEBHOOK_PAYLOAD),
            attributes={
              'github_repository': (
                  'https://git-aws.internal.justin.tv/dta/rockpaperscissors'),
              'pusher': 'fullht',
              'branch': 'master',
        })
        mock_bus_obj = mock_bus.return_value
        mock_bus_obj.PutEvent.assert_called_once_with(expected_event)

    def testPullRequest(self, mock_time, mock_uuid, mock_bus):
        expected_time = time.time()
        expected_uuid = uuid.uuid4()

        mock_time.time.return_value = expected_time
        mock_uuid.uuid4.return_value = expected_uuid

        response = github_webhook_handler.lambda_handler(
            aws_lambda.APIGatewayProxyLambdaEvent(
                PULL_REQUEST_WEBHOOK_PAYLOAD, headers={
                    'X-GitHub-Event': 'pull_request',
                    'X-GitHub-Delivery': 'e2aed300-851e-11e6-98d4-c57593e38aa9',
                }),
            aws_lambda.Context('rockpaperscissors-development-lambda'))

        self.assertEqual(response, {
            'statusCode': '200',
            'headers': {},
            'body': 'OK',
        })

        expected_event = event_bus.Event(
            uuid=expected_uuid.bytes,
            timestamp=expected_time,
            event_type='GitHub-pull_request-closed',
            body=github_webhook_handler.compress(
                PULL_REQUEST_WEBHOOK_PAYLOAD, filename='pull_request',
                mtime=expected_time),
            attributes={
                'head_repository': (
                    'https://git-aws.internal.justin.tv/dta/rockpaperscissors'),
                'head_ref': 'fullht-github_webhooks',
                'base_repository': (
                    'https://git-aws.internal.justin.tv/dta/rockpaperscissors'),
                'base_ref': 'master',
                'user': 'fullht',
        })
        mock_bus_obj = mock_bus.return_value
        mock_bus_obj.PutEvent.assert_called_once_with(expected_event)

    def testDeploymentStatus(self, mock_time, mock_uuid, mock_bus):
        expected_time = time.time()
        expected_uuid = uuid.uuid4()

        mock_time.time.return_value = expected_time
        mock_uuid.uuid4.return_value = expected_uuid

        response = github_webhook_handler.lambda_handler(
            aws_lambda.APIGatewayProxyLambdaEvent(
                DEPLOYMENT_STATUS_WEBHOOK_PAYLOAD, headers={
                    'X-GitHub-Event': 'deployment_status',
                    'X-GitHub-Delivery': 'e2aed300-851e-11e6-98d4-c57593e38aa9',
                }),
            aws_lambda.Context('rockpaperscissors-development-lambda'))

        self.assertEqual(response, {
            'statusCode': '200',
            'headers': {},
            'body': 'OK',
        })

        expected_event = event_bus.Event(
            uuid=expected_uuid.bytes,
            timestamp=expected_time,
            event_type='GitHub-deployment_status',
            body=github_webhook_handler.compress(
                DEPLOYMENT_STATUS_WEBHOOK_PAYLOAD, filename='deployment_status',
                mtime=expected_time),
            attributes={
                'github_repository': (
                    'https://git-aws.internal.justin.tv/dta/rockpaperscissors'),
                'deployment_state': 'success',
                'creator': 'fullht',
        })
        mock_bus_obj = mock_bus.return_value
        mock_bus_obj.PutEvent.assert_called_once_with(expected_event)


if __name__ == '__main__':
    unittest.main()
