#!/bin/bash

set -e

if [ -d .coverage ]; then
  rm -rf .coverage
fi

COVERAGE_ARGS="--branch --source=. --omit=code/justin/tv/dta/rockpaperscissors/proto/*.py,lib/*.py,google/*.py,*_test.py"

for TESTFILE in *_test.py; do
  coverage run ${COVERAGE_ARGS} -a ${TESTFILE}
done

TEST_MODULES=$(echo code/justin/tv/dta/rockpaperscissors/*_test.py | sed -e 's/\.py//g' -e 's/\//./g')

for TEST_MODULE in $TEST_MODULES; do
  coverage run ${COVERAGE_ARGS} -a -m ${TEST_MODULE}
done

coverage report -m
coverage html -d ./coverage_html/
