#!/bin/sh

set -e

# Use Node/npm/react to "compile" the javascript into the dist/ folder.
# The deploy step will run lint and tests.  On success will populate dist/ folder.
yarn install
npm run deploy:prod

# Package the javascript and html into compiled-in assets for serving.
# bindata_assetfs.go will be generated in this Go package.
go-bindata -pkg web -prefix $(pwd)/dist $(pwd)/dist/...
