import React from 'react'
import { Alert } from 'react-bootstrap'

class ErrorAlert extends React.Component {
  render () {
    let header = null
    if (this.props.header !== undefined) {
      header = <h4>{this.props.header}</h4>
    }

    let message = null
    if (this.props.message !== undefined) {
      message = <p>{this.props.message}</p>
    }

    let error = null
    if (this.props.error !== undefined) {
      error = <p>{this.props.error}</p>
    }

    return (
      <Alert bsStyle='danger'>
        {header}
        {message}
        {error}
        <br />
      </Alert>
    )
  }
}

ErrorAlert.propTypes = {
  header: React.PropTypes.string.isRequired,
  message: React.PropTypes.string.isRequired,
  error: React.PropTypes.string
}

export default ErrorAlert
