import React from 'react'
import {
  FormGroup,
  FormControl,
  ControlLabel,
  InputGroup,
  HelpBlock
} from 'react-bootstrap'
import './Forms.scss'

import { FormValidation } from './FormValidation'

export class FormText extends React.Component {
  constructor (props) {
    super(props)
    this.handleChange = this.handleChange.bind(this)
  }

  handleChange (e) {
    this.props.valueHandler(e.target.value)
  }

  validateValue () {
    if (this.props.validation !== undefined) {
      return this.props.validation
    }
    return this.props.valueValidator(this.props.value)
  }

  render () {
    const validation = this.validateValue()

    let controlLabel = null
    if (this.props.controlLabel !== undefined) {
      controlLabel = <ControlLabel>{this.props.controlLabel}</ControlLabel>
    }

    let helpBlock = null
    if (this.props.controlHelp !== undefined) {
      helpBlock = <HelpBlock className='formHelpBox'>{this.props.controlHelp}</HelpBlock>
    }

    let input = null
    let inputFeedback = null
    if (this.props.inputBefore !== undefined || this.props.inputAfter !== undefined) {
      let inputBefore = null
      if (this.props.inputBefore !== undefined) {
        inputBefore = this.props.inputBefore
      }
      let inputAfter = null
      if (this.props.inputAfter !== undefined) {
        inputAfter = this.props.inputAfter
      }
      input = (
        <FormGroup
          controlId={this.props.controlId}
          validationState={validation.typeStr}
        >
          <InputGroup>
            {inputBefore}
            <FormControl
              style={{ width: this.props.width }}
              type='text'
              value={this.props.value}
              placeholder={this.props.valuePlaceholder}
              onChange={this.handleChange}
            />
            <FormControl.Feedback />
            {inputAfter}
          </InputGroup>
        </FormGroup>
      )
      inputFeedback = (
        <HelpBlock className={`formFeedback_${validation.typeStr}`}>
          {validation.feedback}
        </HelpBlock>
      )
    } else {
      input = (
        <FormGroup
          controlId={this.props.controlId}
          validationState={validation.typeStr}
          style={{ width: this.props.width }}
        >
          <FormControl
            type='text'
            value={this.props.value}
            placeholder={this.props.valuePlaceholder}
            onChange={this.handleChange}
          />
          <FormControl.Feedback />
        </FormGroup>
      )
      inputFeedback = (
        <HelpBlock className={`formFeedback_${validation.typeStr}`} style={{ marginTop: '-10px' }}>
          {validation.feedback}
        </HelpBlock>
      )
    }

    return (
      <div style={{ display: 'inline-block', marginBottom: '15px' }}>
        {controlLabel}
        {helpBlock}
        {input}
        {inputFeedback}
      </div>
    )
  }
}

FormText.defaultProps = {
  width: null,
  groupWidth: null,
  valueValidator: (value) => { return new FormValidation() }
}

FormText.propTypes = {
  controlId: React.PropTypes.string,
  controlLabel: React.PropTypes.string,
  controlHelp: React.PropTypes.string,
  value: React.PropTypes.string.isRequired,
  valueHandler: React.PropTypes.func.isRequired,
  valueValidator: React.PropTypes.func,
  valuePlaceholder: React.PropTypes.string,
  validation: React.PropTypes.any,
  width: React.PropTypes.any,
  inputBefore: React.PropTypes.any,
  inputAfter: React.PropTypes.any
}
