import { Enum } from 'enumify'

export class FormValidationType extends Enum {}
FormValidationType.initEnum([
  'SUCCESS',
  'WARNING',
  'ERROR',
  'NULL'
])

export class FormValidation {
  constructor (type = FormValidationType.NULL, feedback = '') {
    this.type = type
    this.feedback = feedback
  }

  get typeStr () {
    if (this.type === FormValidationType.NULL) {
      return null
    } else {
      return this.type.name.toLowerCase()
    }
  }
}
