import React from 'react'
import { ProgressBar } from 'react-bootstrap'

export default class HealthBar extends React.Component {

  render () {
    const health = (this.props.health * 100)
    let style = 'danger'
    if (health >= 66) {
      style = 'success'
    } else if (health >= 33) {
      style = 'warning'
    }
    return (
      <ProgressBar bsStyle={style} now={health} label={`${health.toFixed(2)}%`} />
    )
  }
}

HealthBar.propTypes = {
  health: React.PropTypes.number
}
