import React from 'react'
import { Line } from 'react-chartjs-2'

export default class LineGraph extends React.Component {

  clickLegend (event, legendItem) {
    event.preventDefault()
  }

  render () {
    const data = {
      labels: this.props.labels,
      datasets: this.props.datasets
    }
    return (
      <div>
        <Line data={data} redraw options={this.props.options} height={this.props.height} />
      </div>
    )
  }
}

LineGraph.propTypes = {
  labels: React.PropTypes.arrayOf(React.PropTypes.string),
  datasets: React.PropTypes.arrayOf(React.PropTypes.object),
  height: React.PropTypes.number,
  options: React.PropTypes.object
}
