import React, { Component } from 'react'
import { Panel, ListGroup, ListGroupItem, utils } from 'react-bootstrap'
import { LinkContainer } from 'react-router-bootstrap'
import LinkListEntry from './LinkListEntry'
import './LinkList.scss'

// This is needed to avoid errors in the console when using a custom bsStyle on bootstrap componenets.
utils.bootstrapUtils.addStyle(Panel, 'twitchPurple')

class LinkList extends Component {

  render () {
    if (this.props.links === undefined || this.props.links.length <= 0) {
      return null
    }

    const links = this.props.links.map((link, idx) => {
      if (link.isRoute) {
        return (
          <LinkContainer key={idx} to={link.url}>
            <ListGroupItem href='#'>{link.content}</ListGroupItem>
          </LinkContainer>
        )
      } else {
        return <ListGroupItem key={idx} href={link.url} target='_blank'>{link.content}</ListGroupItem>
      }
    })

    const header = <div>{this.props.header}</div>

    const bsStyle = this.props.style
    let csStyle = this.props.style
    if (LinkList.bsStyles.includes(bsStyle)) {
      csStyle = null
    }

    return (
      <Panel bsStyle={bsStyle} className={csStyle} header={header}>
        <ListGroup fill>{links}</ListGroup>
      </Panel>
    )
  }
}

LinkList.bsStyles = ['success', 'warning', 'danger', 'info', 'default', 'primary']

LinkList.defaultProps = {
  style: 'twitchPurple'
}

LinkList.propTypes = {
  links:  React.PropTypes.arrayOf(React.PropTypes.instanceOf(LinkListEntry)),
  header: React.PropTypes.string,
  style: React.PropTypes.string
}

export default LinkList
