import React, { Component } from 'react'
import Loading from 'react-loading'
import { ProgressBar, Glyphicon } from 'react-bootstrap'
import { TableRow, TableCol, TableSorter, TableValueType } from './data'
import { Link } from 'react-router'

class NestedTableCell extends Component {
  render () {
    const row = this.props.row
    const col = this.props.col

    let cellColor = null
    const sorter = this.props.sorter
    if (sorter !== null && sorter.id === col.id) {
      cellColor = `sorting`
    }
    const className = `text-center ${cellColor}`

    // What we render inside our cell varies depending on the TableValueType of the object we received.
    let cellValues = this.props.values
    let value
    if (cellValues !== undefined && cellValues[row.id] !== undefined) {
      value = cellValues[row.id][col.id]
    }

    let loadedValues = this.props.loadedValues
    let valueIsReady = false
    if (loadedValues !== undefined) {
      loadedValues = loadedValues[row.id]
      if (loadedValues !== undefined) {
        loadedValues = loadedValues[col.id]
      }
      if (loadedValues === undefined) {
        loadedValues = false
      }
      valueIsReady = loadedValues
    } else {
      valueIsReady = (value !== undefined)
    }

    // If we are still loading, then show the loading bar.
    if (this.props.loading && !valueIsReady) {
      const loadingWidth = '2rem'
      const loadingHeight = '2rem'
      return (
        <td className={className}>
          <center>
            <Loading type='bars' color='#6441a4' width={loadingWidth} height={loadingHeight} />
          </center>
        </td>
      )
    }

    // What we render inside our cell varies depending on the TableValueType of the object we received.
    if (value !== undefined) {
      switch (value.type) {
        case TableValueType.BOOL:
          if (value.value) {
            value = <Glyphicon className='color-true' glyph='ok' />
          } else {
            value = null
          }
          break
        case TableValueType.LIST:
          let array = value.value

          let components = array.map((entry, idx) => {
            let style = null
            if (idx === 0) {
              style = 'success'
            } else if (idx === 1) {
              style = 'warning'
            } else if (idx === 2) {
              style = 'danger'
            } else if (idx === 3) {
              style = 'info'
            }
            return <ProgressBar striped bsStyle={style} now={entry} key={idx} />
          })
          value =
            <ProgressBar style={{ marginBottom:'0', height:'1.2rem' }}>
              {components}
            </ProgressBar>
          break
        case TableValueType.NULL:
          value = <div className='null-value'>&#8212;</div>
          break
        case TableValueType.NUMBER:
          let urlStr = row.cellUrl + `${col.id}`
          if (value.unit === '%') {
            value = <Link to={urlStr}>{(value.value * 100).toFixed(2)}%</Link>
          } else {
            value = <Link to={urlStr}>{value.value}</Link>
          }
          break
        case TableValueType.STRING:
        default:
          value = value.value
      }
    } else {
      value = <div className='null-value'>&#8212;</div>
    }

    // Now render our value.
    return (<td className={className}>{value}</td>)
  }
}

NestedTableCell.propTypes = {
  row: React.PropTypes.instanceOf(TableRow).isRequired,
  col: React.PropTypes.instanceOf(TableCol).isRequired,
  values: React.PropTypes.object.isRequired,
  sorter: React.PropTypes.instanceOf(TableSorter),
  loading: React.PropTypes.bool,
  urlPrefix: React.PropTypes.string,
  loadedValues: React.PropTypes.object
}

export default NestedTableCell
