class TableRow {
  constructor (id, content, parentRow) {
    this.id = id
    this.content = content
    this.children = []
    this.rowId = `${this.id}`
    if (parentRow !== undefined) {
      this.rowId = `${parentRow.rowId}.${this.rowId}`
      parentRow.children.push(this)
    }
    this.rowLevel = (this.rowId.split('.').length - 1)
  }

  get expands () {
    return (this.children.length > 0)
  }
}

export default TableRow
