import { Enum } from 'enumify'

export class TableValueType extends Enum {}

TableValueType.initEnum([
  'BOOL',
  'NUMBER',
  'STRING',
  'LIST',
  'UNKNOWN',
  'NULL'
])

export class TableValue {

  constructor (value, unit) {
    this.type = TableValueType.NULL
    this.value = null
    this.unit = unit
    if (value !== undefined) {
      this.value = value
      const valueType = typeof value
      if (valueType === 'number') {
        this.type = TableValueType.NUMBER
      } else if (valueType === 'string') {
        this.type = TableValueType.STRING
      } else if (valueType === 'boolean') {
        this.type = TableValueType.BOOL
      } else {
        this.type = TableValueType.UNKNOWN
        this.value = 'Unknown value!'
      }
    }
  }

  static getObject (values, rowId, colId) {
    if (values === undefined) {
      return undefined
    }
    if (values[rowId] === undefined) {
      return undefined
    }
    return values[rowId][colId]
  }
}
