import React from 'react'
import { Line } from 'react-chartjs-2'
import { Grid, Row, Col, ButtonGroup, Button } from 'react-bootstrap'
import BucketTypeSelector from 'containers/BucketTypeSelector'
import RangeTypeSelector from 'containers/RangeTypeSelector'
import ToggleMetrics from 'containers/ToggleMetrics'
import './ServiceGraph.scss'

export default class ServiceGraph extends React.Component {

  constructor (props) {
    super(props)
    this.state = {
      hideToggleMetrics: true
    }
    this.toggleToggleMetrics = this.toggleToggleMetrics.bind(this)
    this.hideToggleMetrics = this.hideToggleMetrics.bind(this)
  }

  toggleToggleMetrics () {
    this.setState({ hideToggleMetrics: !this.state.hideToggleMetrics })
  }

  hideToggleMetrics (isHidden) {
    if (!isHidden) {
      this.setState({ hideToggleMetrics: true })
    }
  }

  clickLegend (event, legendItem) {
    event.preventDefault()
  }

  render () {
    if (this.props.loading) {
      return (
        <div>
          Loading...
        </div>
      )
    }
    const data = {
      labels: this.props.graphLabels,
      datasets: this.props.graphData
    }

    let headerStr = null
    const metricIds = this.props.graphMetricIds
    const validMetricIds = this.props.validMetricIds
    const metrics = this.props.metrics
    if (metricIds.length > 0) {
      headerStr = 'Viewing '
      if (metricIds.length === 1) {
        headerStr += `${metrics[metricIds[0]].name}`
      } else if (metricIds.length === validMetricIds.length) {
        headerStr += 'all metrics'
      } else {
        headerStr += `${metricIds.length} of ${this.props.validMetricIds.length} metrics`
      }
      headerStr = <h1 style={{ marginTop: '0px' }}>{headerStr}</h1>
    }

    let controls = null
    if (this.props.showControls) {
      controls = (
        <Grid fluid>
          <Row>
            <Col sm={12}>
              {headerStr}
            </Col>
          </Row>
          <Row>
            <Col sm={12}>
              <table className='graph-controls-table'>
                <tbody>
                  <tr>
                    <td className='graph-controls-buttons-col'>
                      <ButtonGroup>
                        <BucketTypeSelector
                          disabled={this.props.loading}
                          reducerKey={this.props.reducerKey}
                          urlStr={this.props.urlStr}
                        />
                        <RangeTypeSelector
                          disabled={this.props.loading}
                          reducerKey={this.props.reducerKey}
                          urlStr={this.props.urlStr}
                        />
                        <Button disabled={this.props.loading} onClick={this.toggleToggleMetrics}>
                          Metrics <span className='caret' />
                        </Button>
                      </ButtonGroup>
                    </td>
                  </tr>
                </tbody>
              </table>
            </Col>
          </Row>
          <Row>
            <Col sm={12}>
              <ToggleMetrics
                hidden={this.state.hideToggleMetrics}
                onClickOutside={this.hideToggleMetrics}
                metricIds={this.props.validMetricIds}
                reducerKey={this.props.reducerKey}
                urlStr={this.props.urlStr}
              />
            </Col>
          </Row>
        </Grid>
      )
    }

    return (
      <Grid fluid>
        <Row>
          <Col sm={12}>
            {controls}
          </Col>
        </Row>
        <Row>
          <Col className='metrics-graph-container' sm={12}>
            <div>
              <Line data={data} redraw options={this.props.graphOptions} height={this.props.graphHeight} />
            </div>
          </Col>
        </Row>
      </Grid>

    )
  }
}

ServiceGraph.propTypes = {
  validMetricIds: React.PropTypes.arrayOf(React.PropTypes.string),
  graphLabels: React.PropTypes.arrayOf(React.PropTypes.string),
  graphMetricIds: React.PropTypes.arrayOf(React.PropTypes.string),
  graphData: React.PropTypes.arrayOf(React.PropTypes.object),
  graphHeight: React.PropTypes.number,
  graphOptions: React.PropTypes.object,
  loading: React.PropTypes.bool,
  reducerKey: React.PropTypes.string,
  showControls: React.PropTypes.bool,
  urlStr: React.PropTypes.string,
  metrics: React.PropTypes.any
}
