The `SliderBar` Component renders a slider with values using [`rc-slider`](https://github.com/react-component/slider).

## Properties

## values
List of `SliderBarEntry` objects that we want to render within our slider.  Each entry will be mark on our bar.

## onChange
Function to call when the current `SliderBarEntry` changes.  Function will be given the selected `SliderBarEntry` object's `id`.

## disabled
If set, will disable the user form interacting with the `SliderBar`.

## value
Value to set the `SliderBar` to when it renders.  The value is the `idx` of an entry in our `values` list.  You should note that if you utilize `onChange`, then you should make sure to update this property with the `idx` of whatever was selected.  If you don't, then the `SliderBar` may be stuck on this value and unable to slide.

## The `SliderBarEntry` Object
Each mark on our slider is a representation of a `SliderBarEntry`.  A `SliderBarEntry` is a very simple object that just has an `id`, `name`, and `shortName`.  They are defined as follows:

* The `id` is what our `SliderBar` returns when our entry is selected.
* The `name` is what our `SliderBar` displays in a tool-tip when the user either hovers over our entry or is sliding past it.
* The `shortName` is what displays beneath our entry if it is either the first or last entry.
