import React, { Component } from 'react'
import { Glyphicon } from 'react-bootstrap'

class ToggleCol extends Component {
  constructor (props) {
    super(props)
    this.onSelect = this.onSelect.bind(this)
  }

  onSelect () {
    this.props.onSelect(this.props.metric)
  }

  render () {
    let glyphId = 'check'
    if (this.props.metric.hidden) {
      glyphId = 'unchecked'
    }
    return (
      <td>
        <a onClick={this.onSelect}>
          <Glyphicon className='toggle-table-checkbox' glyph={glyphId} />{' '}{this.props.metric.name}
        </a>
      </td>
    )
  }
}

ToggleCol.propTypes = {
  metric: React.PropTypes.object,
  onSelect: React.PropTypes.func
}

export default ToggleCol
