import { connect } from 'react-redux'
import EnumDropdown from 'components/EnumDropdown'
import { BucketType } from 'modules/api_data/types'
import { fetchMetricsData, DEFAULT_REDUCER_KEY } from 'modules/metrics_data/actions'

const mapStateToProps = (state, ownProps) => {
  let reducerKey = ownProps.reducerKey
  if (reducerKey === undefined) {
    reducerKey = DEFAULT_REDUCER_KEY
  }
  let prefix = 'By '
  let title = prefix + state[ownProps.reducerKey].curBucketType.name.replace(/_/g, ' ').toLowerCase()
  title = title.split(' ').map(function (word) {
    return word.charAt(0).toUpperCase() + word.slice(1)
  }).join(' ')
  return {
    enum: BucketType,
    title: title,
    prefix: prefix,
    filter: state[ownProps.reducerKey].curValidBucketTypes
  }
}

const mapDispatchToProps = (dispatch, ownProps) => {
  let reducerKey = ownProps.reducerKey
  if (reducerKey === undefined) {
    reducerKey = DEFAULT_REDUCER_KEY
  }
  return {
    onEnumSelect: (bucketType) => {
      return dispatch(fetchMetricsData(undefined, undefined, undefined, bucketType, reducerKey, ownProps.urlStr))
    }
  }
}

export default connect(mapStateToProps, mapDispatchToProps)(EnumDropdown)
