import { connect } from 'react-redux'
import EnumDropdown from 'components/EnumDropdown'
import { RangeType } from 'modules/api_data/types'
import { fetchMetricsData, DEFAULT_REDUCER_KEY } from 'modules/metrics_data/actions'

const mapStateToProps = (state, ownProps) => {
  let reducerKey = ownProps.reducerKey
  if (reducerKey === undefined) {
    reducerKey = DEFAULT_REDUCER_KEY
  }
  let title = state[reducerKey].curRangeType.name.replace(/_/g, ' ').toLowerCase()
  title = 'From ' + title.split(' ').map(function (word) {
    return word.charAt(0).toUpperCase() + word.slice(1)
  }).join(' ')
  return {
    enum: RangeType,
    title: title
  }
}

const mapDispatchToProps = (dispatch, ownProps) => {
  let reducerKey = ownProps.reducerKey
  if (reducerKey === undefined) {
    reducerKey = DEFAULT_REDUCER_KEY
  }
  return {
    onEnumSelect: (rangeType) => {
      return dispatch(fetchMetricsData(undefined, undefined, rangeType, undefined, reducerKey, ownProps.urlStr))
    }
  }
}

export default connect(mapStateToProps, mapDispatchToProps)(EnumDropdown)
