import React from 'react'
import { Nav, Navbar, NavItem } from 'react-bootstrap'
import { Link } from 'react-router'
import { LinkContainer } from 'react-router-bootstrap'
import './Header.scss'

export default class Header extends React.Component {
  render () {
    return (
      <Navbar className='twitch-navbar' collapseOnSelect>
        <Navbar.Header>
          <Navbar.Brand>
            <Link to='/'>
            RPS
            </Link>
          </Navbar.Brand>
          <Navbar.Toggle />
        </Navbar.Header>
        <Nav>
          <LinkContainer to='/projects'>
            <NavItem eventKey={1} href='#'>Projects</NavItem>
          </LinkContainer>
        </Nav>
        <Nav>
          <LinkContainer to='/teams'>
            <NavItem eventKey={1} href='#'>Teams</NavItem>
          </LinkContainer>
        </Nav>
        <Nav>
          <LinkContainer to='/orgs'>
            <NavItem eventKey={1} href='#'>Orgs</NavItem>
          </LinkContainer>
        </Nav>
        <Nav>
          <LinkContainer to='/metrics'>
            <NavItem eventKey={1} href='#'>Metrics</NavItem>
          </LinkContainer>
        </Nav>
        <Nav pullRight>
          <LinkContainer to='/enroll'>
            <NavItem eventKey={2} href='#'>Enroll</NavItem>
          </LinkContainer>
        </Nav>
      </Navbar>
    )
  }
}
