import { TableValue } from 'components/NestedTable/data'
import { BucketType } from '../types'

var dateFormat = require('dateformat')

export default class Bucket {
  constructor (type, serviceId, metricId, json, rangeStart, rangeEnd, unit, startTime, endTime) {
    this.type = type
    this.start = startTime
    if (this.start === undefined) {
      this.start = new Date(json.timerange.start)
    }
    this.end = endTime
    if (this.end === undefined) {
      this.end = new Date(json.timerange.end)
    }
    this.id = `${rangeStart}.${rangeEnd}.${this.type}`
    this.id += `.${dateFormat(this.start, 'mm_dd_yy')}.${dateFormat(this.end, 'mm_dd_yy')}`
    this.values = {}
    this.addValue(serviceId, metricId, json.value, unit)
  }

  get name () {
    if (this.type === BucketType.DAY) {
      return dateFormat(this.start, 'dddd (m/d/yyyy)')
    }
    if (this.type === BucketType.WEEK) {
      return dateFormat(this.start, 'm/d/yy') + ' - ' + dateFormat(this.end, 'm/d/yy')
    }
    if (this.type === BucketType.MONTH) {
      return dateFormat(this.start, 'mmm yyyy')
    }
    if (this.type === BucketType.YEAR) {
      return dateFormat(this.start, 'yyyy')
    }
  }

  get shortName () {
    if (this.type === BucketType.DAY) {
      return dateFormat(this.start, 'm/d')
    }
    if (this.type === BucketType.WEEK) {
      return dateFormat(this.start, 'm/d')
    }
    if (this.type === BucketType.MONTH) {
      return dateFormat(this.start, 'mmm')
    }
    if (this.type === BucketType.YEAR) {
      return dateFormat(this.start, 'yyyy')
    }
  }

  get startTime () {
    return this.start.getTime()
  }

  get endTime () {
    return this.end.getTime()
  }

  get numValues () {
    let numValues = 0
    for (let service of Object.keys(this.values)) {
      numValues += Object.keys(this.values[service]).length
    }
    return numValues
  }

  addValue (serviceId, metricId, value, unit) {
    if (this.values[serviceId] === undefined) {
      this.values[serviceId] = {}
    }
    this.values[serviceId][metricId] = new TableValue(value, unit)
  }

  mergeValues (date) {
    Object.keys(date.values).forEach((serviceId) => {
      if (this.values[serviceId] === undefined) {
        this.values[serviceId] = {}
      }
      Object.keys(date.values[serviceId]).forEach((metricId) => {
        this.values[serviceId][metricId] = date.values[serviceId][metricId]
      })
    })
  }

  /**
   * TODO: This function generates place holder values for our metric.  Remove this once the API is returning values.
   */
  generatePlaceHolderValues (metricId) {
    let value = {}
    if (metricId === 'code_churn') {
      value.string_value = `${(Math.random() * 100).toFixed(2)}%`
    } else if (metricId === 'pager_incidents') {
      let boolValue = false
      if (Math.random() >= 0.5) {
        boolValue = true
      }
      value.bool_value = boolValue
    } else if (metricId === 'pager_incidents') {
      let boolValue = false
      if (Math.random() >= 0.5) {
        boolValue = true
      }
      value.bool_value = boolValue
    } else if (metricId === 'test_rates') {
      let max = 100
      let min = 0
      let pass = Math.floor(Math.random() * (max - min + 1)) + min
      max = 100 - pass
      let fail = Math.floor(Math.random() * (max - min + 1)) + min
      let blocked = 100 - pass - fail
      value.list_value = [
        pass,
        fail,
        blocked
      ]
    } else {
      let min = 0
      let max = 100
      if (metricId === 'builds_deployed') {
        min = 0
        max = 5
      }
      if (metricId === 'issues_closed') {
        min = 10
        max = 75
      }
      value.number_value = Math.floor(Math.random() * (max - min + 1)) + min
    }
    return value
  }
}
