import { ServiceType } from '../types'

export default class Metric {
  constructor (json) {
    this.id = json.metric_id
    this.name = json.metric_name
    this.description = json.description

    // Create a hash that maps a service type to a bool we got in our .json.
    // If json didn't define whther or not we're valid for a given type, then we assume its not.
    this.validServiceTypes = {}
    this.validServiceTypes[ServiceType.ORG] = false
    if (json.valid_for_org !== undefined) {
      this.validServiceTypes[ServiceType.ORG] = json.valid_for_org
    }
    this.validServiceTypes[ServiceType.TEAM] = false
    if (json.valid_for_team !== undefined) {
      this.validServiceTypes[ServiceType.TEAM] = json.valid_for_team
    }
    this.validServiceTypes[ServiceType.PROJECT] = false
    if (json.valid_for_project !== undefined) {
      this.validServiceTypes[ServiceType.PROJECT] = json.valid_for_project
    }
  }

  isValidForService (service) {
    const isValid = this.validServiceTypes[service.type]
    // If we couldn't find out type for some reason, then assume that this metric isn't valid for it.
    if (isValid === undefined) {
      return false
    }
    return isValid
  }
}
