import React from 'react'
import Utils from 'utils/Utils'

export default class ProjectInfo {
  constructor (json) {
    this.orgName = json.org_name
    this.teamName = json.team_name
    this.lastUpdated = new Date(0)
    this.lastUpdated.setUTCSeconds(json.last_update_timestamp)
    this.techLeads = json.tech_lead
    if (this.techLeads === undefined) {
      this.techLeads = []
    }
    this.techLeads = this.techLeads.sort()
    this.developers = json.developer
    if (this.developers === undefined) {
      this.developers = []
    }
    this.developers = this.developers.sort()
    this.emailAddress = json.developer_email_list
    this.issueTrackers = json.issue_tracker
    this.repositories = json.source_repositories
    this.buildServices = json.build_service
    this.codeReviews = json.code_review

    this.blueprintUrl = json.blueprint_location
    this.blueprintName
    if (this.blueprintUrl !== undefined) {
      const jsonData = json.blueprint_location
      const repoName = jsonData.repository.github_repository.name
      this.blueprintUrl = `https://git-aws.internal.justin.tv/${repoName}/blob/master/${jsonData.path}`
      this.blueprintName = `${repoName}/${jsonData.path}`
    }
  }

  get techLeadsStr () {
    let str = ''
    let maxIdx = this.techLeads.length - 1
    this.techLeads.forEach((techLead, idx) => {
      str += techLead
      if (idx < maxIdx) {
        str += ', '
      }
    })
    return str
  }

  get techLeadsHtml () {
    let components = []
    let maxIdx = this.techLeads.length - 1
    this.techLeads.forEach((techLead, idx) => {
      components.push(<a href={`https://git-aws.internal.justin.tv/${techLead}`} key={idx}>{techLead}</a>)
      if (idx < maxIdx) {
        components.push(<span key={`${idx}.0`}>, </span>)
      }
    })
    return components
  }

  get techLeadsUrl () {
    let techLeads = {}
    this.techLeads.forEach((techLead) => {
      techLeads[techLead] = `https://git-aws.internal.justin.tv/${techLead}`
    })
    return techLeads
  }

  get developersUrl () {
    let developers = {}
    this.developers.forEach((developer) => {
      developers[developer] = `https://git-aws.internal.justin.tv/${developer}`
    })
    return developers
  }

  get lastUpdatedStr () {
    const elapsedStr = Utils.getElaspedTimeStr(this.lastUpdated)
    let lastUpdated = ''
    if (elapsedStr !== undefined) {
      lastUpdated = `Last updated ${elapsedStr} ago`
    }
    return lastUpdated
  }
}
