/**
 * Represents a Service that was retrieved from our API.  Services can contain other Services within them, which are
 * represented by their children.  Services may also have a type indicating what type of service is it.
 */

export default class Service {
  constructor (id, name, type) {
    this.children = []
    this.id = id
    this.name = name
    this.type = type
    this.info = undefined
    this.avatar = '/avatar.png'
    this.hasMetrics = true
    this.parent = undefined
  }

  addChild (child) {
    this.children.push(child.id)
    child.parent = this.id
  }

  get url () {
    return `/${this.type.name.toLowerCase()}s/${this.id}`
  }

  compareNameTo (serviceB) {
    if (this.name < serviceB.name) {
      return -1
    } else if (this.name > serviceB.name) {
      return 1
    } else {
      return 0
    }
  }
}
