import {
  REQUEST_SERVICES,
  RECEIVE_SERVICES,
  RECEIVE_ORG_INFO,
  RECEIVE_TEAM_INFO,
  RECEIVE_PROJECT_INFO
} from '../actions'

export const services = (state = {}, action) => {
  switch (action.type) {
    case REQUEST_SERVICES:
      return state
    case RECEIVE_SERVICES:
      return Object.assign({}, action.services)
    case RECEIVE_ORG_INFO:
    case RECEIVE_TEAM_INFO:
    case RECEIVE_PROJECT_INFO:
      if (state[action.serviceId] === undefined) {
        console.error('Recieved service_info for a non-existent service!')
        return state
      }
      let newState = Object.assign({}, state)
      newState[action.serviceId].info = action.serviceInfo
      return newState
    default:
      return state
  }
}

export const orgIds = (state = [], action) => {
  switch (action.type) {
    case REQUEST_SERVICES:
      return state
    case RECEIVE_SERVICES:
      return Object.assign([], action.orgIds)
    default:
      return state
  }
}

export const projectIds = (state = [], action) => {
  switch (action.type) {
    case REQUEST_SERVICES:
      return state
    case RECEIVE_SERVICES:
      return Object.assign([], action.projectIds)
    default:
      return state
  }
}

export const teamIds = (state = [], action) => {
  switch (action.type) {
    case REQUEST_SERVICES:
      return state
    case RECEIVE_SERVICES:
      return Object.assign([], action.teamIds)
    default:
      return state
  }
}
