import ApiUtil from 'utils/ApiUtil'
import { browserHistory } from 'react-router'

export const ENROLL_PROJECT = 'ENROLL_PROJECT'
export const ENROLL_PROJECT_ERROR = 'ENROLL_PROJECT_ERROR'

export function enrollProjectJson (json, projectId, projectName) {
  return function (dispatch, getState) {
    dispatch(startProjectEnroll(json))
    return ApiUtil.postProjectJson(json)
      .then(jsonReponse => {})
      .catch((error) => { dispatch(projectEnrolledError(error)) })
      .then(() => { browserHistory.push(`/enroll/id=${projectId}/name=${projectName}`) })
  }
}

function startProjectEnroll (json) {
  return {
    type: ENROLL_PROJECT
  }
}

function projectEnrolledError (error) {
  console.log('-------->', error)
  return {
    type: ENROLL_PROJECT_ERROR,
    error: error
  }
}
