import { connect } from 'react-redux'
import EnrollForm from '../components/EnrollForm'
import { ServiceType } from 'modules/api_data/types'

const mapStateToProps = (state, ownProps) => {
  let orgs = state.api_data.orgIds.map((orgId) => {
    return state.api_data.services[orgId]
  })

  let teams = []
  Object.keys(state.api_data.services).forEach((serviceId) => {
    const service = state.api_data.services[serviceId]
    if (service.type === ServiceType.TEAM) {
      teams.push(service)
    }
  })

  return {
    services: state.api_data.services,
    orgs: orgs
  }
}

export default connect(mapStateToProps)(EnrollForm)
